/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.economy;

import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import eu.mrneznamy.mrultimateshop.economy.EconomyProvider;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class MrVoteTrainEconomyProvider
implements EconomyProvider {
    private final Plugin plugin;
    private Object voteTrainAPI;

    public MrVoteTrainEconomyProvider(Plugin plugin) {
        this.plugin = plugin;
        this.voteTrainAPI = null;
        Plugin voteTrainPlugin = Bukkit.getPluginManager().getPlugin("MrVoteTrain");
        if (voteTrainPlugin != null) {
            try {
                Class<?> apiClass = Class.forName("eu.mrneznamy.mrVoteTrain.MrVoteTrain");
                this.voteTrainAPI = apiClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                MrLibConsoleSayer.MrSay_Success((String)"[MrUltimateShop] MrVoteTrain economy provider enabled!");
            }
            catch (Exception e) {
                MrLibConsoleSayer.MrSay_Error((String)("[MrUltimateShop] Failed to hook into MrVoteTrain: " + e.getMessage()));
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.voteTrainAPI != null;
    }

    @Override
    public String getName() {
        return "MrVoteTrain";
    }

    @Override
    public boolean hasAccount(OfflinePlayer player) {
        return this.isEnabled();
    }

    @Override
    public double getBalance(OfflinePlayer player) {
        if (!this.isEnabled()) {
            return 0.0;
        }
        try {
            Class<?> apiClass = this.voteTrainAPI.getClass();
            Object result = apiClass.getMethod("getVoteBodies", OfflinePlayer.class).invoke(this.voteTrainAPI, player);
            if (result instanceof Integer) {
                return ((Integer)result).doubleValue();
            }
            if (result instanceof Double) {
                return (Double)result;
            }
            return 0.0;
        }
        catch (Exception e) {
            MrLibConsoleSayer.MrSay_Error((String)("[MrUltimateShop] Error getting vote bodies for " + player.getName() + ": " + e.getMessage()));
            return 0.0;
        }
    }

    @Override
    public boolean has(OfflinePlayer player, double amount) {
        return this.getBalance(player) >= amount;
    }

    @Override
    public boolean withdraw(OfflinePlayer player, double amount) {
        if (!this.isEnabled()) {
            return false;
        }
        try {
            Class<?> apiClass = this.voteTrainAPI.getClass();
            int bodies = (int)Math.ceil(amount);
            if (!this.has(player, bodies)) {
                return false;
            }
            apiClass.getMethod("removeVoteBodies", OfflinePlayer.class, Integer.TYPE).invoke(this.voteTrainAPI, player, bodies);
            return true;
        }
        catch (Exception e) {
            MrLibConsoleSayer.MrSay_Error((String)("[MrUltimateShop] Error withdrawing vote bodies from " + player.getName() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public boolean deposit(OfflinePlayer player, double amount) {
        if (!this.isEnabled()) {
            return false;
        }
        try {
            Class<?> apiClass = this.voteTrainAPI.getClass();
            int bodies = (int)Math.ceil(amount);
            apiClass.getMethod("addVoteBodies", OfflinePlayer.class, Integer.TYPE).invoke(this.voteTrainAPI, player, bodies);
            return true;
        }
        catch (Exception e) {
            MrLibConsoleSayer.MrSay_Error((String)("[MrUltimateShop] Error depositing vote bodies to " + player.getName() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public String format(double amount) {
        int bodies = (int)Math.ceil(amount);
        return bodies + " Vote Bodies";
    }

    @Override
    public String getCurrencySymbol() {
        return " VB";
    }
}

