/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.economy;

import eu.mrneznamy.mrlibcore.economy.MrLibVaultManager;
import eu.mrneznamy.mrultimateshop.economy.EconomyProvider;
import org.bukkit.OfflinePlayer;

public class VaultEconomyProvider
implements EconomyProvider {
    private final MrLibVaultManager vaultManager = MrLibVaultManager.getInstance();

    @Override
    public boolean isEnabled() {
        return this.vaultManager != null;
    }

    @Override
    public String getName() {
        return "Vault";
    }

    @Override
    public boolean hasAccount(OfflinePlayer player) {
        return this.isEnabled();
    }

    @Override
    public double getBalance(OfflinePlayer player) {
        if (!this.isEnabled()) {
            return 0.0;
        }
        return this.vaultManager.getBalance(player.getPlayer());
    }

    @Override
    public boolean has(OfflinePlayer player, double amount) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.getBalance(player) >= amount;
    }

    @Override
    public boolean withdraw(OfflinePlayer player, double amount) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.vaultManager.withdraw(player, amount);
    }

    @Override
    public boolean deposit(OfflinePlayer player, double amount) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.vaultManager.deposit(player, amount);
    }

    @Override
    public String format(double amount) {
        if (!this.isEnabled()) {
            return String.format("%.2f", amount);
        }
        return this.vaultManager.format(amount);
    }

    @Override
    public String getCurrencySymbol() {
        return "$";
    }
}

