/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.integration;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MrCommunityQuestIntegration {
    private static MrCommunityQuestIntegration instance;
    private MrUltimateShop plugin;
    private boolean isEnabled = false;
    private Object mrCommunityQuestPlugin;

    private MrCommunityQuestIntegration(MrUltimateShop plugin) {
        this.plugin = plugin;
        this.checkAndEnableIntegration();
    }

    public static MrCommunityQuestIntegration getInstance(MrUltimateShop plugin) {
        if (instance == null) {
            instance = new MrCommunityQuestIntegration(plugin);
        }
        return instance;
    }

    private void checkAndEnableIntegration() {
        Plugin communityQuestPlugin = Bukkit.getPluginManager().getPlugin("MrCommunityQuest");
        if (communityQuestPlugin != null && communityQuestPlugin.isEnabled()) {
            this.mrCommunityQuestPlugin = communityQuestPlugin;
            this.isEnabled = true;
        } else {
            this.isEnabled = false;
        }
    }

    public void processPurchase(Player player, ItemStack item, int quantity, double price) {
        if (!this.isEnabled) {
            return;
        }
        try {
            Plugin communityQuest = Bukkit.getPluginManager().getPlugin("MrCommunityQuest");
            if (communityQuest == null) {
                this.plugin.getLogger().warning("MrCommunityQuest plugin not found");
                return;
            }
            Object listener = communityQuest.getClass().getMethod("getMrUltimateShopListener", new Class[0]).invoke((Object)communityQuest, new Object[0]);
            if (listener == null) {
                this.plugin.getLogger().warning("MrUltimateShopListener not found in MrCommunityQuest");
                return;
            }
            String itemMaterial = item.getType().name();
            listener.getClass().getMethod("processPurchase", Player.class, String.class, Integer.TYPE, Double.TYPE).invoke(listener, player, itemMaterial, quantity, price);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to process purchase for MrCommunityQuest: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void processSale(Player player, ItemStack item, int quantity, double price) {
        if (!this.isEnabled) {
            return;
        }
        try {
            Plugin communityQuest = Bukkit.getPluginManager().getPlugin("MrCommunityQuest");
            if (communityQuest == null) {
                this.plugin.getLogger().warning("MrCommunityQuest plugin not found");
                return;
            }
            Object listener = communityQuest.getClass().getMethod("getMrUltimateShopListener", new Class[0]).invoke((Object)communityQuest, new Object[0]);
            if (listener == null) {
                this.plugin.getLogger().warning("MrUltimateShopListener not found in MrCommunityQuest");
                return;
            }
            String itemMaterial = item.getType().name();
            listener.getClass().getMethod("processSale", Player.class, String.class, Integer.TYPE, Double.TYPE).invoke(listener, player, itemMaterial, quantity, price);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to process sale for MrCommunityQuest: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }
}

