/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.integration;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.api.CustomItemProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;

public class OraxenIntegration
implements CustomItemProvider {
    private final MrUltimateShop plugin;
    private Class<?> oraxenAPIClass;
    private Method getItemMethod;
    private Method existsMethod;
    private Method getItemIDMethod;

    public OraxenIntegration(MrUltimateShop plugin) {
        this.plugin = plugin;
        this.initializeReflection();
    }

    private void initializeReflection() {
        try {
            String[] possibleClasses;
            for (String className : possibleClasses = new String[]{"io.th0rgal.oraxen.api.OraxenItems", "io.th0rgal.oraxen.items.OraxenItems", "io.th0rgal.oraxen.api.OraxenAPI", "io.th0rgal.oraxen.OraxenPlugin"}) {
                try {
                    this.oraxenAPIClass = Class.forName(className);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            if (this.oraxenAPIClass != null) {
                String[] getItemIDMethods;
                String[] existsMethods;
                String[] getItemMethods;
                for (String methodName : getItemMethods = new String[]{"getItemById", "getItem", "getItemStack", "getItemByName"}) {
                    try {
                        this.getItemMethod = this.oraxenAPIClass.getMethod(methodName, String.class);
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
                for (String methodName : existsMethods = new String[]{"exists", "hasItem", "isItem", "itemExists"}) {
                    try {
                        this.existsMethod = this.oraxenAPIClass.getMethod(methodName, String.class);
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
                for (String methodName : getItemIDMethods = new String[]{"getIdByItem", "getItemId", "getItemName"}) {
                    try {
                        this.getItemIDMethod = this.oraxenAPIClass.getMethod(methodName, ItemStack.class);
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
                if (this.getItemMethod == null) {
                    this.plugin.getLogger().warning("Could not find any getItem method in Oraxen API");
                }
                if (this.existsMethod == null) {
                    this.plugin.getLogger().warning("Could not find any exists method in Oraxen API");
                }
            } else {
                this.plugin.getLogger().warning("Could not find any Oraxen API class");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to initialize Oraxen reflection: " + e.getMessage());
        }
    }

    @Override
    public String getPluginName() {
        return "Oraxen";
    }

    @Override
    public ItemStack getCustomItem(String itemName) {
        block9: {
            if (!this.hasCustomItem(itemName)) {
                return null;
            }
            try {
                if (this.getItemMethod == null) break block9;
                Object item = this.getItemMethod.invoke(null, itemName);
                if (item instanceof ItemStack) {
                    return (ItemStack)item;
                }
                if (item == null) break block9;
                try {
                    String[] getItemStackMethods;
                    for (String methodName : getItemStackMethods = new String[]{"getItemStack", "build", "toItemStack", "createItemStack"}) {
                        try {
                            Method getItemStackMethod = item.getClass().getMethod(methodName, new Class[0]);
                            Object itemStack = getItemStackMethod.invoke(item, new Object[0]);
                            if (!(itemStack instanceof ItemStack)) continue;
                            return (ItemStack)itemStack;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    this.plugin.getLogger().warning("Could not convert Oraxen item to ItemStack: " + item.getClass().getSimpleName());
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Could not get ItemStack from Oraxen item: " + e.getMessage());
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error getting Oraxen item '" + itemName + "': " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public boolean hasCustomItem(String itemName) {
        try {
            if (this.existsMethod != null) {
                return (Boolean)this.existsMethod.invoke(null, itemName);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error checking Oraxen item '" + itemName + "': " + e.getMessage());
        }
        return false;
    }

    @Override
    public String[] getAvailableItems() {
        ArrayList items = new ArrayList();
        return items.toArray(new String[0]);
    }

    @Override
    public String getCustomItemDisplayName(String itemName) {
        try {
            ItemStack item;
            if (this.getItemMethod != null && (item = (ItemStack)this.getItemMethod.invoke(null, itemName)) != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
                return item.getItemMeta().getDisplayName();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error getting Oraxen item display name for '" + itemName + "': " + e.getMessage());
        }
        return null;
    }

    @Override
    public boolean isAvailable() {
        try {
            return Bukkit.getPluginManager().getPlugin("Oraxen") != null && this.oraxenAPIClass != null && this.getItemMethod != null && this.existsMethod != null && this.getItemIDMethod != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

