/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.managers;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.api.MrUltimateShopAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class BuySellMenuManager
implements Listener {
    private final MrUltimateShop plugin;
    private final Map<Player, BuySellSession> activeSessions;
    private FileConfiguration buyGuiConfig;
    private FileConfiguration sellGuiConfig;

    public BuySellMenuManager(MrUltimateShop plugin) {
        this.plugin = plugin;
        this.activeSessions = new HashMap<Player, BuySellSession>();
        this.loadConfigurations();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void loadConfigurations() {
        this.loadBuyGuiConfig();
        this.loadSellGuiConfig();
    }

    private void loadBuyGuiConfig() {
        File buyGuiFile = new File(this.plugin.getDataFolder(), "buy-gui.yml");
        this.buyGuiConfig = YamlConfiguration.loadConfiguration((File)buyGuiFile);
    }

    private void loadSellGuiConfig() {
        File sellGuiFile = new File(this.plugin.getDataFolder(), "sell-gui.yml");
        this.sellGuiConfig = YamlConfiguration.loadConfiguration((File)sellGuiFile);
    }

    public void openBuyMenu(Player player, ConfigurationSection itemSection) {
        this.openBuySellMenu(player, itemSection, "", "Buy");
    }

    public void openSellMenu(Player player, ConfigurationSection itemSection) {
        String itemType = itemSection.getString("type", "VANILLA").toUpperCase();
        if ("COMMAND".equals(itemType)) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.cannot-sell-command-item", "&cYou cannot sell command items!"));
            return;
        }
        this.openBuySellMenu(player, itemSection, "", "Sell");
    }

    public void openBuySellMenu(Player player, ConfigurationSection itemSection) {
        boolean sellEnabled = itemSection.getBoolean("Sell.Enable", false);
        String itemType = itemSection.getString("type", "VANILLA").toUpperCase();
        if (sellEnabled && "COMMAND".equals(itemType)) {
            sellEnabled = false;
        }
        String action = "Buy";
        if (sellEnabled) {
            action = "BuySell";
        }
        this.openBuySellMenu(player, itemSection, "", action);
    }

    public void openBuySellMenu(Player player, ConfigurationSection itemSection, String shopName, String action) {
        int configQuantity;
        Material material;
        String itemName = MrLibColors.colorize((String)itemSection.getString("Name", "&fItem"));
        String materialString = itemSection.getString("Material", "STONE");
        if (materialString.contains(":")) {
            material = Material.STONE;
        } else {
            try {
                material = Material.valueOf((String)materialString);
            }
            catch (IllegalArgumentException e) {
                material = Material.STONE;
            }
        }
        int initialQuantity = configQuantity = itemSection.getInt("quantity", 1);
        if ("Buy".equals(action)) {
            int freeSlots = this.getFreeInventorySlots(player);
            int maxStackSize = material.getMaxStackSize();
            int maxBuyable = maxStackSize == 1 ? freeSlots : (maxStackSize == 16 ? freeSlots * maxStackSize : freeSlots * maxStackSize);
            initialQuantity = Math.min(configQuantity, maxBuyable);
        } else if ("Sell".equals(action)) {
            ItemStack shopItem = this.createShopItemForComparison(itemSection);
            int itemsInInventory = this.getMatchingItemsInInventory(player, shopItem);
            initialQuantity = Math.min(configQuantity, itemsInInventory);
        }
        if (initialQuantity <= 0) {
            if ("Buy".equals(action)) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.no-inventory-space", "&cYou don't have enough inventory space!"));
            } else {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.no-items-to-sell", "&cYou don't have any items to sell!"));
            }
            return;
        }
        BuySellSession session = new BuySellSession(itemSection, shopName, action, initialQuantity);
        this.activeSessions.put(player, session);
        this.createBuySellInventory(player, session);
    }

    private int getFreeInventorySlots(Player player) {
        int freeSlots = 0;
        for (ItemStack item : player.getInventory().getStorageContents()) {
            if (item != null && item.getType() != Material.AIR) continue;
            ++freeSlots;
        }
        return freeSlots;
    }

    private int getItemsInInventory(Player player, Material material) {
        int count = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material) continue;
            count += item.getAmount();
        }
        return count;
    }

    private void createBuySellInventory(Player player, BuySellSession session) {
        ConfigurationSection inventoryInfoSection;
        ConfigurationSection actionSection;
        ConfigurationSection quantitySection;
        ConfigurationSection itemDisplaySection;
        ConfigurationSection decorationsSection;
        FileConfiguration config = "Buy".equals(session.action) ? this.buyGuiConfig : this.sellGuiConfig;
        String configSection = config == this.buyGuiConfig ? "Buy-GUI" : "Sell-GUI";
        String title = MrLibColors.colorize((String)config.getString(configSection + ".Title", "&6[action] - [item]").replace("[action]", session.action).replace("[item]", this.getItemDisplayName(session.itemSection)).replace("[quantity]", String.valueOf(session.quantity)));
        int size = config.getInt(configSection + ".Size", 54);
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)title);
        ConfigurationSection backgroundSection = config.getConfigurationSection(configSection + ".Background");
        if (backgroundSection != null) {
            Material backgroundMaterial;
            try {
                backgroundMaterial = Material.valueOf((String)backgroundSection.getString("Material", "GRAY_STAINED_GLASS_PANE"));
            }
            catch (IllegalArgumentException e) {
                backgroundMaterial = Material.GRAY_STAINED_GLASS_PANE;
            }
            ItemStack background = new ItemStack(backgroundMaterial);
            ItemMeta backgroundMeta = background.getItemMeta();
            backgroundMeta.setDisplayName(MrLibColors.colorize((String)backgroundSection.getString("Name", " ")));
            background.setItemMeta(backgroundMeta);
            List slots = backgroundSection.getIntegerList("Slots");
            Iterator iterator = slots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot < 0 || slot >= size) continue;
                inventory.setItem(slot, background);
            }
        }
        if ((decorationsSection = config.getConfigurationSection(configSection + ".Decorations")) != null) {
            for (String decorationKey : decorationsSection.getKeys(false)) {
                Object slotsString;
                Material decorationMaterial;
                ConfigurationSection decorationSection = decorationsSection.getConfigurationSection(decorationKey);
                if (decorationSection == null) continue;
                try {
                    decorationMaterial = Material.valueOf((String)decorationSection.getString("Material", "GRAY_STAINED_GLASS_PANE"));
                }
                catch (IllegalArgumentException e) {
                    decorationMaterial = Material.GRAY_STAINED_GLASS_PANE;
                }
                ItemStack decoration = new ItemStack(decorationMaterial);
                ItemMeta decorationMeta = decoration.getItemMeta();
                decorationMeta.setDisplayName(MrLibColors.colorize((String)decorationSection.getString("Name", " ")));
                boolean glowing = decorationSection.getBoolean("Glowing", false);
                if (glowing) {
                    decorationMeta.addEnchant(Enchantment.UNBREAKING, 1, true);
                    decorationMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                }
                decoration.setItemMeta(decorationMeta);
                List<Integer> slots = new ArrayList();
                if (decorationSection.contains("Slots")) {
                    if (decorationSection.isList("Slots")) {
                        slots = decorationSection.getIntegerList("Slots");
                    } else {
                        slotsString = decorationSection.getString("Slots", "");
                        if (!((String)slotsString).isEmpty()) {
                            String[] slotStrings;
                            for (String slotString : slotStrings = ((String)slotsString).split(",")) {
                                try {
                                    slots.add(Integer.parseInt(slotString.trim()));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                slotsString = slots.iterator();
                while (slotsString.hasNext()) {
                    int slot = (Integer)slotsString.next();
                    if (slot < 0 || slot >= size) continue;
                    inventory.setItem(slot, decoration);
                }
            }
        }
        if ((itemDisplaySection = config.getConfigurationSection(configSection + ".Main-Item")) != null) {
            ItemStack displayItem;
            int slot = itemDisplaySection.getInt("Slot", 22);
            String materialString = session.itemSection.getString("Material", "STONE");
            if (materialString.contains(":")) {
                String[] parts = materialString.split(":", 2);
                if (parts.length == 2) {
                    String pluginName = parts[0];
                    String itemName = parts[1];
                    displayItem = MrUltimateShopAPI.getCustomItem(pluginName, itemName);
                    if (displayItem == null) {
                        displayItem = new ItemStack(Material.STONE, session.quantity);
                    } else {
                        displayItem = displayItem.clone();
                        displayItem.setAmount(Math.min(session.quantity, displayItem.getMaxStackSize()));
                    }
                } else {
                    displayItem = new ItemStack(Material.STONE, session.quantity);
                }
            } else {
                try {
                    Material material = Material.valueOf((String)materialString.toUpperCase());
                    displayItem = new ItemStack(material, Math.min(session.quantity, material.getMaxStackSize()));
                }
                catch (IllegalArgumentException e) {
                    displayItem = new ItemStack(Material.STONE, session.quantity);
                }
            }
            ItemMeta displayMeta = displayItem.getItemMeta();
            String itemName = MrLibColors.colorize((String)itemDisplaySection.getString("Name", "&f[item]").replace("[item]", this.getItemDisplayName(session.itemSection)).replace("[quantity]", String.valueOf(session.quantity)));
            displayMeta.setDisplayName(itemName);
            double configuredPrice = this.getPrice(session);
            int configuredQuantity = session.itemSection.getInt("quantity", 1);
            double pricePerItem = configuredPrice / (double)configuredQuantity;
            double totalPrice = this.calculateTotalPrice(session, session.quantity);
            String currencySymbol = this.getCurrencySymbol(session.itemSection);
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : itemDisplaySection.getStringList("Lore")) {
                lore.add(MrLibColors.colorize((String)line.replace("[quantity]", String.valueOf(session.quantity)).replace("[price-per-item]", String.format("%.2f", pricePerItem) + " " + currencySymbol).replace("[total-price]", String.format("%.2f", totalPrice) + " " + currencySymbol)));
            }
            displayMeta.setLore(lore);
            displayItem.setItemMeta(displayMeta);
            inventory.setItem(slot, displayItem);
        }
        if ((quantitySection = config.getConfigurationSection(configSection + ".Quantity-Buttons")) != null) {
            this.createQuantityButton(inventory, quantitySection, "Decrease-64", -64, session);
            this.createQuantityButton(inventory, quantitySection, "Decrease-16", -16, session);
            this.createQuantityButton(inventory, quantitySection, "Decrease-1", -1, session);
            this.createQuantityButton(inventory, quantitySection, "Increase-1", 1, session);
            this.createQuantityButton(inventory, quantitySection, "Increase-16", 16, session);
            this.createQuantityButton(inventory, quantitySection, "Increase-64", 64, session);
            ConfigurationSection currentSection = quantitySection.getConfigurationSection("Current-Amount");
            if (currentSection != null) {
                Material material;
                int slot = currentSection.getInt("Slot", 13);
                try {
                    material = Material.valueOf((String)currentSection.getString("Material", "YELLOW_STAINED_GLASS_PANE"));
                }
                catch (IllegalArgumentException e) {
                    material = Material.YELLOW_STAINED_GLASS_PANE;
                }
                ItemStack currentItem = new ItemStack(material);
                ItemMeta currentMeta = currentItem.getItemMeta();
                double totalPrice = this.calculateTotalPrice(session, session.quantity);
                String currencySymbol = this.getCurrencySymbol(session.itemSection);
                String currentName = MrLibColors.colorize((String)currentSection.getString("Name", "&eQuantity: [quantity]").replace("[quantity]", String.valueOf(session.quantity)));
                currentMeta.setDisplayName(currentName);
                ArrayList<String> currentLore = new ArrayList<String>();
                for (String line : currentSection.getStringList("Lore")) {
                    currentLore.add(MrLibColors.colorize((String)line.replace("[quantity]", String.valueOf(session.quantity)).replace("[total-price]", String.format("%.2f", totalPrice) + " " + currencySymbol)));
                }
                currentMeta.setLore(currentLore);
                currentItem.setItemMeta(currentMeta);
                inventory.setItem(slot, currentItem);
            }
        }
        if ((actionSection = config.getConfigurationSection(configSection + ".Action-Buttons")) != null) {
            this.createActionButton(inventory, actionSection, "Confirm", session, player);
            this.createActionButton(inventory, actionSection, "Cancel", session, player);
        }
        if ((inventoryInfoSection = config.getConfigurationSection(configSection + ".Inventory-Info")) != null) {
            Material material;
            int slot = inventoryInfoSection.getInt("Slot", 31);
            try {
                material = Material.valueOf((String)inventoryInfoSection.getString("Material", "CHEST"));
            }
            catch (IllegalArgumentException e) {
                material = Material.CHEST;
            }
            ItemStack infoItem = new ItemStack(material);
            ItemMeta infoMeta = infoItem.getItemMeta();
            if ("Buy".equals(session.action)) {
                Material itemMaterial;
                int freeSlots = this.getFreeInventorySlots(player);
                String materialString = session.itemSection.getString("Material", "STONE");
                if (materialString.contains(":")) {
                    itemMaterial = Material.STONE;
                } else {
                    try {
                        itemMaterial = Material.valueOf((String)materialString);
                    }
                    catch (IllegalArgumentException e) {
                        itemMaterial = Material.STONE;
                    }
                }
                int maxStackSize = itemMaterial.getMaxStackSize();
                int maxBuyable = maxStackSize == 1 ? freeSlots : (maxStackSize == 16 ? freeSlots * maxStackSize : freeSlots * maxStackSize);
                String infoName = MrLibColors.colorize((String)inventoryInfoSection.getString("Name", "&bInventory Space").replace("[free-slots]", String.valueOf(freeSlots)).replace("[max-buyable]", String.valueOf(maxBuyable)));
                infoMeta.setDisplayName(infoName);
                ArrayList<String> infoLore = new ArrayList<String>();
                for (String line : inventoryInfoSection.getStringList("Lore")) {
                    infoLore.add(MrLibColors.colorize((String)line.replace("[free-slots]", String.valueOf(freeSlots)).replace("[max-buyable]", String.valueOf(maxBuyable))));
                }
                infoMeta.setLore(infoLore);
            } else if ("Sell".equals(session.action)) {
                int itemsInInventory;
                Material itemMaterial;
                String materialString = session.itemSection.getString("Material", "STONE");
                try {
                    itemMaterial = materialString.contains(":") ? Material.STONE : Material.valueOf((String)materialString);
                }
                catch (IllegalArgumentException e) {
                    itemMaterial = Material.STONE;
                }
                int maxSellable = itemsInInventory = this.getItemsInInventory(player, itemMaterial);
                String infoName = MrLibColors.colorize((String)inventoryInfoSection.getString("Name", "&bYour Items").replace("[items-in-inventory]", String.valueOf(itemsInInventory)).replace("[max-sellable]", String.valueOf(maxSellable)));
                infoMeta.setDisplayName(infoName);
                ArrayList<String> infoLore = new ArrayList<String>();
                for (String line : inventoryInfoSection.getStringList("Lore")) {
                    infoLore.add(MrLibColors.colorize((String)line.replace("[items-in-inventory]", String.valueOf(itemsInInventory)).replace("[max-sellable]", String.valueOf(maxSellable))));
                }
                infoMeta.setLore(infoLore);
            }
            infoItem.setItemMeta(infoMeta);
            inventory.setItem(slot, infoItem);
        }
        player.openInventory(inventory);
    }

    private void createQuantityButton(Inventory inventory, ConfigurationSection quantitySection, String buttonKey, int change, BuySellSession session) {
        ConfigurationSection buttonSection = quantitySection.getConfigurationSection(buttonKey);
        if (buttonSection != null) {
            Material material;
            int slot = buttonSection.getInt("Slot", 0);
            try {
                material = Material.valueOf((String)buttonSection.getString("Material", "STONE"));
            }
            catch (IllegalArgumentException e) {
                material = Material.STONE;
            }
            ItemStack button = new ItemStack(material);
            ItemMeta meta = button.getItemMeta();
            String name = MrLibColors.colorize((String)buttonSection.getString("Name", "&fButton").replace("[change]", String.valueOf(Math.abs(change))).replace("[quantity]", String.valueOf(session.quantity)));
            meta.setDisplayName(name);
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : buttonSection.getStringList("Lore")) {
                lore.add(MrLibColors.colorize((String)line.replace("[change]", String.valueOf(Math.abs(change))).replace("[quantity]", String.valueOf(session.quantity))));
            }
            meta.setLore(lore);
            button.setItemMeta(meta);
            inventory.setItem(slot, button);
        }
    }

    private void createActionButton(Inventory inventory, ConfigurationSection actionSection, String buttonKey, BuySellSession session, Player player) {
        ConfigurationSection buttonSection = actionSection.getConfigurationSection(buttonKey);
        if (buttonSection != null) {
            int slot = buttonSection.getInt("Slot", 0);
            Material material = Material.valueOf((String)buttonSection.getString("Material", "STONE"));
            ItemStack button = new ItemStack(material);
            ItemMeta meta = button.getItemMeta();
            double price = this.calculateTotalPrice(session, session.quantity);
            String currencySymbol = this.getCurrencySymbol(session.itemSection);
            double currentBalance = 0.0;
            double balanceAfter = 0.0;
            if (this.plugin.getEconomyManager() != null) {
                currentBalance = this.plugin.getEconomyManager().getBalance(player);
                balanceAfter = "Buy".equals(session.action) ? currentBalance - price : currentBalance + price;
            }
            String name = MrLibColors.colorize((String)buttonSection.getString("Name", "&fButton").replace("[action]", session.action).replace("[price]", String.format("%.2f", price) + " " + currencySymbol).replace("[quantity]", String.valueOf(session.quantity)).replace("[item]", this.getItemDisplayName(session.itemSection)).replace("[total-price]", String.format("%.2f", price) + " " + currencySymbol).replace("[balance]", String.format("%.2f", currentBalance) + " " + currencySymbol).replace("[balance-after]", String.format("%.2f", balanceAfter) + " " + currencySymbol));
            meta.setDisplayName(name);
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : buttonSection.getStringList("Lore")) {
                lore.add(MrLibColors.colorize((String)line.replace("[action]", session.action.toLowerCase()).replace("[price]", String.format("%.2f", price) + " " + currencySymbol).replace("[quantity]", String.valueOf(session.quantity)).replace("[item]", this.getItemDisplayName(session.itemSection)).replace("[total-price]", String.format("%.2f", price) + " " + currencySymbol).replace("[balance]", String.format("%.2f", currentBalance) + " " + currencySymbol).replace("[balance-after]", String.format("%.2f", balanceAfter) + " " + currencySymbol)));
            }
            meta.setLore(lore);
            button.setItemMeta(meta);
            inventory.setItem(slot, button);
        }
    }

    private double getPrice(BuySellSession session) {
        ItemStack itemStack;
        double basePrice = session.action.equals("Buy") ? session.itemSection.getDouble("Buy.Price", 1.0) : session.itemSection.getDouble("Sell.Price", 1.0);
        boolean trackingEnabled = session.itemSection.getBoolean("Tracker", true);
        if (trackingEnabled && this.plugin.getDemandTrackerManager() != null && (itemStack = this.createItemToGive(session.itemSection, 1)) != null) {
            String materialString = session.itemSection.getString("Material", "STONE");
            if (session.action.equals("Buy")) {
                return this.plugin.getDemandTrackerManager().getDynamicBuyPrice(itemStack, basePrice, materialString);
            }
            return this.plugin.getDemandTrackerManager().getDynamicSellPrice(itemStack, basePrice, materialString);
        }
        return basePrice;
    }

    private double calculateTotalPrice(BuySellSession session, int quantity) {
        double configuredPrice = this.getPrice(session);
        int configuredQuantity = session.itemSection.getInt("quantity", 1);
        double pricePerItem = configuredPrice / (double)configuredQuantity;
        return pricePerItem * (double)quantity;
    }

    private String getCurrencySymbol() {
        return this.plugin.getEconomyManager().getCurrencySymbol();
    }

    private String getCurrencySymbol(ConfigurationSection itemSection) {
        return this.plugin.getEconomyManager().getCurrencySymbol();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        FileConfiguration config;
        String configSection;
        FileConfiguration titleConfig;
        String expectedTitle;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        BuySellSession session = this.activeSessions.get(player);
        if (session == null) {
            return;
        }
        Inventory topInventory = event.getView().getTopInventory();
        if (!event.getClickedInventory().equals((Object)topInventory)) {
            return;
        }
        String title = event.getView().getTitle();
        if (!title.equals(expectedTitle = MrLibColors.colorize((String)(titleConfig = "Buy".equals(session.action) ? this.buyGuiConfig : this.sellGuiConfig).getString((configSection = titleConfig == this.buyGuiConfig ? "Buy-GUI" : "Sell-GUI") + ".Title", "&6[action] - [item]").replace("[action]", session.action).replace("[item]", this.getItemDisplayName(session.itemSection)).replace("[quantity]", String.valueOf(session.quantity))))) {
            return;
        }
        int slot = event.getSlot();
        FileConfiguration fileConfiguration = config = "Buy".equals(session.action) ? this.buyGuiConfig : this.sellGuiConfig;
        if (this.isDecorationSlot(config, slot, session)) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        if (this.isQuantityButton(config, slot, "Decrease-1", session)) {
            this.handleQuantityChange(player, session, -1);
        } else if (this.isQuantityButton(config, slot, "Increase-1", session)) {
            this.handleQuantityChange(player, session, 1);
        } else if (this.isQuantityButton(config, slot, "Increase-16", session)) {
            this.handleQuantityChange(player, session, 16);
        } else if (this.isQuantityButton(config, slot, "Increase-64", session)) {
            this.handleQuantityChange(player, session, 64);
        } else if (this.isQuantityButton(config, slot, "Decrease-16", session)) {
            this.handleQuantityChange(player, session, -16);
        } else if (this.isQuantityButton(config, slot, "Decrease-64", session)) {
            this.handleQuantityChange(player, session, -64);
        } else if (this.isActionButton(config, slot, "Confirm", session)) {
            this.handleConfirm(player, session);
        } else if (this.isActionButton(config, slot, "Cancel", session)) {
            this.handleCancel(player, session);
        }
    }

    private boolean isQuantityButton(FileConfiguration config, int slot, String buttonKey, BuySellSession session) {
        String configSection = config == this.buyGuiConfig ? "Buy-GUI" : "Sell-GUI";
        ConfigurationSection quantitySection = config.getConfigurationSection(configSection + ".Quantity-Buttons");
        if (quantitySection != null) {
            ConfigurationSection section = quantitySection.getConfigurationSection(buttonKey);
            if (section == null) {
                return false;
            }
            int configSlot = section.getInt("Slot", -1);
            boolean result = configSlot == slot;
            return result;
        }
        return false;
    }

    private boolean isActionButton(FileConfiguration config, int slot, String buttonKey, BuySellSession session) {
        String configSection = config == this.buyGuiConfig ? "Buy-GUI" : "Sell-GUI";
        ConfigurationSection actionSection = config.getConfigurationSection(configSection + ".Action-Buttons");
        if (actionSection != null) {
            ConfigurationSection section = actionSection.getConfigurationSection(buttonKey);
            if (section == null) {
                return false;
            }
            int configSlot = section.getInt("Slot", -1);
            return configSlot == slot;
        }
        return false;
    }

    private boolean isDecorationSlot(FileConfiguration config, int slot, BuySellSession session) {
        List backgroundSlots;
        String configSection = config == this.buyGuiConfig ? "Buy-GUI" : "Sell-GUI";
        ConfigurationSection backgroundSection = config.getConfigurationSection(configSection + ".Background");
        if (backgroundSection != null && (backgroundSlots = backgroundSection.getIntegerList("Slots")).contains(slot)) {
            return true;
        }
        ConfigurationSection decorationsSection = config.getConfigurationSection(configSection + ".Decorations");
        if (decorationsSection != null) {
            for (String decorationKey : decorationsSection.getKeys(false)) {
                ConfigurationSection decorationSection = decorationsSection.getConfigurationSection(decorationKey);
                if (decorationSection == null) continue;
                List<Integer> decorationSlots = new ArrayList();
                if (decorationSection.contains("Slots")) {
                    if (decorationSection.isList("Slots")) {
                        decorationSlots = decorationSection.getIntegerList("Slots");
                    } else {
                        String slotsString = decorationSection.getString("Slots", "");
                        if (!slotsString.isEmpty()) {
                            String[] slotStrings;
                            for (String slotString : slotStrings = slotsString.split(",")) {
                                try {
                                    decorationSlots.add(Integer.parseInt(slotString.trim()));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                if (!decorationSlots.contains(slot)) continue;
                return true;
            }
        }
        return false;
    }

    private void handleQuantityChange(Player player, BuySellSession session, int change) {
        int newQuantity = session.quantity + change;
        newQuantity = Math.max(1, newQuantity);
        if ("Buy".equals(session.action)) {
            Material material;
            String materialString = session.itemSection.getString("Material", "STONE");
            if (materialString.contains(":")) {
                material = Material.STONE;
            } else {
                try {
                    material = Material.valueOf((String)materialString);
                }
                catch (IllegalArgumentException e) {
                    material = Material.STONE;
                }
            }
            int freeSlots = this.getFreeInventorySlots(player);
            int maxStackSize = material.getMaxStackSize();
            int maxBuyable = maxStackSize == 1 ? freeSlots : (maxStackSize == 16 ? freeSlots * maxStackSize : freeSlots * maxStackSize);
            double totalPrice = this.calculateTotalPrice(session, newQuantity);
            boolean hasEnough = this.plugin.getEconomyManager().hasEnough(player, totalPrice);
            if (!hasEnough) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.not-enough-money", "&cYou don't have enough money!"));
                return;
            }
            if ((newQuantity = Math.min(newQuantity, maxBuyable)) <= 0) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.no-inventory-space", "&cYou don't have enough inventory space!"));
                return;
            }
        } else if ("Sell".equals(session.action)) {
            String itemType = session.itemSection.getString("type", "VANILLA").toUpperCase();
            if ("COMMAND".equals(itemType)) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.cannot-sell-command-item", "&cYou cannot sell command items!"));
                return;
            }
            ItemStack shopItem = this.createShopItemForComparison(session.itemSection);
            int availableItems = this.getMatchingItemsInInventory(player, shopItem);
            if ((newQuantity = Math.min(newQuantity, availableItems)) <= 0) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.no-items-to-sell", "&cYou don't have any matching items to sell!"));
                return;
            }
        }
        session.quantity = newQuantity;
        this.createBuySellInventory(player, session);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleConfirm(Player player, BuySellSession session) {
        Material material;
        double totalPrice = this.calculateTotalPrice(session, session.quantity);
        String currencySymbol = this.getCurrencySymbol(session.itemSection);
        String materialString = session.itemSection.getString("Material", "STONE");
        if (materialString.contains(":")) {
            material = Material.STONE;
        } else {
            try {
                material = Material.valueOf((String)materialString);
            }
            catch (IllegalArgumentException e) {
                material = Material.STONE;
            }
        }
        if ("Buy".equals(session.action)) {
            int maxStackSize;
            boolean hasEnough = this.plugin.getEconomyManager().hasEnough(player, totalPrice);
            if (!hasEnough) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.not-enough-money", "&cYou don't have enough money!"));
                return;
            }
            int freeSlots = this.getFreeInventorySlots(player);
            int maxBuyable = freeSlots * (maxStackSize = material.getMaxStackSize());
            if (session.quantity > maxBuyable) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.no-inventory-space", "&cYou don't have enough inventory space!"));
                return;
            }
            boolean withdrawSuccess = this.plugin.getEconomyManager().withdraw((OfflinePlayer)player, totalPrice);
            if (!withdrawSuccess) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.transaction-failed", "&cTransaction failed!"));
                return;
            }
            String itemType = session.itemSection.getString("type", "VANILLA").toUpperCase();
            if ("COMMAND".equals(itemType)) {
                String command = session.itemSection.getString("command", "");
                if (!command.isEmpty()) {
                    command = command.replace("[PlayerName]", player.getName()).replace("[Count]", String.valueOf(session.quantity)).replace("[Price]", String.valueOf(totalPrice));
                    command = this.processMathematicalExpressions(command, session.quantity);
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
                }
            } else {
                HashMap leftover;
                ItemStack itemToGive = this.createItemToGive(session.itemSection, session.quantity);
                if (itemToGive == null) {
                    this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.failed-to-create-item", "{Prefix}&cError: Failed to create item!"));
                    return;
                }
                this.plugin.getStatisticsManager().recordPurchase(player, itemToGive, session.quantity, totalPrice);
                if (this.plugin.getDemandTrackerManager() != null) {
                    String itemIdentifier = session.itemSection.getString("Material", "STONE");
                    this.plugin.getDemandTrackerManager().recordBuyTransaction(itemToGive, totalPrice, session.quantity, itemIdentifier);
                }
                if (!(leftover = player.getInventory().addItem(new ItemStack[]{itemToGive})).isEmpty()) {
                    for (ItemStack item : leftover.values()) {
                        player.getWorld().dropItemNaturally(player.getLocation(), item);
                    }
                }
            }
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("buysell.buy-success", "&aSuccessfully bought [quantity] [item] for [price]!").replace("[quantity]", String.valueOf(session.quantity)).replace("[item]", this.getItemDisplayName(session.itemSection)).replace("[price]", String.format("%.2f", totalPrice) + " " + currencySymbol));
        } else if ("Sell".equals(session.action)) {
            String itemType = session.itemSection.getString("type", "VANILLA").toUpperCase();
            if ("COMMAND".equals(itemType)) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.cannot-sell-command-item", "&cYou cannot sell command items!"));
                return;
            }
            ItemStack shopItem = this.createShopItemForComparison(session.itemSection);
            int availableItems = this.getMatchingItemsInInventory(player, shopItem);
            if (availableItems < session.quantity) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.not-enough-items", "&cYou don't have enough matching items to sell!"));
                return;
            }
            int toRemove = session.quantity;
            for (int i = 0; i < player.getInventory().getSize() && toRemove > 0; ++i) {
                ItemStack item = player.getInventory().getItem(i);
                if (item == null || !this.itemsMatchWithNBT(item, shopItem)) continue;
                int amount = item.getAmount();
                if (amount <= toRemove) {
                    player.getInventory().setItem(i, null);
                    toRemove -= amount;
                    continue;
                }
                item.setAmount(amount - toRemove);
                toRemove = 0;
            }
            boolean depositSuccess = this.plugin.getEconomyManager().deposit((OfflinePlayer)player, totalPrice);
            if (!depositSuccess) {
                this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.transaction-failed", "&cTransaction failed!"));
                return;
            }
            this.plugin.getStatisticsManager().recordSale(player, shopItem, session.quantity, totalPrice);
            if (this.plugin.getDemandTrackerManager() != null) {
                String itemIdentifier = session.itemSection.getString("Material", "STONE");
                this.plugin.getDemandTrackerManager().recordSellTransaction(shopItem, totalPrice, session.quantity, itemIdentifier);
            }
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("buysell.sell-success", "&aSuccessfully sold [quantity] [item] for [price]!").replace("[quantity]", String.valueOf(session.quantity)).replace("[item]", session.itemSection.getString("Name", "Item")).replace("[price]", String.format("%.2f", totalPrice) + " " + currencySymbol));
        }
        this.activeSessions.remove(player);
        player.closeInventory();
    }

    private void handleCancel(Player player, BuySellSession session) {
        this.activeSessions.remove(player);
        if (session.shopName != null && !session.shopName.isEmpty()) {
            this.plugin.getMenuManager().openShop(player, session.shopName);
        } else {
            player.closeInventory();
        }
    }

    public void reloadConfigurations() {
        this.loadConfigurations();
    }

    public void removeSession(Player player) {
        this.activeSessions.remove(player);
    }

    private ItemStack createShopItemForComparison(ConfigurationSection itemSection) {
        try {
            Material material;
            String itemName;
            String pluginName;
            ItemStack customItem;
            String[] parts;
            String materialString = itemSection.getString("Material", "STONE");
            if (materialString.contains(":") && (parts = materialString.split(":", 2)).length == 2 && (customItem = MrUltimateShopAPI.getCustomItem(pluginName = parts[0], itemName = parts[1])) != null) {
                ItemMeta meta;
                ItemStack clonedItem = customItem.clone();
                boolean enableCustomItemLore = itemSection.getBoolean("EnableCustomItemLore", false);
                if ((!enableCustomItemLore || itemSection.contains("Name") || itemSection.contains("Lore")) && (meta = clonedItem.getItemMeta()) != null) {
                    if (itemSection.contains("Name")) {
                        meta.setDisplayName(MrLibColors.colorize((String)itemSection.getString("Name")));
                    }
                    if (itemSection.contains("Lore") || !enableCustomItemLore) {
                        ArrayList<String> lore = new ArrayList<String>();
                        if (itemSection.contains("Lore")) {
                            for (String line : itemSection.getStringList("Lore")) {
                                lore.add(MrLibColors.colorize((String)line));
                            }
                        }
                        meta.setLore(lore);
                    }
                    clonedItem.setItemMeta(meta);
                }
                return clonedItem;
            }
            try {
                material = Material.valueOf((String)materialString);
            }
            catch (IllegalArgumentException e) {
                material = Material.STONE;
            }
            ItemStack item = new ItemStack(material);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                if (itemSection.contains("Name")) {
                    meta.setDisplayName(MrLibColors.colorize((String)itemSection.getString("Name")));
                }
                if (itemSection.contains("Lore")) {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : itemSection.getStringList("Lore")) {
                        lore.add(MrLibColors.colorize((String)line));
                    }
                    meta.setLore(lore);
                }
                if (itemSection.contains("CustomModelData")) {
                    meta.setCustomModelData(Integer.valueOf(itemSection.getInt("CustomModelData")));
                }
                item.setItemMeta(meta);
            }
            return item;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean itemsMatchWithNBT(ItemStack item1, ItemStack item2) {
        ItemMeta meta2;
        if (item1 == null || item2 == null) {
            return false;
        }
        if (item1.getType() != item2.getType()) {
            return false;
        }
        ItemMeta meta1 = item1.getItemMeta();
        if (meta1 == null != ((meta2 = item2.getItemMeta()) == null)) {
            return false;
        }
        if (meta1 != null && meta2 != null) {
            List lore2;
            String name2;
            String name1 = meta1.hasDisplayName() ? meta1.getDisplayName() : null;
            String string = name2 = meta2.hasDisplayName() ? meta2.getDisplayName() : null;
            if (!Objects.equals(name1, name2)) {
                return false;
            }
            List lore1 = meta1.hasLore() ? meta1.getLore() : null;
            List list = lore2 = meta2.hasLore() ? meta2.getLore() : null;
            if (!Objects.equals(lore1, lore2)) {
                return false;
            }
            if (meta1.hasCustomModelData() != meta2.hasCustomModelData()) {
                return false;
            }
            if (meta1.hasCustomModelData() && meta1.getCustomModelData() != meta2.getCustomModelData()) {
                return false;
            }
            if (!meta1.getEnchants().equals(meta2.getEnchants())) {
                return false;
            }
        }
        return true;
    }

    private int getMatchingItemsInInventory(Player player, ItemStack shopItem) {
        int count = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || !this.itemsMatchWithNBT(item, shopItem)) continue;
            count += item.getAmount();
        }
        return count;
    }

    private String processMathematicalExpressions(String command, int playerBuyed) {
        String result = command;
        result = result.replace("[PlayerBuyed]", String.valueOf(playerBuyed));
        Pattern pattern = Pattern.compile("(\\d+)\\s*([+\\-*/])\\s*(\\d+)");
        Matcher matcher = pattern.matcher(result);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int calculatedResult;
            int firstNumber = Integer.parseInt(matcher.group(1));
            String operator = matcher.group(2);
            int secondNumber = Integer.parseInt(matcher.group(3));
            switch (operator) {
                case "+": {
                    calculatedResult = firstNumber + secondNumber;
                    break;
                }
                case "-": {
                    calculatedResult = firstNumber - secondNumber;
                    break;
                }
                case "*": {
                    calculatedResult = firstNumber * secondNumber;
                    break;
                }
                case "/": {
                    calculatedResult = secondNumber != 0 ? firstNumber / secondNumber : firstNumber;
                    break;
                }
                default: {
                    calculatedResult = firstNumber;
                }
            }
            matcher.appendReplacement(sb, String.valueOf(calculatedResult));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public double getBuyPrice(ItemStack item) {
        if (item == null) {
            return 0.0;
        }
        for (String shopName : this.plugin.getMenuManager().getAvailableShops()) {
            ConfigurationSection itemsSection;
            Map<String, FileConfiguration> shopConfigs = this.plugin.getMenuManager().getShopConfigs();
            FileConfiguration shopConfig = shopConfigs.get(shopName);
            if (shopConfig == null || (itemsSection = shopConfig.getConfigurationSection("Shop.Items")) == null) continue;
            for (String key : itemsSection.getKeys(false)) {
                ItemStack shopItem;
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(key);
                if (itemSection == null || !itemSection.contains("Buy.Price") || !itemSection.getBoolean("Buy.Enable", true) || (shopItem = this.createShopItemForComparison(itemSection)) == null || !this.itemsMatchWithNBT(item, shopItem)) continue;
                return itemSection.getDouble("Buy.Price", 0.0);
            }
        }
        return 0.0;
    }

    public boolean canBuyItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        return this.getBuyPrice(item) > 0.0;
    }

    private ItemStack createItemToGive(ConfigurationSection itemSection, int quantity) {
        Material material;
        String itemName;
        String pluginName;
        ItemStack customItem;
        String[] parts;
        String materialString = itemSection.getString("Material", "STONE");
        if (materialString.contains(":") && (parts = materialString.split(":", 2)).length == 2 && (customItem = MrUltimateShopAPI.getCustomItem(pluginName = parts[0], itemName = parts[1])) != null) {
            ItemMeta meta;
            ItemStack clonedItem = customItem.clone();
            clonedItem.setAmount(quantity);
            if ((itemSection.contains("Name") || itemSection.contains("Lore")) && (meta = clonedItem.getItemMeta()) != null) {
                if (itemSection.contains("Name")) {
                    String name = MrLibColors.colorize((String)itemSection.getString("Name"));
                    meta.setDisplayName(name);
                }
                if (itemSection.contains("Lore")) {
                    ArrayList<String> finalLore = new ArrayList<String>();
                    for (String line : itemSection.getStringList("Lore")) {
                        finalLore.add(MrLibColors.colorize((String)line));
                    }
                    meta.setLore(finalLore);
                }
                clonedItem.setItemMeta(meta);
            }
            return clonedItem;
        }
        try {
            material = Material.valueOf((String)materialString);
        }
        catch (IllegalArgumentException e) {
            material = Material.STONE;
        }
        ItemStack item = new ItemStack(material, quantity);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (itemSection.contains("Name")) {
                meta.setDisplayName(MrLibColors.colorize((String)itemSection.getString("Name")));
            }
            ArrayList<String> finalLore = new ArrayList<String>();
            if (itemSection.contains("Lore")) {
                for (String line : itemSection.getStringList("Lore")) {
                    finalLore.add(MrLibColors.colorize((String)line));
                }
            }
            meta.setLore(finalLore);
            if (itemSection.contains("CustomModelData")) {
                meta.setCustomModelData(Integer.valueOf(itemSection.getInt("CustomModelData")));
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private String getItemDisplayName(ConfigurationSection itemSection) {
        String[] parts;
        if (itemSection.contains("Name")) {
            return itemSection.getString("Name");
        }
        String materialString = itemSection.getString("Material", "STONE");
        if (materialString.contains(":") && (parts = materialString.split(":", 2)).length == 2) {
            String pluginName = parts[0];
            String itemName = parts[1];
            ItemStack customItem = MrUltimateShopAPI.getCustomItem(pluginName, itemName);
            if (customItem != null && customItem.hasItemMeta() && customItem.getItemMeta().hasDisplayName()) {
                return customItem.getItemMeta().getDisplayName();
            }
            return itemName.replace("_", " ");
        }
        try {
            Material material = Material.valueOf((String)materialString.toUpperCase());
            return this.formatMaterialName(material.name());
        }
        catch (IllegalArgumentException e) {
            return "Unknown Item";
        }
    }

    private String formatMaterialName(String materialName) {
        String[] words = materialName.toLowerCase().split("_");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (formatted.length() > 0) {
                formatted.append(" ");
            }
            formatted.append(word.substring(0, 1).toUpperCase()).append(word.substring(1));
        }
        return formatted.toString();
    }

    private static class BuySellSession {
        public final ConfigurationSection itemSection;
        public final String shopName;
        public final String action;
        public int quantity;

        public BuySellSession(ConfigurationSection itemSection, String shopName, String action, int quantity) {
            this.itemSection = itemSection;
            this.shopName = shopName;
            this.action = action;
            this.quantity = quantity;
        }
    }
}

