/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.managers;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class LogManager {
    private final MrUltimateShop plugin;
    private final File logFile;
    private final SimpleDateFormat dateFormat;

    public LogManager(MrUltimateShop plugin) {
        this.plugin = plugin;
        this.logFile = new File(plugin.getDataFolder(), "log.log");
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!this.logFile.exists()) {
            try {
                this.logFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void logPlayerBuy(Player player, ItemStack item, int quantity, double price) {
        if (!this.plugin.getConfig().getBoolean("MrUltimateShop.Logging.Player-Buys", true)) {
            return;
        }
        String logEntry = String.format("[%s] BUY: %s bought %dx %s for $%.2f", this.dateFormat.format(new Date()), player.getName(), quantity, item.getType().name(), price);
        this.writeToLog(logEntry);
    }

    public void logPlayerSell(Player player, ItemStack item, int quantity, double price) {
        if (!this.plugin.getConfig().getBoolean("MrUltimateShop.Logging.Player-Sells", true)) {
            return;
        }
        String logEntry = String.format("[%s] SELL: %s sold %dx %s for $%.2f", this.dateFormat.format(new Date()), player.getName(), quantity, item.getType().name(), price);
        this.writeToLog(logEntry);
    }

    private void writeToLog(String entry) {
        try (FileWriter writer = new FileWriter(this.logFile, true);){
            writer.write(entry + "\n");
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

