/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.managers;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private final MrUltimateShop plugin;
    private FileConfiguration messagesConfig;
    private File messagesFile;

    public MessageManager(MrUltimateShop plugin) {
        this.plugin = plugin;
    }

    public void loadMessages() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defConfigStream = this.plugin.getResource("messages.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.messagesConfig.setDefaults((Configuration)defConfig);
        }
        this.checkAndAddMissingChestShopMessages();
        this.checkAndAddMissingErrorMessages();
        this.checkAndAddMissingCommandMessages();
    }

    public void reloadMessages() {
        if (this.messagesFile == null) {
            this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defConfigStream = this.plugin.getResource("messages.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.messagesConfig.setDefaults((Configuration)defConfig);
        }
        this.checkAndAddMissingChestShopMessages();
        this.checkAndAddMissingErrorMessages();
        this.checkAndAddMissingCommandMessages();
    }

    private void checkAndAddMissingChestShopMessages() {
        boolean messagesChanged = false;
        ConfigurationSection chestShopSection = this.messagesConfig.getConfigurationSection("MrUltimateShop");
        if (chestShopSection == null) {
            chestShopSection = this.messagesConfig.getConfigurationSection("Chest-Shop");
        }
        if (chestShopSection == null) {
            this.addDefaultChestShopMessages();
            messagesChanged = true;
        } else {
            String[] requiredMessages;
            for (String messagePath : requiredMessages = new String[]{"disabled", "create-start", "create-item-required", "create-look-at-allowed", "create-no-economy", "create-not-enough-money", "create-transaction-failed", "create-success", "create-already-exists", "buy-price-disabled", "sell-price-disabled", "buy-price-enabled", "sell-price-enabled", "enter-buy-price", "enter-sell-price", "invalid-price", "price-updated", "limit-reached", "break-not-owner", "help-header", "help-create", "help-give", "help-team", "give-usage", "give-success-self", "give-success-other", "give-received", "team-help-header", "team-help-invite", "team-help-remove", "team-help-list", "team-invite-usage", "team-remove-usage", "team-look-at-shop", "team-not-owner", "team-cannot-invite-self", "team-invalid-role", "team-invite-success", "team-invited", "team-remove-success", "team-removed", "team-not-member", "team-no-access", "team-list-header", "team-list-owner", "team-list-member", "team-enter-add-shop", "team-enter-add-global", "team-enter-remove-shop", "team-enter-remove-global", "team-enter-role", "team-shop-invite-success", "team-shop-invited", "team-shop-remove-success", "team-shop-removed", "team-global-invite-success", "team-global-invited", "team-global-remove-success", "team-global-removed", "team-global-remove-usage", "team-nobody", "team-limit-reached", "mode-buy", "mode-sell", "unknown-player", "no-item", "team-type-global", "team-type-shop", "team-more-members", "no-item-set", "no-buy-price", "not-enough-money", "not-enough-items", "buy-success", "no-sell-price", "not-enough-items-player", "shop-full", "owner-not-enough-money", "sell-success", "create-too-close", "break-shop-item-returned", "break-trade-item-dropped"}) {
                boolean exists;
                boolean bl = exists = chestShopSection.contains(messagePath) && !chestShopSection.isSet(messagePath);
                if (chestShopSection.isSet(messagePath)) continue;
                this.addMissingChestShopMessage(chestShopSection, messagePath);
                messagesChanged = true;
            }
        }
        if (messagesChanged) {
            this.saveMessages();
        }
    }

    private void addDefaultChestShopMessages() {
        ConfigurationSection chestShop = this.messagesConfig.createSection("MrUltimateShop");
        chestShop.set("Prefix", (Object)"{#FF58DF>}&lMrUltimateShop{#FF58C4<} &8| ");
        chestShop.set("disabled", (Object)"{Prefix}&cChest-Shops are disabled.");
        chestShop.set("create-start", (Object)"{Prefix}&fLook at allowed block and hold item to create.");
        chestShop.set("create-item-required", (Object)"{Prefix}&cHold an item in your main hand!");
        chestShop.set("create-look-at-allowed", (Object)"{Prefix}&cLook at an allowed block and try again!");
        chestShop.set("create-no-economy", (Object)"{Prefix}&cEconomy is not enabled!");
        chestShop.set("create-not-enough-money", (Object)"{Prefix}&cYou don't have enough money!");
        chestShop.set("create-transaction-failed", (Object)"{Prefix}&cPayment failed!");
        chestShop.set("create-success", (Object)"{Prefix}&aShop created!");
        chestShop.set("create-already-exists", (Object)"{Prefix}&cA shop already exists at this block!");
        chestShop.set("buy-price-disabled", (Object)"{Prefix}&eBuy price disabled.");
        chestShop.set("sell-price-disabled", (Object)"{Prefix}&eSell price disabled.");
        chestShop.set("buy-price-enabled", (Object)"{Prefix}&aBuy price enabled (set a value).");
        chestShop.set("sell-price-enabled", (Object)"{Prefix}&aSell price enabled (set a value).");
        chestShop.set("enter-buy-price", (Object)"{Prefix}&fEnter new buy price in chat:");
        chestShop.set("enter-sell-price", (Object)"{Prefix}&fEnter new sell price in chat:");
        chestShop.set("invalid-price", (Object)"{Prefix}&cInvalid price!");
        chestShop.set("price-updated", (Object)"{Prefix}&aPrice updated.");
        chestShop.set("limit-reached", (Object)"{Prefix}&cYou have reached your shop limit!");
        chestShop.set("break-not-owner", (Object)"{Prefix}&cOnly the owner can break this shop!");
        chestShop.set("help-header", (Object)"{Prefix}&aChest Shop Commands:");
        chestShop.set("help-create", (Object)"&e/cshop create &f- Create a new chest shop");
        chestShop.set("help-give", (Object)"&e/cshop give shop [player] &f- Give shop item");
        chestShop.set("help-team", (Object)"&e/cshop team &f- Manage shop team members");
        chestShop.set("give-usage", (Object)"{Prefix}&cUsage: /cshop give shop [player]");
        chestShop.set("give-success-self", (Object)"{Prefix}&aYou received a shop item!");
        chestShop.set("give-success-other", (Object)"{Prefix}&aGave shop item to [player]!");
        chestShop.set("give-received", (Object)"{Prefix}&aYou received a shop item from [player]!");
        chestShop.set("team-help-header", (Object)"{Prefix}&aTeam Commands:");
        chestShop.set("team-help-invite", (Object)"&e/cshop team invite <player> <Editor|Supplementer> &f- Invite team member");
        chestShop.set("team-help-remove", (Object)"&e/cshop team remove <player> &f- Remove team member");
        chestShop.set("team-help-list", (Object)"&e/cshop team list &f- List team members");
        chestShop.set("team-invite-usage", (Object)"{Prefix}&cUsage: /cshop team invite <player> <Editor|Supplementer>");
        chestShop.set("team-remove-usage", (Object)"{Prefix}&cUsage: /cshop team remove <player>");
        chestShop.set("team-look-at-shop", (Object)"{Prefix}&cLook at your chest shop!");
        chestShop.set("team-not-owner", (Object)"{Prefix}&cYou must be the owner to manage team members!");
        chestShop.set("team-cannot-invite-self", (Object)"{Prefix}&cYou cannot invite yourself!");
        chestShop.set("team-invalid-role", (Object)"{Prefix}&cInvalid role! Use 'Editor' or 'Supplementer'");
        chestShop.set("team-invite-success", (Object)"{Prefix}&aAdded [player] as [role] to your shop!");
        chestShop.set("team-invited", (Object)"{Prefix}&aYou have been added to [owner]'s shop as [role]!");
        chestShop.set("team-remove-success", (Object)"{Prefix}&aRemoved [player] from your shop!");
        chestShop.set("team-removed", (Object)"{Prefix}&cYou have been removed from [owner]'s shop!");
        chestShop.set("team-not-member", (Object)"{Prefix}&c[player] is not a team member!");
        chestShop.set("team-no-access", (Object)"{Prefix}&cYou don't have access to this shop!");
        chestShop.set("team-list-header", (Object)"{Prefix}&aShop Team Members:");
        chestShop.set("team-list-owner", (Object)"&e[player] &7(Owner)");
        chestShop.set("team-list-member", (Object)"&a[player] &7([role])");
        chestShop.set("team-enter-add-shop", (Object)"{Prefix}&fEnter player name to add to THIS shop:");
        chestShop.set("team-enter-add-global", (Object)"{Prefix}&fEnter player name to add to ALL shops:");
        chestShop.set("team-enter-remove-shop", (Object)"{Prefix}&fEnter player name to remove from THIS shop:");
        chestShop.set("team-enter-remove-global", (Object)"{Prefix}&fEnter player name to remove from ALL shops:");
        chestShop.set("team-enter-role", (Object)"{Prefix}&fEnter role (Editor/Supplementer):");
        chestShop.set("team-shop-invite-success", (Object)"{Prefix}&aAdded [player] as [role] to THIS shop!");
        chestShop.set("team-shop-invited", (Object)"{Prefix}&aYou have been added to [owner]'s shop as [role]!");
        chestShop.set("team-shop-remove-success", (Object)"{Prefix}&aRemoved [player] from THIS shop!");
        chestShop.set("team-shop-removed", (Object)"{Prefix}&cYou have been removed from [owner]'s shop!");
        chestShop.set("team-global-invite-success", (Object)"{Prefix}&aAdded [player] as [role] to ALL your shops!");
        chestShop.set("team-global-invited", (Object)"{Prefix}&aYou have been added to [owner]'s ALL shops as [role]!");
        chestShop.set("team-global-remove-success", (Object)"{Prefix}&aRemoved [player] from ALL your shops!");
        chestShop.set("team-global-removed", (Object)"{Prefix}&cYou have been removed from [owner]'s ALL shops!");
        chestShop.set("team-global-remove-usage", (Object)"{Prefix}&cUsage: /cshop team remove <player>");
        chestShop.set("team-nobody", (Object)"Nobody");
        chestShop.set("team-limit-reached", (Object)"{Prefix}&cThis shop already has the maximum number of team members (4)!");
        chestShop.set("mode-buy", (Object)"&aN\u00e1kup");
        chestShop.set("mode-sell", (Object)"&cProdej");
        chestShop.set("unknown-player", (Object)"Unknown");
        chestShop.set("no-item", (Object)"None");
        chestShop.set("team-type-global", (Object)"&7(Global)");
        chestShop.set("team-type-shop", (Object)"&7(Shop)");
        chestShop.set("team-more-members", (Object)"&7... and {count} more");
        chestShop.set("no-item-set", (Object)"{Prefix}&cNo item set for trade!");
        chestShop.set("no-buy-price", (Object)"{Prefix}&cBuy price not set!");
        chestShop.set("not-enough-money", (Object)"{Prefix}&cYou don't have enough money!");
        chestShop.set("not-enough-items", (Object)"{Prefix}&cShop doesn't have enough items!");
        chestShop.set("buy-success", (Object)"{Prefix}&aSuccessfully bought {quantity}x {item} for {price}!");
        chestShop.set("no-sell-price", (Object)"{Prefix}&cSell price not set!");
        chestShop.set("not-enough-items-player", (Object)"{Prefix}&cYou don't have enough items!");
        chestShop.set("shop-full", (Object)"{Prefix}&cShop storage is full!");
        chestShop.set("owner-not-enough-money", (Object)"{Prefix}&cShop owner doesn't have enough money!");
        chestShop.set("sell-success", (Object)"{Prefix}&aSuccessfully sold {quantity}x {item} for {price}!");
        chestShop.set("create-too-close", (Object)"{Prefix}&cShops must be at least {distance} blocks apart from each other!");
        chestShop.set("break-shop-item-returned", (Object)"{Prefix}&aShop destroyed! Shop item returned to your inventory.");
        chestShop.set("break-trade-item-dropped", (Object)"{Prefix}&aShop destroyed! Trade item dropped.");
    }

    private void addMissingChestShopMessage(ConfigurationSection chestShopSection, String messagePath) {
        switch (messagePath) {
            case "disabled": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cChest-Shops are disabled.");
                break;
            }
            case "create-start": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&fLook at allowed block and hold item to create.");
                break;
            }
            case "create-item-required": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cHold an item in your main hand!");
                break;
            }
            case "create-look-at-allowed": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cLook at an allowed block and try again!");
                break;
            }
            case "create-no-economy": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cEconomy is not enabled!");
                break;
            }
            case "create-not-enough-money": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cYou don't have enough money!");
                break;
            }
            case "create-transaction-failed": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cPayment failed!");
                break;
            }
            case "create-success": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&aShop created!");
                break;
            }
            case "create-already-exists": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cA shop already exists at this block!");
                break;
            }
            case "team-limit-reached": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cThis shop already has the maximum number of team members (4)!");
                break;
            }
            case "mode-buy": {
                chestShopSection.set(messagePath, (Object)"&aN\u00e1kup");
                break;
            }
            case "mode-sell": {
                chestShopSection.set(messagePath, (Object)"&cProdej");
                break;
            }
            case "unknown-player": {
                chestShopSection.set(messagePath, (Object)"Unknown");
                break;
            }
            case "no-item": {
                chestShopSection.set(messagePath, (Object)"None");
                break;
            }
            case "team-type-global": {
                chestShopSection.set(messagePath, (Object)"&7(Global)");
                break;
            }
            case "team-type-shop": {
                chestShopSection.set(messagePath, (Object)"&7(Shop)");
                break;
            }
            case "team-more-members": {
                chestShopSection.set(messagePath, (Object)"&7... and {count} more");
                break;
            }
            case "no-item-set": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cNo item set for trade!");
                break;
            }
            case "no-buy-price": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cBuy price not set!");
                break;
            }
            case "not-enough-money": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cYou don't have enough money!");
                break;
            }
            case "not-enough-items": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cShop doesn't have enough items!");
                break;
            }
            case "buy-success": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&aSuccessfully bought {quantity}x {item} for {price}!");
                break;
            }
            case "no-sell-price": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cSell price not set!");
                break;
            }
            case "not-enough-items-player": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cYou don't have enough items!");
                break;
            }
            case "shop-full": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cShop storage is full!");
                break;
            }
            case "owner-not-enough-money": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cShop owner doesn't have enough money!");
                break;
            }
            case "sell-success": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&aSuccessfully sold {quantity}x {item} for {price}!");
                break;
            }
            case "create-too-close": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&cShops must be at least {distance} blocks apart from each other!");
                break;
            }
            case "break-shop-item-returned": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&aShop destroyed! Shop item returned to your inventory.");
                break;
            }
            case "break-trade-item-dropped": {
                chestShopSection.set(messagePath, (Object)"{Prefix}&aShop destroyed! Trade item dropped.");
                break;
            }
            default: {
                chestShopSection.set(messagePath, (Object)("{Prefix}&eMissing message: " + messagePath));
            }
        }
    }

    public void saveMessages() {
        if (this.messagesConfig == null || this.messagesFile == null) {
            return;
        }
        try {
            this.messagesConfig.save(this.messagesFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getMessage(String path) {
        String message = this.messagesConfig.getString("MrUltimateShop." + path);
        if (message == null) {
            message = this.messagesConfig.getString(path);
        }
        if (message == null) {
            return "&cZpr\u00e1va nenalezena: " + path;
        }
        String prefix = this.messagesConfig.getString("MrUltimateShop.Prefix");
        if (prefix == null) {
            prefix = this.messagesConfig.getString("Prefix", "{#FF58DF>}&lMrUltimateShop{#FF58C4<} &8| ");
        }
        if ((message = message.replace("{Prefix}", prefix)).contains("[CURRENCY_SYMBOL]")) {
            String currencySymbol = this.plugin.getEconomyManager().getCurrencySymbol();
            message = message.replace("[CURRENCY_SYMBOL]", currencySymbol);
        }
        return MrLibColors.colorize((String)message);
    }

    public String getMessage(String path, String defaultMessage) {
        String prefix;
        String message = this.messagesConfig.getString("MrUltimateShop." + path);
        if (message == null) {
            message = this.messagesConfig.getString(path, defaultMessage);
        }
        if ((prefix = this.messagesConfig.getString("MrUltimateShop.Prefix")) == null) {
            prefix = this.messagesConfig.getString("Prefix", "{#FF58DF>}&lMrUltimateShop{#FF58C4<} &8| ");
        }
        if ((message = message.replace("{Prefix}", prefix)).contains("[CURRENCY_SYMBOL]")) {
            String currencySymbol = this.plugin.getEconomyManager().getCurrencySymbol();
            message = message.replace("[CURRENCY_SYMBOL]", currencySymbol);
        }
        return MrLibColors.colorize((String)message);
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }

    private void checkAndAddMissingErrorMessages() {
        boolean messagesChanged = false;
        ConfigurationSection errorsSection = this.messagesConfig.getConfigurationSection("MrUltimateShop");
        if (errorsSection == null) {
            errorsSection = this.messagesConfig.getConfigurationSection("errors");
        }
        if (errorsSection == null) {
            this.addDefaultErrorMessages();
            messagesChanged = true;
        } else {
            String[] requiredErrorMessages;
            for (String messagePath : requiredErrorMessages = new String[]{"not-enough-money", "no-inventory-space", "no-items-to-sell", "not-enough-items", "transaction-failed", "cannot-sell-command-item", "player-only", "no-permission", "shop-or-player-not-found", "player-not-found", "shop-not-found", "main-menu-error", "shop-not-loaded", "item-cannot-buy", "item-cannot-sell", "failed-to-create-item"}) {
                if (errorsSection.isSet(messagePath)) continue;
                this.addMissingErrorMessage(errorsSection, messagePath);
                messagesChanged = true;
            }
        }
        if (messagesChanged) {
            this.saveMessages();
        }
    }

    private void addDefaultErrorMessages() {
        ConfigurationSection mrUltimateShop = this.messagesConfig.getConfigurationSection("MrUltimateShop");
        if (mrUltimateShop == null) {
            mrUltimateShop = this.messagesConfig.createSection("MrUltimateShop");
            mrUltimateShop.set("Prefix", (Object)"{#FF58DF>}&lMrUltimateShop{#FF58C4<} &8| ");
        }
        ConfigurationSection errors = mrUltimateShop;
        errors.set("not-enough-money", (Object)"{Prefix}&cYou don't have enough money!");
        errors.set("no-inventory-space", (Object)"{Prefix}&cYou don't have enough inventory space!");
        errors.set("no-items-to-sell", (Object)"{Prefix}&cYou don't have any items to sell!");
        errors.set("not-enough-items", (Object)"{Prefix}&cYou don't have enough items to sell!");
        errors.set("transaction-failed", (Object)"{Prefix}&cTransaction failed!");
        errors.set("cannot-sell-command-item", (Object)"{Prefix}&cYou cannot sell command items!");
        errors.set("player-only", (Object)"{Prefix}&cThis command can only be used by a player!");
        errors.set("no-permission", (Object)"{Prefix}&cYou don't have permission to use this command!");
        errors.set("shop-or-player-not-found", (Object)"{Prefix}&cShop or player '[name]' not found!");
        errors.set("player-not-found", (Object)"{Prefix}&cPlayer not found!");
        errors.set("shop-not-found", (Object)"{Prefix}&cShop not found!");
        errors.set("main-menu-error", (Object)"{Prefix}&cError opening main menu!");
        errors.set("shop-not-loaded", (Object)"{Prefix}&cShop is not properly loaded!");
        errors.set("item-cannot-buy", (Object)"{Prefix}&cThis item cannot be purchased!");
        errors.set("item-cannot-sell", (Object)"{Prefix}&cThis item cannot be sold!");
        errors.set("failed-to-create-item", (Object)"{Prefix}&cError: Failed to create item!");
    }

    private void addMissingErrorMessage(ConfigurationSection errorsSection, String messagePath) {
        switch (messagePath) {
            case "not-enough-money": {
                errorsSection.set(messagePath, (Object)"{Prefix}&cYou don't have enough money!");
                break;
            }
            case "no-inventory-space": {
                errorsSection.set(messagePath, (Object)"{Prefix}&cYou don't have enough inventory space!");
                break;
            }
            case "no-items-to-sell": {
                errorsSection.set(messagePath, (Object)"{Prefix}&cYou don't have any items to sell!");
                break;
            }
            case "not-enough-items": {
                errorsSection.set(messagePath, (Object)"{Prefix}&cYou don't have enough items to sell!");
                break;
            }
            case "transaction-failed": {
                errorsSection.set(messagePath, (Object)"{Prefix}&cTransaction failed!");
                break;
            }
            case "cannot-sell-command-item": {
                errorsSection.set(messagePath, (Object)"{Prefix}&cYou cannot sell command items!");
                break;
            }
            case "player-only": {
                errorsSection.set(messagePath, (Object)"{Prefix}&cThis command can only be used by a player!");
                break;
            }
            case "no-permission": {
                errorsSection.set(messagePath, (Object)"{Prefix}&cYou don't have permission to use this command!");
                break;
            }
            case "shop-or-player-not-found": {
                errorsSection.set(messagePath, (Object)"{Prefix}&cShop or player '[name]' not found!");
                break;
            }
            case "player-not-found": {
                errorsSection.set(messagePath, (Object)"{Prefix}&cPlayer not found!");
                break;
            }
            case "shop-not-found": {
                errorsSection.set(messagePath, (Object)"{Prefix}&cShop not found!");
                break;
            }
            case "main-menu-error": {
                errorsSection.set(messagePath, (Object)"{Prefix}&cError opening main menu!");
                break;
            }
            case "shop-not-loaded": {
                errorsSection.set(messagePath, (Object)"{Prefix}&cShop is not properly loaded!");
                break;
            }
            case "item-cannot-buy": {
                errorsSection.set(messagePath, (Object)"{Prefix}&cThis item cannot be purchased!");
                break;
            }
            case "item-cannot-sell": {
                errorsSection.set(messagePath, (Object)"{Prefix}&cThis item cannot be sold!");
                break;
            }
            case "failed-to-create-item": {
                errorsSection.set(messagePath, (Object)"{Prefix}&cError: Failed to create item!");
                break;
            }
            default: {
                errorsSection.set(messagePath, (Object)("{Prefix}&eMissing error message: " + messagePath));
            }
        }
    }

    private void checkAndAddMissingCommandMessages() {
        boolean messagesChanged = false;
        ConfigurationSection commandsSection = this.messagesConfig.getConfigurationSection("MrUltimateShop");
        if (commandsSection == null) {
            commandsSection = this.messagesConfig.getConfigurationSection("commands");
        }
        if (commandsSection == null) {
            this.addDefaultCommandMessages();
            messagesChanged = true;
        } else {
            String[] requiredCommandMessages;
            for (String messagePath : requiredCommandMessages = new String[]{"config-reloaded", "help-header", "help-reload", "help-shop", "help-list", "help-help", "help-author", "help-version", "shop-help-header", "shop-help-main", "shop-help-specific", "shop-help-player", "shop-help-player-shop", "shop-help-sell-gui", "shop-help-sell-hand", "shop-help-sell-all", "sell-help-header", "available-shops", "no-shops-found", "shop-list-item"}) {
                if (commandsSection.isSet(messagePath)) continue;
                this.addMissingCommandMessage(commandsSection, messagePath);
                messagesChanged = true;
            }
        }
        if (messagesChanged) {
            this.saveMessages();
        }
    }

    private void addDefaultCommandMessages() {
        ConfigurationSection mrUltimateShop = this.messagesConfig.getConfigurationSection("MrUltimateShop");
        if (mrUltimateShop == null) {
            mrUltimateShop = this.messagesConfig.createSection("MrUltimateShop");
            mrUltimateShop.set("Prefix", (Object)"{#FF58DF>}&lMrUltimateShop{#FF58C4<} &8| ");
        }
        ConfigurationSection commands = mrUltimateShop;
        commands.set("config-reloaded", (Object)"{Prefix}&aConfiguration has been successfully loaded!");
        commands.set("help-header", (Object)"{Prefix}&a&l[MrUltimateShop] &fHelp:");
        commands.set("help-reload", (Object)"{Prefix}&e/mus reload &f- Loads configuration");
        commands.set("help-shop", (Object)"{Prefix}&e/mus shop &f- Opens shop menu");
        commands.set("help-list", (Object)"{Prefix}&e/mus list &f- Lists available shops");
        commands.set("help-help", (Object)"{Prefix}&e/mus help &f- Shows this help");
        commands.set("help-author", (Object)"{Prefix}&fAuthor: &e_MrNeznamy_");
        commands.set("help-version", (Object)"{Prefix}&fVersion: &e1.0.0");
        commands.set("shop-help-header", (Object)"&a&l[MrUltimateShop] &fShop Commands:");
        commands.set("shop-help-main", (Object)"&e/shop &f- Opens main shop menu");
        commands.set("shop-help-specific", (Object)"&e/shop <shop_name> &f- Opens specific shop");
        commands.set("shop-help-player", (Object)"&e/shop <player> &f- Opens main menu for player");
        commands.set("shop-help-player-shop", (Object)"&e/shop <player> <shop_name> &f- Opens shop for player");
        commands.set("shop-help-sell-gui", (Object)"&e/shop sell gui &f- Opens sell GUI");
        commands.set("shop-help-sell-hand", (Object)"&e/shop sell hand &f- Sells item in hand");
        commands.set("shop-help-sell-all", (Object)"&e/shop sell all &f- Sells all items in inventory");
        commands.set("sell-help-header", (Object)"&a&l[MrUltimateShop] &fSell Commands:");
        commands.set("available-shops", (Object)"&a&l[MrUltimateShop] &fAvailable shops:");
        commands.set("no-shops-found", (Object)"&cNo shops found!");
        commands.set("shop-list-item", (Object)"&e- {shop}");
    }

    private void addMissingCommandMessage(ConfigurationSection commandsSection, String messagePath) {
        switch (messagePath) {
            case "config-reloaded": {
                commandsSection.set(messagePath, (Object)"{Prefix}&aConfiguration has been successfully loaded!");
                break;
            }
            case "help-header": {
                commandsSection.set(messagePath, (Object)"{Prefix}&a&l[MrUltimateShop] &fHelp:");
                break;
            }
            case "help-reload": {
                commandsSection.set(messagePath, (Object)"{Prefix}&e/mus reload &f- Loads configuration");
                break;
            }
            case "help-shop": {
                commandsSection.set(messagePath, (Object)"{Prefix}&e/mus shop &f- Opens shop menu");
                break;
            }
            case "help-list": {
                commandsSection.set(messagePath, (Object)"{Prefix}&e/mus list &f- Lists available shops");
                break;
            }
            case "help-help": {
                commandsSection.set(messagePath, (Object)"{Prefix}&e/mus help &f- Shows this help");
                break;
            }
            case "help-author": {
                commandsSection.set(messagePath, (Object)"{Prefix}&fAuthor: &e_MrNeznamy_");
                break;
            }
            case "help-version": {
                commandsSection.set(messagePath, (Object)"{Prefix}&fVersion: &e1.0.0");
                break;
            }
            case "shop-help-header": {
                commandsSection.set(messagePath, (Object)"&a&l[MrUltimateShop] &fShop Commands:");
                break;
            }
            case "shop-help-main": {
                commandsSection.set(messagePath, (Object)"&e/shop &f- Opens main shop menu");
                break;
            }
            case "shop-help-specific": {
                commandsSection.set(messagePath, (Object)"&e/shop <shop_name> &f- Opens specific shop");
                break;
            }
            case "shop-help-player": {
                commandsSection.set(messagePath, (Object)"&e/shop <player> &f- Opens main menu for player");
                break;
            }
            case "shop-help-player-shop": {
                commandsSection.set(messagePath, (Object)"&e/shop <player> <shop_name> &f- Opens shop for player");
                break;
            }
            case "shop-help-sell-gui": {
                commandsSection.set(messagePath, (Object)"&e/shop sell gui &f- Opens sell GUI");
                break;
            }
            case "shop-help-sell-hand": {
                commandsSection.set(messagePath, (Object)"&e/shop sell hand &f- Sells item in hand");
                break;
            }
            case "shop-help-sell-all": {
                commandsSection.set(messagePath, (Object)"&e/shop sell all &f- Sells all items in inventory");
                break;
            }
            case "sell-help-header": {
                commandsSection.set(messagePath, (Object)"&a&l[MrUltimateShop] &fSell Commands:");
                break;
            }
            case "available-shops": {
                commandsSection.set(messagePath, (Object)"&a&l[MrUltimateShop] &fAvailable shops:");
                break;
            }
            case "no-shops-found": {
                commandsSection.set(messagePath, (Object)"&cNo shops found!");
                break;
            }
            case "shop-list-item": {
                commandsSection.set(messagePath, (Object)"&e- {shop}");
                break;
            }
            default: {
                commandsSection.set(messagePath, (Object)("{Prefix}&eMissing command message: " + messagePath));
            }
        }
    }
}

