/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.managers;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.api.MrUltimateShopAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class SellGuiManager
implements Listener {
    private final MrUltimateShop plugin;
    private final Map<Player, Inventory> activeSellGuis;
    private FileConfiguration sellGuiConfig;

    public SellGuiManager(MrUltimateShop plugin) {
        this.plugin = plugin;
        this.activeSellGuis = new HashMap<Player, Inventory>();
        this.loadConfiguration();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void loadConfiguration() {
        File sellGuiFile = new File(this.plugin.getDataFolder(), "sell-all-gui.yml");
        this.sellGuiConfig = YamlConfiguration.loadConfiguration((File)sellGuiFile);
    }

    public void openSellGui(Player player) {
        ConfigurationSection infoSection;
        if (!player.hasPermission("mrultimateshop.command.shop.sell.gui")) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.no-permission", "&cYou don't have permission to use this command!"));
            return;
        }
        String title = MrLibColors.colorize((String)this.sellGuiConfig.getString("MrUltimateShop.Sell-All-GUI.Title", this.sellGuiConfig.getString("Sell-All-GUI.Title", "&cSell Items")));
        int size = this.sellGuiConfig.getInt("MrUltimateShop.Sell-All-GUI.Size", this.sellGuiConfig.getInt("Sell-All-GUI.Size", 54));
        Inventory sellGui = Bukkit.createInventory(null, (int)size, (String)title);
        ConfigurationSection backgroundSection = this.sellGuiConfig.getConfigurationSection("MrUltimateShop.Sell-All-GUI.Background");
        if (backgroundSection == null) {
            backgroundSection = this.sellGuiConfig.getConfigurationSection("Sell-All-GUI.Background");
        }
        if (backgroundSection != null) {
            Material backgroundMaterial = Material.valueOf((String)backgroundSection.getString("Material", "GRAY_STAINED_GLASS_PANE"));
            ItemStack background = new ItemStack(backgroundMaterial);
            ItemMeta backgroundMeta = background.getItemMeta();
            backgroundMeta.setDisplayName(MrLibColors.colorize((String)backgroundSection.getString("Name", " ")));
            background.setItemMeta(backgroundMeta);
            List slots = backgroundSection.getIntegerList("Slots");
            Iterator iterator = slots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot < 0 || slot >= size) continue;
                sellGui.setItem(slot, background);
            }
        }
        if ((infoSection = this.sellGuiConfig.getConfigurationSection("MrUltimateShop.Sell-All-GUI.Info-Item")) == null) {
            infoSection = this.sellGuiConfig.getConfigurationSection("Sell-All-GUI.Info-Item");
        }
        if (infoSection != null) {
            Material material;
            int slot = infoSection.getInt("Slot", 4);
            String materialString = infoSection.getString("Material", "EMERALD");
            try {
                material = Material.valueOf((String)materialString);
            }
            catch (IllegalArgumentException e) {
                material = Material.EMERALD;
            }
            ItemStack infoItem = new ItemStack(material);
            ItemMeta infoMeta = infoItem.getItemMeta();
            infoMeta.setDisplayName(MrLibColors.colorize((String)infoSection.getString("Name", "&aInfo")));
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : infoSection.getStringList("Lore")) {
                lore.add(MrLibColors.colorize((String)line));
            }
            infoMeta.setLore(lore);
            infoItem.setItemMeta(infoMeta);
            sellGui.setItem(slot, infoItem);
        }
        this.activeSellGuis.put(player, sellGui);
        player.openInventory(sellGui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory sellGui = this.activeSellGuis.get(player);
        if (sellGui == null) {
            return;
        }
        boolean isTopInventory = sellGui.equals((Object)event.getView().getTopInventory());
        if (!isTopInventory) {
            return;
        }
        if (sellGui.equals((Object)event.getClickedInventory())) {
            ConfigurationSection infoSection;
            ConfigurationSection backgroundSection = this.sellGuiConfig.getConfigurationSection("MrUltimateShop.Sell-All-GUI.Background");
            if (backgroundSection == null) {
                backgroundSection = this.sellGuiConfig.getConfigurationSection("Sell-All-GUI.Background");
            }
            if ((infoSection = this.sellGuiConfig.getConfigurationSection("MrUltimateShop.Sell-All-GUI.Info-Item")) == null) {
                infoSection = this.sellGuiConfig.getConfigurationSection("Sell-All-GUI.Info-Item");
            }
            int slot = event.getSlot();
            boolean isBackground = false;
            boolean isInfo = false;
            if (backgroundSection != null) {
                List backgroundSlots = backgroundSection.getIntegerList("Slots");
                isBackground = backgroundSlots.contains(slot);
            }
            if (infoSection != null) {
                boolean bl = isInfo = slot == infoSection.getInt("Slot", 4);
            }
            if (isBackground || isInfo) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Inventory sellGui = this.activeSellGuis.get(player);
        if (sellGui == null || !sellGui.equals((Object)event.getInventory())) {
            return;
        }
        this.processSellItems(player, sellGui);
        this.activeSellGuis.remove(player);
    }

    private void processSellItems(Player player, Inventory sellGui) {
        HashMap leftover;
        ConfigurationSection infoSection;
        HashMap<String, Double> economyTotals = new HashMap<String, Double>();
        ArrayList<ItemStack> soldItems = new ArrayList<ItemStack>();
        ArrayList<ItemStack> returnItems = new ArrayList<ItemStack>();
        ConfigurationSection backgroundSection = this.sellGuiConfig.getConfigurationSection("MrUltimateShop.Sell-All-GUI.Background");
        if (backgroundSection == null) {
            backgroundSection = this.sellGuiConfig.getConfigurationSection("Sell-All-GUI.Background");
        }
        if ((infoSection = this.sellGuiConfig.getConfigurationSection("MrUltimateShop.Sell-All-GUI.Info-Item")) == null) {
            infoSection = this.sellGuiConfig.getConfigurationSection("Sell-All-GUI.Info-Item");
        }
        for (int i = 0; i < sellGui.getSize(); ++i) {
            ItemStack item = sellGui.getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            boolean isBackground = false;
            boolean isInfo = false;
            if (backgroundSection != null) {
                List backgroundSlots = backgroundSection.getIntegerList("Slots");
                isBackground = backgroundSlots.contains(i);
            }
            if (infoSection != null) {
                boolean bl = isInfo = i == infoSection.getInt("Slot", 4);
            }
            if (isBackground || isInfo) continue;
            SellResult result = this.sellItem(item);
            if (result.success) {
                double itemValue = result.price * (double)item.getAmount();
                economyTotals.put(result.economyType, economyTotals.getOrDefault(result.economyType, 0.0) + itemValue);
                soldItems.add(item.clone());
                this.plugin.getStatisticsManager().recordSale(player, item, item.getAmount(), itemValue);
                continue;
            }
            returnItems.add(item);
        }
        if (!economyTotals.isEmpty()) {
            for (Map.Entry entry : economyTotals.entrySet()) {
                String economyType = (String)entry.getKey();
                double amount = (Double)entry.getValue();
                this.plugin.getEconomyManager().deposit((OfflinePlayer)player, amount);
            }
            double totalValue = economyTotals.values().stream().mapToDouble(Double::doubleValue).sum();
            String currencySymbol = this.plugin.getEconomyManager().getCurrencySymbol();
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("sell-gui.success", "{Prefix}&aSuccessfully sold items for [price]!").replace("[price]", String.format("%.2f", totalValue) + " " + currencySymbol));
        }
        if (!returnItems.isEmpty() && !(leftover = player.getInventory().addItem(returnItems.toArray(new ItemStack[0]))).isEmpty()) {
            for (ItemStack item : leftover.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), item);
            }
        }
        if (soldItems.isEmpty() && returnItems.isEmpty()) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("sell-gui.no-items", "{Prefix}&cNo items to sell!"));
        }
    }

    public SellResult sellItem(ItemStack itemToSell) {
        for (String shopName : this.plugin.getMenuManager().getAvailableShops()) {
            ConfigurationSection itemsSection;
            Map<String, FileConfiguration> shopConfigs = this.getShopConfigs();
            FileConfiguration shopConfig = shopConfigs.get(shopName);
            if (shopConfig == null || (itemsSection = shopConfig.getConfigurationSection("Shop.Items")) == null) continue;
            for (String key : itemsSection.getKeys(false)) {
                ItemStack shopItem;
                String itemType;
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(key);
                if (itemSection == null) continue;
                boolean hasSellPrice = itemSection.contains("Sell.Price");
                boolean sellEnabled = itemSection.getBoolean("Sell.Enable", true);
                if (!hasSellPrice || !sellEnabled || "COMMAND".equals(itemType = itemSection.getString("type", "VANILLA").toUpperCase()) || (shopItem = this.createShopItemForComparison(itemSection)) == null || !this.itemsMatchWithNBT(itemToSell, shopItem)) continue;
                double price = itemSection.getDouble("Sell.Price", 0.0);
                String economyType = this.getItemEconomyType(itemSection);
                return new SellResult(true, price, economyType, itemSection);
            }
        }
        return new SellResult(false, 0.0);
    }

    private Map<String, FileConfiguration> getShopConfigs() {
        return this.plugin.getMenuManager().getShopConfigs();
    }

    private ItemStack createShopItemForComparison(ConfigurationSection itemSection) {
        try {
            Material material;
            String itemName;
            String pluginName;
            ItemStack customItem;
            String[] parts;
            String materialString = itemSection.getString("Material", "STONE");
            if (materialString.contains(":") && (parts = materialString.split(":", 2)).length == 2 && (customItem = MrUltimateShopAPI.getCustomItem(pluginName = parts[0], itemName = parts[1])) != null) {
                ItemMeta meta;
                ItemStack clonedItem = customItem.clone();
                boolean enableCustomItemLore = itemSection.getBoolean("EnableCustomItemLore", false);
                if ((!enableCustomItemLore || itemSection.contains("Name") || itemSection.contains("Lore")) && (meta = clonedItem.getItemMeta()) != null) {
                    if (itemSection.contains("Name")) {
                        meta.setDisplayName(MrLibColors.colorize((String)itemSection.getString("Name")));
                    }
                    if (itemSection.contains("Lore") || !enableCustomItemLore) {
                        ArrayList<String> lore = new ArrayList<String>();
                        if (itemSection.contains("Lore")) {
                            for (String line : itemSection.getStringList("Lore")) {
                                lore.add(MrLibColors.colorize((String)line));
                            }
                        }
                        meta.setLore(lore);
                    }
                    clonedItem.setItemMeta(meta);
                }
                return clonedItem;
            }
            try {
                material = Material.valueOf((String)materialString);
            }
            catch (IllegalArgumentException e) {
                material = Material.STONE;
            }
            ItemStack item = new ItemStack(material);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                if (itemSection.contains("Name")) {
                    meta.setDisplayName(MrLibColors.colorize((String)itemSection.getString("Name")));
                }
                if (itemSection.contains("Lore")) {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : itemSection.getStringList("Lore")) {
                        lore.add(MrLibColors.colorize((String)line));
                    }
                    meta.setLore(lore);
                }
                if (itemSection.contains("CustomModelData")) {
                    meta.setCustomModelData(Integer.valueOf(itemSection.getInt("CustomModelData")));
                }
                item.setItemMeta(meta);
            }
            return item;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean itemsMatchWithNBT(ItemStack item1, ItemStack item2) {
        ItemMeta meta2;
        if (item1 == null || item2 == null) {
            return false;
        }
        if (item1.getType() != item2.getType()) {
            return false;
        }
        ItemMeta meta1 = item1.getItemMeta();
        if (meta1 == null != ((meta2 = item2.getItemMeta()) == null)) {
            return false;
        }
        if (meta1 != null && meta2 != null) {
            List lore2;
            String name2;
            String name1 = meta1.hasDisplayName() ? meta1.getDisplayName() : null;
            String string = name2 = meta2.hasDisplayName() ? meta2.getDisplayName() : null;
            if (!Objects.equals(name1, name2)) {
                return false;
            }
            List lore1 = meta1.hasLore() ? meta1.getLore() : null;
            List list = lore2 = meta2.hasLore() ? meta2.getLore() : null;
            if (!Objects.equals(lore1, lore2)) {
                return false;
            }
            if (meta1.hasCustomModelData() != meta2.hasCustomModelData()) {
                return false;
            }
            if (meta1.hasCustomModelData() && meta1.getCustomModelData() != meta2.getCustomModelData()) {
                return false;
            }
            if (!meta1.getEnchants().equals(meta2.getEnchants())) {
                return false;
            }
        }
        return true;
    }

    public void sellHandItem(Player player) {
        if (!player.hasPermission("mrultimateshop.command.shop.sell.hand")) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.no-permission", "&cYou don't have permission to use this command!"));
            return;
        }
        ItemStack handItem = player.getInventory().getItemInMainHand();
        if (handItem == null || handItem.getType() == Material.AIR) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("sell.no-item-in-hand", "{Prefix}&cYou don't have any item in your hand!"));
            return;
        }
        SellResult result = this.sellItem(handItem);
        if (result.success) {
            double totalPrice = result.price * (double)handItem.getAmount();
            this.plugin.getEconomyManager().deposit((OfflinePlayer)player, totalPrice);
            this.plugin.getStatisticsManager().recordSale(player, handItem, handItem.getAmount(), totalPrice);
            String currencySymbol = this.plugin.getEconomyManager().getCurrencySymbol();
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("sell.hand-success", "{Prefix}&aSuccessfully sold [quantity]x [item] for [price]!").replace("[quantity]", String.valueOf(handItem.getAmount())).replace("[item]", handItem.getType().name()).replace("[price]", String.format("%.2f", totalPrice) + " " + currencySymbol));
            player.getInventory().setItemInMainHand(null);
        } else {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("sell.cannot-sell", "{Prefix}&cThis item cannot be sold!"));
        }
    }

    public void sellAllItems(Player player) {
        if (!player.hasPermission("mrultimateshop.command.shop.sell.all")) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("errors.no-permission", "&cYou don't have permission to use this command!"));
            return;
        }
        HashMap<String, Double> economyTotals = new HashMap<String, Double>();
        int soldItemCount = 0;
        int inventorySize = player.getInventory().getSize();
        for (int i = 0; i < inventorySize; ++i) {
            ItemStack item = player.getInventory().getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            SellResult result = this.sellItem(item);
            if (!result.success) continue;
            double itemValue = result.price * (double)item.getAmount();
            economyTotals.put(result.economyType, economyTotals.getOrDefault(result.economyType, 0.0) + itemValue);
            soldItemCount += item.getAmount();
            this.plugin.getStatisticsManager().recordSale(player, item, item.getAmount(), itemValue);
            player.getInventory().setItem(i, null);
        }
        if (!economyTotals.isEmpty()) {
            for (Map.Entry entry : economyTotals.entrySet()) {
                String economyType = (String)entry.getKey();
                double amount = (Double)entry.getValue();
                this.plugin.getEconomyManager().deposit((OfflinePlayer)player, amount);
            }
            double totalValue = economyTotals.values().stream().mapToDouble(Double::doubleValue).sum();
            String currencySymbol = this.plugin.getEconomyManager().getCurrencySymbol();
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("sell.all-success", "{Prefix}&aSuccessfully sold [quantity] items for [price]!").replace("[quantity]", String.valueOf(soldItemCount)).replace("[price]", String.format("%.2f", totalValue) + " " + currencySymbol));
        } else {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("sell.no-sellable-items", "{Prefix}&cYou don't have any items that can be sold!"));
        }
    }

    public void reloadConfiguration() {
        this.loadConfiguration();
    }

    public void reloadSellAllGui() {
        this.loadConfiguration();
    }

    private String getItemEconomyType(ConfigurationSection itemSection) {
        return "VAULT";
    }

    public double getSellPrice(ItemStack item) {
        if (item == null) {
            return 0.0;
        }
        SellResult result = this.sellItem(item);
        return result.success ? result.price : 0.0;
    }

    public boolean canSellItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        SellResult result = this.sellItem(item);
        return result.success;
    }

    public double getTotalSellValue(Player player, ItemStack item) {
        if (player == null || item == null) {
            return 0.0;
        }
        SellResult result = this.sellItem(item);
        if (!result.success) {
            return 0.0;
        }
        int count = this.getSellableItemCount(player, item);
        return result.price * (double)count;
    }

    public int getSellableItemCount(Player player, ItemStack item) {
        if (player == null || item == null) {
            return 0;
        }
        if (!this.canSellItem(item)) {
            return 0;
        }
        int count = 0;
        for (ItemStack inventoryItem : player.getInventory().getContents()) {
            if (inventoryItem == null || !this.itemsMatchWithNBT(inventoryItem, item)) continue;
            count += inventoryItem.getAmount();
        }
        return count;
    }

    private static class SellResult {
        public final boolean success;
        public final double price;
        public final String economyType;
        public final ConfigurationSection itemSection;

        public SellResult(boolean success, double price) {
            this.success = success;
            this.price = price;
            this.economyType = "VAULT";
            this.itemSection = null;
        }

        public SellResult(boolean success, double price, String economyType, ConfigurationSection itemSection) {
            this.success = success;
            this.price = price;
            this.economyType = economyType;
            this.itemSection = itemSection;
        }
    }
}

