/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.chestshop;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ChestShop {
    private final UUID ownerUuid;
    private Location location;
    private ItemStack itemForTrade;
    private Double buyPricePerItem;
    private Double sellPricePerItem;
    private Inventory storageInventory;
    private boolean createdWithShopItem;
    private final Map<UUID, TeamRole> teamMembers;
    private final Map<UUID, TeamRole> shopSpecificMembers;

    public ChestShop(UUID ownerUuid) {
        this.ownerUuid = ownerUuid;
        this.teamMembers = new HashMap<UUID, TeamRole>();
        this.shopSpecificMembers = new HashMap<UUID, TeamRole>();
    }

    public UUID getOwnerUuid() {
        return this.ownerUuid;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public ItemStack getItemForTrade() {
        return this.itemForTrade;
    }

    public void setItemForTrade(ItemStack itemForTrade) {
        this.itemForTrade = itemForTrade;
    }

    public Double getBuyPricePerItem() {
        return this.buyPricePerItem;
    }

    public void setBuyPricePerItem(Double buyPricePerItem) {
        this.buyPricePerItem = buyPricePerItem;
    }

    public Double getSellPricePerItem() {
        return this.sellPricePerItem;
    }

    public void setSellPricePerItem(Double sellPricePerItem) {
        this.sellPricePerItem = sellPricePerItem;
    }

    public Inventory getStorageInventory() {
        return this.storageInventory;
    }

    public void setStorageInventory(Inventory storageInventory) {
        this.storageInventory = storageInventory;
    }

    public boolean isCreatedWithShopItem() {
        return this.createdWithShopItem;
    }

    public void setCreatedWithShopItem(boolean createdWithShopItem) {
        this.createdWithShopItem = createdWithShopItem;
    }

    public void addTeamMember(UUID playerUuid, TeamRole role) {
        this.teamMembers.put(playerUuid, role);
    }

    public void removeTeamMember(UUID playerUuid) {
        this.teamMembers.remove(playerUuid);
    }

    public void addShopSpecificMember(UUID playerUuid, TeamRole role) {
        this.shopSpecificMembers.put(playerUuid, role);
    }

    public void removeShopSpecificMember(UUID playerUuid) {
        this.shopSpecificMembers.remove(playerUuid);
    }

    public TeamRole getTeamRole(UUID playerUuid) {
        TeamRole globalRole = this.teamMembers.get(playerUuid);
        if (globalRole != null) {
            return globalRole;
        }
        return this.shopSpecificMembers.get(playerUuid);
    }

    public boolean isTeamMember(UUID playerUuid) {
        return this.teamMembers.containsKey(playerUuid) || this.shopSpecificMembers.containsKey(playerUuid);
    }

    public boolean isGlobalTeamMember(UUID playerUuid) {
        return this.teamMembers.containsKey(playerUuid);
    }

    public boolean isShopSpecificMember(UUID playerUuid) {
        return this.shopSpecificMembers.containsKey(playerUuid);
    }

    public boolean isOwner(UUID playerUuid) {
        return this.ownerUuid.equals(playerUuid);
    }

    public boolean hasAccess(UUID playerUuid) {
        return this.isOwner(playerUuid) || this.isTeamMember(playerUuid);
    }

    public boolean canEdit(UUID playerUuid) {
        if (this.isOwner(playerUuid)) {
            return true;
        }
        TeamRole role = this.getTeamRole(playerUuid);
        return role == TeamRole.EDITOR;
    }

    public boolean canAccessInventory(UUID playerUuid) {
        if (this.isOwner(playerUuid)) {
            return true;
        }
        TeamRole role = this.getTeamRole(playerUuid);
        return role == TeamRole.EDITOR || role == TeamRole.SUPPLEMENTER;
    }

    public boolean canManageTeam(UUID playerUuid) {
        return this.isOwner(playerUuid);
    }

    public Map<UUID, TeamRole> getTeamMembers() {
        return new HashMap<UUID, TeamRole>(this.teamMembers);
    }

    public Map<UUID, TeamRole> getShopSpecificMembers() {
        return new HashMap<UUID, TeamRole>(this.shopSpecificMembers);
    }

    public Map<UUID, TeamRole> getAllTeamMembers() {
        HashMap<UUID, TeamRole> allMembers = new HashMap<UUID, TeamRole>(this.teamMembers);
        allMembers.putAll(this.shopSpecificMembers);
        return allMembers;
    }

    public boolean canAddMoreTeamMembers() {
        return this.getAllTeamMembers().size() < 4;
    }

    public int getTeamMemberCount() {
        return this.getAllTeamMembers().size();
    }

    public static enum TeamRole {
        EDITOR,
        SUPPLEMENTER;

    }
}

