/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.integration;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.api.CustomItemProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;

public class HeadDatabaseIntegration
implements CustomItemProvider {
    private final MrUltimateShop plugin;
    private Class<?> headDatabaseAPIClass;
    private Method getItemHeadMethod;
    private Method getItemIDMethod;
    private Object apiInstance;

    public HeadDatabaseIntegration(MrUltimateShop plugin) {
        this.plugin = plugin;
        this.initializeReflection();
    }

    private void initializeReflection() {
        try {
            this.headDatabaseAPIClass = Class.forName("me.arcaniax.hdb.api.HeadDatabaseAPI");
            this.getItemHeadMethod = this.headDatabaseAPIClass.getMethod("getItemHead", String.class);
            this.getItemIDMethod = this.headDatabaseAPIClass.getMethod("getItemID", ItemStack.class);
            this.apiInstance = this.headDatabaseAPIClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to initialize HeadDatabase reflection: " + e.getMessage());
        }
    }

    @Override
    public String getPluginName() {
        return "HeadDatabase";
    }

    @Override
    public ItemStack getCustomItem(String itemName) {
        if (!this.hasCustomItem(itemName)) {
            return null;
        }
        try {
            if (this.getItemHeadMethod != null && this.apiInstance != null) {
                return (ItemStack)this.getItemHeadMethod.invoke(this.apiInstance, itemName);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error getting HeadDatabase head '" + itemName + "': " + e.getMessage());
        }
        return null;
    }

    @Override
    public boolean hasCustomItem(String itemName) {
        try {
            if (this.getItemHeadMethod != null && this.apiInstance != null) {
                ItemStack head = (ItemStack)this.getItemHeadMethod.invoke(this.apiInstance, itemName);
                return head != null;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Override
    public String[] getAvailableItems() {
        ArrayList items = new ArrayList();
        return items.toArray(new String[0]);
    }

    @Override
    public String getCustomItemDisplayName(String itemName) {
        try {
            ItemStack head;
            if (this.getItemHeadMethod != null && this.apiInstance != null && (head = (ItemStack)this.getItemHeadMethod.invoke(this.apiInstance, itemName)) != null && head.hasItemMeta() && head.getItemMeta().hasDisplayName()) {
                return head.getItemMeta().getDisplayName();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error getting HeadDatabase head display name for '" + itemName + "': " + e.getMessage());
        }
        return null;
    }

    @Override
    public boolean isAvailable() {
        try {
            return Bukkit.getPluginManager().getPlugin("HeadDatabase") != null && this.headDatabaseAPIClass != null && this.getItemHeadMethod != null && this.getItemIDMethod != null && this.apiInstance != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

