/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.integration;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.api.CustomItemProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;

public class ItemsAdderIntegration
implements CustomItemProvider {
    private final MrUltimateShop plugin;
    private Class<?> customStackClass;
    private Method getInstanceMethod;
    private Method isInRegistryMethod;
    private Method getItemStackMethod;

    public ItemsAdderIntegration(MrUltimateShop plugin) {
        this.plugin = plugin;
        this.initializeReflection();
    }

    private void initializeReflection() {
        try {
            this.customStackClass = Class.forName("dev.lone.itemsadder.api.CustomStack");
            this.getInstanceMethod = this.customStackClass.getMethod("getInstance", String.class);
            this.isInRegistryMethod = this.customStackClass.getMethod("isInRegistry", String.class);
            this.getItemStackMethod = this.customStackClass.getMethod("getItemStack", new Class[0]);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to initialize ItemsAdder reflection: " + e.getMessage());
        }
    }

    @Override
    public String getPluginName() {
        return "ItemsAdder";
    }

    @Override
    public ItemStack getCustomItem(String itemName) {
        if (!this.hasCustomItem(itemName)) {
            return null;
        }
        try {
            Object customStack;
            if (this.getInstanceMethod != null && this.getItemStackMethod != null && (customStack = this.getInstanceMethod.invoke(null, itemName)) != null) {
                return (ItemStack)this.getItemStackMethod.invoke(customStack, new Object[0]);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error getting ItemsAdder item '" + itemName + "': " + e.getMessage());
        }
        return null;
    }

    @Override
    public boolean hasCustomItem(String itemName) {
        try {
            if (this.isInRegistryMethod != null) {
                return (Boolean)this.isInRegistryMethod.invoke(null, itemName);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error checking ItemsAdder item '" + itemName + "': " + e.getMessage());
        }
        return false;
    }

    @Override
    public String[] getAvailableItems() {
        ArrayList items = new ArrayList();
        return items.toArray(new String[0]);
    }

    @Override
    public String getCustomItemDisplayName(String itemName) {
        try {
            ItemStack itemStack;
            Object customStack;
            if (this.getInstanceMethod != null && this.getItemStackMethod != null && (customStack = this.getInstanceMethod.invoke(null, itemName)) != null && (itemStack = (ItemStack)this.getItemStackMethod.invoke(customStack, new Object[0])).hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
                return itemStack.getItemMeta().getDisplayName();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error getting ItemsAdder item display name for '" + itemName + "': " + e.getMessage());
        }
        return null;
    }

    @Override
    public boolean isAvailable() {
        try {
            return Bukkit.getPluginManager().getPlugin("ItemsAdder") != null && this.customStackClass != null && this.getInstanceMethod != null && this.isInRegistryMethod != null && this.getItemStackMethod != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

