/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.managers;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.utils.ColorSystem;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class DemandTrackerManager {
    private final MrUltimateShop plugin;
    private FileConfiguration trackerConfig;
    private File trackerFile;
    private final Map<String, DemandData> demandCache;

    public DemandTrackerManager(MrUltimateShop plugin) {
        this.plugin = plugin;
        this.demandCache = new HashMap<String, DemandData>();
        this.loadTrackerData();
    }

    private void loadTrackerData() {
        this.trackerFile = new File(this.plugin.getDataFolder(), "tracker.yml");
        if (!this.trackerFile.exists()) {
            try {
                this.trackerFile.createNewFile();
                this.trackerConfig = new YamlConfiguration();
                this.saveTrackerData();
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Could not create tracker.yml: " + e.getMessage());
                return;
            }
        }
        this.trackerConfig = YamlConfiguration.loadConfiguration((File)this.trackerFile);
        this.loadDemandDataFromConfig();
    }

    private void loadDemandDataFromConfig() {
        ConfigurationSection itemsSection;
        this.demandCache.clear();
        if (this.trackerConfig.contains("Items") && (itemsSection = this.trackerConfig.getConfigurationSection("Items")) != null) {
            for (String itemKey : itemsSection.getKeys(false)) {
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(itemKey);
                if (itemSection == null) continue;
                DemandData data = new DemandData();
                data.buyCount = itemSection.getLong("BuyCount", 0L);
                data.sellCount = itemSection.getLong("SellCount", 0L);
                data.lastBuyPrice = itemSection.getDouble("LastBuyPrice", 0.0);
                data.lastSellPrice = itemSection.getDouble("LastSellPrice", 0.0);
                data.buyPriceMultiplier = itemSection.getDouble("BuyPriceMultiplier", 1.0);
                data.sellPriceMultiplier = itemSection.getDouble("SellPriceMultiplier", 1.0);
                data.lastUpdate = itemSection.getLong("LastUpdate", System.currentTimeMillis());
                this.demandCache.put(itemKey, data);
            }
        }
    }

    public void saveTrackerData() {
        if (this.trackerConfig == null || this.trackerFile == null) {
            return;
        }
        this.trackerConfig.set("Items", null);
        ConfigurationSection itemsSection = this.trackerConfig.createSection("Items");
        for (Map.Entry<String, DemandData> entry : this.demandCache.entrySet()) {
            ConfigurationSection itemSection = itemsSection.createSection(entry.getKey());
            DemandData data = entry.getValue();
            itemSection.set("BuyCount", (Object)data.buyCount);
            itemSection.set("SellCount", (Object)data.sellCount);
            itemSection.set("LastBuyPrice", (Object)data.lastBuyPrice);
            itemSection.set("LastSellPrice", (Object)data.lastSellPrice);
            itemSection.set("BuyPriceMultiplier", (Object)data.buyPriceMultiplier);
            itemSection.set("SellPriceMultiplier", (Object)data.sellPriceMultiplier);
            itemSection.set("LastUpdate", (Object)data.lastUpdate);
        }
        try {
            this.trackerConfig.save(this.trackerFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save tracker.yml: " + e.getMessage());
        }
    }

    public void recordBuyTransaction(ItemStack item, double price, int quantity) {
        this.recordBuyTransaction(item, price, quantity, null);
    }

    public void recordBuyTransaction(ItemStack item, double price, int quantity, String originalIdentifier) {
        if (!this.isTrackingEnabled() || !this.shouldTrackItem(item)) {
            return;
        }
        String itemKey = this.getItemKey(item, originalIdentifier);
        DemandData data = this.demandCache.computeIfAbsent(itemKey, k -> new DemandData());
        data.buyCount += (long)quantity;
        data.lastBuyPrice = price;
        data.lastUpdate = System.currentTimeMillis();
        this.applyGradualPriceChange(itemKey, data, true, quantity);
        if (data.buyCount % 10L == 0L) {
            this.saveTrackerData();
        }
    }

    public void recordSellTransaction(ItemStack item, double price, int quantity) {
        this.recordSellTransaction(item, price, quantity, null);
    }

    public void recordSellTransaction(ItemStack item, double price, int quantity, String originalIdentifier) {
        if (!this.isTrackingEnabled() || !this.shouldTrackItem(item)) {
            return;
        }
        String itemKey = this.getItemKey(item, originalIdentifier);
        DemandData data = this.demandCache.computeIfAbsent(itemKey, k -> new DemandData());
        data.sellCount += (long)quantity;
        data.lastSellPrice = price;
        data.lastUpdate = System.currentTimeMillis();
        this.applyGradualPriceChange(itemKey, data, false, quantity);
        if (data.sellCount % 10L == 0L) {
            this.saveTrackerData();
        }
    }

    public double getDynamicBuyPrice(ItemStack item, double basePrice) {
        return this.getDynamicBuyPrice(item, basePrice, null);
    }

    public double getDynamicBuyPrice(ItemStack item, double basePrice, String originalIdentifier) {
        if (!this.isTrackingEnabled() || !this.shouldTrackItem(item)) {
            return basePrice;
        }
        String itemKey = this.getItemKey(item, originalIdentifier);
        DemandData data = this.demandCache.get(itemKey);
        if (data == null) {
            return basePrice;
        }
        this.applyPriceDecayToItem(data);
        return basePrice * data.buyPriceMultiplier;
    }

    public double getDynamicSellPrice(ItemStack item, double basePrice) {
        return this.getDynamicSellPrice(item, basePrice, null);
    }

    public double getDynamicSellPrice(ItemStack item, double basePrice, String originalIdentifier) {
        if (!this.isTrackingEnabled() || !this.shouldTrackItem(item)) {
            return basePrice;
        }
        String itemKey = this.getItemKey(item, originalIdentifier);
        DemandData data = this.demandCache.get(itemKey);
        if (data == null) {
            return basePrice;
        }
        this.applyPriceDecayToItem(data);
        return basePrice * data.sellPriceMultiplier;
    }

    private double calculateDynamicPrice(double basePrice, long buyCount, long sellCount, boolean isBuyPrice) {
        double pressureDifference;
        long totalSellTransactions;
        String configKey;
        FileConfiguration config = this.plugin.getConfigManager().getConfig();
        String string = configKey = isBuyPrice ? "Features.Increase-Decrease-Buy-Prices-According-To-Demand" : "Features.Increase-Decrease-Sell-Prices-According-To-Demand";
        if (!config.getBoolean(configKey + ".enabled", true)) {
            return basePrice;
        }
        double minMultiplier = config.getDouble(configKey + ".Min-Price-Multiplier", 0.5);
        double maxMultiplier = config.getDouble(configKey + ".Max-Price-Multiplier", 1.5);
        long totalBuyTransactions = this.getTotalBuyTransactions();
        long totalTransactions = totalBuyTransactions + (totalSellTransactions = this.getTotalSellTransactions());
        if (totalTransactions < 10L) {
            return basePrice;
        }
        long itemTotalTransactions = buyCount + sellCount;
        double itemShare = (double)itemTotalTransactions / (double)totalTransactions;
        double buyPressure = (double)buyCount / (double)Math.max(1L, itemTotalTransactions);
        double sellPressure = (double)sellCount / (double)Math.max(1L, itemTotalTransactions);
        double priceChange = 0.0;
        if (buyPressure > sellPressure) {
            pressureDifference = buyPressure - sellPressure;
            priceChange = pressureDifference * 0.1;
        } else if (sellPressure > buyPressure) {
            pressureDifference = sellPressure - buyPressure;
            priceChange = -pressureDifference * 0.1;
        }
        double newPrice = basePrice * (1.0 + priceChange);
        double minPrice = basePrice * minMultiplier;
        double maxPrice = basePrice * maxMultiplier;
        return Math.max(minPrice, Math.min(maxPrice, newPrice));
    }

    private long getTotalBuyTransactions() {
        long total = 0L;
        for (DemandData data : this.demandCache.values()) {
            total += data.buyCount;
        }
        return total;
    }

    private long getTotalSellTransactions() {
        long total = 0L;
        for (DemandData data : this.demandCache.values()) {
            total += data.sellCount;
        }
        return total;
    }

    public String getFormattedBuyPrice(ItemStack item, double basePrice) {
        return this.getFormattedBuyPrice(item, basePrice, null);
    }

    public String getFormattedBuyPrice(ItemStack item, double basePrice, String originalIdentifier) {
        if (!this.isTrackingEnabled() || !this.shouldTrackItem(item)) {
            return this.plugin.getEconomyManager().formatMoney(basePrice);
        }
        String itemKey = this.getItemKey(item, originalIdentifier);
        DemandData data = this.demandCache.get(itemKey);
        if (data == null) {
            return this.plugin.getEconomyManager().formatMoney(basePrice);
        }
        double dynamicPrice = this.getDynamicBuyPrice(item, basePrice, originalIdentifier);
        double priceChange = (dynamicPrice - basePrice) / basePrice * 100.0;
        return this.formatPriceWithStrikethrough(basePrice, dynamicPrice, priceChange, true);
    }

    public String getFormattedSellPrice(ItemStack item, double basePrice) {
        return this.getFormattedSellPrice(item, basePrice, null);
    }

    public String getFormattedSellPrice(ItemStack item, double basePrice, String originalIdentifier) {
        if (!this.isTrackingEnabled() || !this.shouldTrackItem(item)) {
            return this.plugin.getEconomyManager().formatMoney(basePrice);
        }
        String itemKey = this.getItemKey(item, originalIdentifier);
        DemandData data = this.demandCache.get(itemKey);
        if (data == null) {
            return this.plugin.getEconomyManager().formatMoney(basePrice);
        }
        double dynamicPrice = this.getDynamicSellPrice(item, basePrice, originalIdentifier);
        double priceChange = (dynamicPrice - basePrice) / basePrice * 100.0;
        return this.formatPriceWithStrikethrough(basePrice, dynamicPrice, priceChange, false);
    }

    private String formatPriceWithStrikethrough(double basePrice, double currentPrice, double priceChange, boolean isBuyPrice) {
        String changeText;
        String color;
        String baseFormatted = this.plugin.getEconomyManager().formatMoney(basePrice);
        String currentFormatted = this.plugin.getEconomyManager().formatMoney(currentPrice);
        FileConfiguration config = this.plugin.getConfigManager().getConfig();
        String priceFormat = config.getString("Features.Demand-Tracking.Price-Format", "&m[original]&r [current] &8([color][change]%&8)");
        String highColor = config.getString("Features.Demand-Tracking.High-Color", "&a");
        String lowColor = config.getString("Features.Demand-Tracking.Low-Color", "&c");
        String normalColor = config.getString("Features.Demand-Tracking.Normal-Color", "&7");
        if (priceChange > 0.0) {
            color = highColor;
            changeText = "+" + String.format("%.1f", priceChange);
        } else if (priceChange < 0.0) {
            color = lowColor;
            changeText = String.format("%.1f", priceChange);
        } else {
            color = normalColor;
            changeText = "0.0";
        }
        String result = priceFormat.replace("[original]", baseFormatted).replace("[current]", currentFormatted).replace("[color]", color).replace("[change]", changeText);
        return ColorSystem.colorize(result);
    }

    private boolean isTrackingEnabled() {
        return this.plugin.getConfigManager().getConfig().getBoolean("Features.Increase-Decrease-Buy-Prices-According-To-Demand.enabled", true) || this.plugin.getConfigManager().getConfig().getBoolean("Features.Increase-Decrease-Sell-Prices-According-To-Demand.enabled", true);
    }

    private boolean shouldTrackItem(ItemStack item) {
        return item != null && item.getType() != Material.AIR;
    }

    private String getItemKey(ItemStack item) {
        return this.getItemKey(item, null);
    }

    private String getItemKey(ItemStack item, String originalIdentifier) {
        ItemMeta meta;
        StringBuilder key = new StringBuilder();
        if (originalIdentifier != null && originalIdentifier.contains(":")) {
            key.append(originalIdentifier);
            return key.toString();
        }
        if (item.hasItemMeta()) {
            meta = item.getItemMeta();
            if (meta.hasCustomModelData()) {
                key.append("ia:").append(item.getType().name()).append(":").append(meta.getCustomModelData());
                return key.toString();
            }
            if (meta.hasDisplayName() && meta.getDisplayName().contains("HeadDatabase")) {
                key.append("hdb:").append(item.getType().name()).append(":").append(meta.getDisplayName().hashCode());
                return key.toString();
            }
            if (meta.hasDisplayName() && !meta.getDisplayName().contains("HeadDatabase")) {
                key.append("custom:").append(item.getType().name()).append(":").append(meta.getDisplayName().hashCode());
                return key.toString();
            }
        }
        key.append(item.getType().name());
        if (item.hasItemMeta()) {
            meta = item.getItemMeta();
            if (meta.hasDisplayName()) {
                key.append(":").append(meta.getDisplayName().hashCode());
            }
            if (meta.hasLore()) {
                key.append(":").append(meta.getLore().hashCode());
            }
            if (meta.hasEnchants()) {
                key.append(":").append(meta.getEnchants().hashCode());
            }
        }
        return key.toString();
    }

    public void reloadTrackerData() {
        this.loadTrackerData();
    }

    public void shutdown() {
        this.saveTrackerData();
    }

    public void scheduleAutoSave() {
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> this.saveTrackerData(), 6000L, 6000L);
    }

    public void schedulePriceDecay() {
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> this.applyPriceDecay(), 12000L, 12000L);
    }

    private void applyPriceDecay() {
        FileConfiguration config = this.plugin.getConfigManager().getConfig();
        long buyDecayInterval = config.getLong("Features.Demand-Tracking.Buy-Decay-Interval", 600000L);
        long sellDecayInterval = config.getLong("Features.Demand-Tracking.Sell-Decay-Interval", 600000L);
        long minDecayInterval = Math.min(buyDecayInterval, sellDecayInterval);
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<String, DemandData> entry : this.demandCache.entrySet()) {
            DemandData data = entry.getValue();
            if (currentTime - data.lastUpdate <= minDecayInterval) continue;
            this.applyPriceDecayToItem(data);
        }
        this.saveTrackerData();
    }

    private void applyPriceDecayToItem(DemandData data) {
        FileConfiguration config = this.plugin.getConfigManager().getConfig();
        double decayRate = config.getDouble("Features.Demand-Tracking.Decay-Rate", 0.001);
        long buyDecayInterval = config.getLong("Features.Demand-Tracking.Buy-Decay-Interval", 600000L);
        long sellDecayInterval = config.getLong("Features.Demand-Tracking.Sell-Decay-Interval", 600000L);
        long currentTime = System.currentTimeMillis();
        long timeSinceUpdate = currentTime - data.lastUpdate;
        if (timeSinceUpdate > buyDecayInterval) {
            long buyDecayIntervals = timeSinceUpdate / buyDecayInterval;
            double buyDecayAmount = decayRate * (double)buyDecayIntervals;
            double minBuyMultiplier = config.getDouble("Features.Increase-Decrease-Buy-Prices-According-To-Demand.Min-Price-Multiplier", 0.1);
            data.buyPriceMultiplier = Math.max(minBuyMultiplier, data.buyPriceMultiplier - buyDecayAmount);
        }
        if (timeSinceUpdate > sellDecayInterval) {
            long sellDecayIntervals = timeSinceUpdate / sellDecayInterval;
            double sellDecayAmount = decayRate * (double)sellDecayIntervals;
            double maxSellMultiplier = config.getDouble("Features.Increase-Decrease-Sell-Prices-According-To-Demand.Max-Price-Multiplier", 1.5);
            data.sellPriceMultiplier = Math.min(maxSellMultiplier, data.sellPriceMultiplier + sellDecayAmount);
        }
        data.lastUpdate = currentTime;
    }

    private void applyGradualPriceChange(String itemKey, DemandData data, boolean isBuy, int quantity) {
        FileConfiguration config = this.plugin.getConfigManager().getConfig();
        double priceChangePerTransaction = config.getDouble("Features.Demand-Tracking.Price-Change-Per-Transaction", 1.0E-5);
        double maxPriceChange = config.getDouble("Features.Demand-Tracking.Max-Price-Change", 0.5);
        double changeAmount = Math.min(priceChangePerTransaction * (double)quantity, maxPriceChange);
        if (isBuy) {
            double maxBuyMultiplier = config.getDouble("Features.Increase-Decrease-Buy-Prices-According-To-Demand.Max-Price-Multiplier", 1.5);
            data.buyPriceMultiplier = Math.min(data.buyPriceMultiplier + changeAmount, maxBuyMultiplier);
        } else {
            double minSellMultiplier = config.getDouble("Features.Increase-Decrease-Sell-Prices-According-To-Demand.Min-Price-Multiplier", 0.5);
            data.sellPriceMultiplier = Math.max(data.sellPriceMultiplier - changeAmount, minSellMultiplier);
        }
        data.lastUpdate = System.currentTimeMillis();
    }

    private static class DemandData {
        long buyCount = 0L;
        long sellCount = 0L;
        double lastBuyPrice = 0.0;
        double lastSellPrice = 0.0;
        double buyPriceMultiplier = 1.0;
        double sellPriceMultiplier = 1.0;
        long lastUpdate = System.currentTimeMillis();

        private DemandData() {
        }
    }
}

