/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.chestshop.gui;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShop;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShopManager;
import eu.mrneznamy.mrultimateshop.chestshop.ChestShopSession;
import eu.mrneznamy.mrultimateshop.utils.ColorSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class OwnerShopMenu
implements Listener {
    private final MrUltimateShop plugin;

    public OwnerShopMenu(MrUltimateShop plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void open(Player player, ChestShop shop) {
        ConfigurationSection items;
        FileConfiguration cfg = this.plugin.getConfigManager().getConfig();
        ConfigurationSection section = cfg.getConfigurationSection("ChestShops.Menu.OwnerShop");
        String name = ColorSystem.colorize(section.getString("Name", "Owner Shop"));
        int size = section.getInt("Size", 54);
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)size, (String)name);
        ConfigurationSection deco = section.getConfigurationSection("Decorations");
        if (deco != null) {
            for (String k : deco.getKeys(false)) {
                String[] slots;
                ConfigurationSection d = deco.getConfigurationSection(k);
                Material mat = Material.matchMaterial((String)d.getString("Material", "BLACK_STAINED_GLASS_PANE"));
                ItemStack glass = new ItemStack(mat == null ? Material.BLACK_STAINED_GLASS_PANE : mat);
                ItemMeta im = glass.getItemMeta();
                im.setDisplayName(ColorSystem.colorize(d.getString("Name", " ")));
                glass.setItemMeta(im);
                for (String s : slots = d.getString("Slots", "").split(",")) {
                    if ((s = s.trim()).isEmpty()) continue;
                    try {
                        inv.setItem(Integer.parseInt(s), glass);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if ((items = section.getConfigurationSection("Items")) != null) {
            for (String k : items.getKeys(false)) {
                ConfigurationSection it = items.getConfigurationSection(k);
                Material mat = Material.matchMaterial((String)it.getString("Material", "STONE"));
                ItemStack is = new ItemStack(mat == null ? Material.STONE : mat);
                ItemMeta im = is.getItemMeta();
                String nameT = it.getString("Name", "Item");
                nameT = nameT.replace("[Buy-Price]", shop.getBuyPricePerItem() == null ? "-" : this.plugin.getEconomyManager().formatMoney(shop.getBuyPricePerItem()));
                nameT = nameT.replace("[Sell-Price]", shop.getSellPricePerItem() == null ? "-" : this.plugin.getEconomyManager().formatMoney(shop.getSellPricePerItem()));
                im.setDisplayName(ColorSystem.colorize(nameT));
                List lore = it.getStringList("Lore");
                ArrayList<String> colored = new ArrayList<String>();
                for (String l : lore) {
                    String t = l.replace("[Buy-Price]", shop.getBuyPricePerItem() == null ? "-" : this.plugin.getEconomyManager().formatMoney(shop.getBuyPricePerItem())).replace("[Sell-Price]", shop.getSellPricePerItem() == null ? "-" : this.plugin.getEconomyManager().formatMoney(shop.getSellPricePerItem()));
                    if ("TEAM_MANAGEMENT".equals(it.getString("Action", "").toUpperCase())) {
                        if (t.contains("[TeamMembers]")) {
                            Map<UUID, ChestShop.TeamRole> allMembers = shop.getAllTeamMembers();
                            if (allMembers.isEmpty()) {
                                t = t.replace("[TeamMembers]", "&8" + this.plugin.getMessageManager().getMessage("Chest-Shop.team-nobody", "Nobody"));
                                colored.add(ColorSystem.colorize(t));
                                continue;
                            }
                            int count = 0;
                            for (Map.Entry<UUID, ChestShop.TeamRole> entry : allMembers.entrySet()) {
                                if (count >= 4) break;
                                OfflinePlayer member = Bukkit.getOfflinePlayer((UUID)entry.getKey());
                                String memberName = member.getName();
                                if (memberName == null) continue;
                                String roleDisplay = entry.getValue().name().toLowerCase();
                                roleDisplay = roleDisplay.substring(0, 1).toUpperCase() + roleDisplay.substring(1);
                                String memberType = "";
                                memberType = shop.isGlobalTeamMember(entry.getKey()) ? " &7(Global)" : " &7(Shop)";
                                colored.add(ColorSystem.colorize("&a" + memberName + " &7- &e" + roleDisplay + memberType));
                                ++count;
                            }
                            if (allMembers.size() <= 4) continue;
                            colored.add(ColorSystem.colorize("&7... and " + (allMembers.size() - 4) + " more"));
                            continue;
                        }
                        t = t.replace("[TeamCount]", String.valueOf(shop.getTeamMemberCount()));
                    }
                    colored.add(ColorSystem.colorize(t));
                }
                im.setLore(colored);
                is.setItemMeta(im);
                int slot = it.getInt("slot", -1);
                if (slot < 0 || slot >= size) continue;
                inv.setItem(slot, is);
            }
        }
        player.openInventory(inv);
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        FileConfiguration cfg;
        String menuTitle;
        if (e.getView().getTitle() == null) {
            return;
        }
        String title = e.getView().getTitle();
        if (!title.equals(menuTitle = ColorSystem.colorize((cfg = this.plugin.getConfigManager().getConfig()).getConfigurationSection("ChestShops.Menu.OwnerShop").getString("Name", "")))) {
            return;
        }
        int topSize = e.getView().getTopInventory().getSize();
        if (e.getRawSlot() >= topSize) {
            e.setCancelled(false);
            return;
        }
        e.setCancelled(true);
        Player player = (Player)e.getWhoClicked();
        ChestShopManager csm = this.plugin.getChestShopManager();
        ChestShopSession session = csm.getSession(player.getUniqueId());
        if (session == null) {
            return;
        }
        ChestShop shop = session.getShop();
        ConfigurationSection items = cfg.getConfigurationSection("ChestShops.Menu.OwnerShop.Items");
        if (items == null) {
            return;
        }
        int clicked = e.getRawSlot();
        for (String k : items.getKeys(false)) {
            ConfigurationSection it = items.getConfigurationSection(k);
            int slot = it.getInt("slot", -1);
            if (slot != clicked) continue;
            String action = it.getString("Action", "").toUpperCase();
            boolean right = e.isRightClick();
            switch (action) {
                case "SET_ITEM": {
                    ItemStack source;
                    ItemStack cursor = e.getCursor();
                    ItemStack itemStack = source = cursor != null && cursor.getType() != Material.AIR ? cursor : player.getInventory().getItemInMainHand();
                    if (source == null || source.getType() == Material.AIR) {
                        return;
                    }
                    ItemStack oldItem = shop.getItemForTrade();
                    shop.setItemForTrade(source.clone());
                    csm.getLogManager().logItemChange(player, shop.getLocation(), oldItem, source);
                    if (cursor != null && cursor.getType() != Material.AIR) {
                        e.getView().setCursor(new ItemStack(Material.AIR));
                        player.getInventory().addItem(new ItemStack[]{cursor.clone()});
                    }
                    csm.saveShops();
                    csm.refreshHologram(shop);
                    csm.openOwnerMenu(player, shop);
                    return;
                }
                case "SET_BUY_PRICE": {
                    if (right) {
                        Double oldPrice = shop.getBuyPricePerItem();
                        if (shop.getBuyPricePerItem() == null) {
                            shop.setBuyPricePerItem(0.0);
                            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.buy-price-enabled", "{Prefix}&aBuy price enabled (set a value)."));
                        } else {
                            shop.setBuyPricePerItem(null);
                            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.buy-price-disabled", "{Prefix}&eBuy price disabled."));
                        }
                        csm.getLogManager().logPriceChange(player, shop.getLocation(), "BUY", oldPrice, shop.getBuyPricePerItem());
                        csm.saveShops();
                        csm.openOwnerMenu(player, shop);
                        return;
                    }
                    csm.requestPriceInput(player.getUniqueId(), shop, ChestShopManager.PriceType.BUY);
                    player.closeInventory();
                    player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.enter-buy-price", "{Prefix}&fEnter new buy price in chat:"));
                    csm.saveShops();
                    return;
                }
                case "SET_SELL_PRICE": {
                    if (right) {
                        Double oldPrice = shop.getSellPricePerItem();
                        if (shop.getSellPricePerItem() == null) {
                            shop.setSellPricePerItem(0.0);
                            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.sell-price-enabled", "{Prefix}&aSell price enabled (set a value)."));
                        } else {
                            shop.setSellPricePerItem(null);
                            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.sell-price-disabled", "{Prefix}&eSell price disabled."));
                        }
                        csm.getLogManager().logPriceChange(player, shop.getLocation(), "SELL", oldPrice, shop.getSellPricePerItem());
                        csm.saveShops();
                        csm.openOwnerMenu(player, shop);
                        return;
                    }
                    csm.requestPriceInput(player.getUniqueId(), shop, ChestShopManager.PriceType.SELL);
                    player.closeInventory();
                    player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.enter-sell-price", "{Prefix}&fEnter new sell price in chat:"));
                    csm.saveShops();
                    return;
                }
                case "OPEN_SHOP_INVENTORY": {
                    if (shop.getStorageInventory() != null) {
                        player.openInventory(shop.getStorageInventory());
                        csm.getLogManager().logInventoryAccess(player, shop.getLocation(), "opened");
                    }
                    return;
                }
                case "TEAM_MANAGEMENT": {
                    this.handleTeamManagement(player, shop, e);
                    return;
                }
            }
            return;
        }
    }

    private void handleTeamManagement(Player player, ChestShop shop, InventoryClickEvent e) {
        ChestShopManager csm = this.plugin.getChestShopManager();
        if (!shop.canManageTeam(player.getUniqueId())) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-not-owner", "{Prefix}&cOnly the owner can manage team members!"));
            return;
        }
        boolean isShiftClick = e.getClick().isShiftClick();
        boolean isRightClick = e.isRightClick();
        player.closeInventory();
        if (isRightClick) {
            if (isShiftClick) {
                csm.requestTeamInput(player.getUniqueId(), shop, ChestShopManager.ChatInputType.TEAM_REMOVE_NAME, true);
                player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-enter-remove-global", "{Prefix}&fEnter player name to remove from ALL shops:"));
            } else {
                csm.requestTeamInput(player.getUniqueId(), shop, ChestShopManager.ChatInputType.TEAM_REMOVE_NAME, false);
                player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-enter-remove-shop", "{Prefix}&fEnter player name to remove from THIS shop:"));
            }
        } else if (isShiftClick) {
            csm.requestTeamInput(player.getUniqueId(), shop, ChestShopManager.ChatInputType.TEAM_ADD_NAME, true);
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-enter-add-global", "{Prefix}&fEnter player name to add to ALL shops:"));
        } else {
            csm.requestTeamInput(player.getUniqueId(), shop, ChestShopManager.ChatInputType.TEAM_ADD_NAME, false);
            player.sendMessage(this.plugin.getMessageManager().getMessage("Chest-Shop.team-enter-add-shop", "{Prefix}&fEnter player name to add to THIS shop:"));
        }
    }

    @EventHandler
    public void onDrag(InventoryDragEvent e) {
        FileConfiguration cfg;
        String menuTitle;
        if (e.getView().getTitle() == null) {
            return;
        }
        String title = e.getView().getTitle();
        if (!title.equals(menuTitle = ColorSystem.colorize((cfg = this.plugin.getConfigManager().getConfig()).getConfigurationSection("ChestShops.Menu.OwnerShop").getString("Name", "")))) {
            return;
        }
        e.setCancelled(true);
    }
}

