/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.api;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.api.CustomItemProvider;
import eu.mrneznamy.mrultimateshop.api.CustomItemRegistry;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MrUltimateShopAPI {
    private static MrUltimateShop plugin;

    public static void initialize(MrUltimateShop pluginInstance) {
        plugin = pluginInstance;
        CustomItemRegistry.initialize(pluginInstance.getLogger());
    }

    public static double getItemStackPriceSell(ItemStack item) {
        if (plugin == null || item == null) {
            return 0.0;
        }
        double pricePerItem = plugin.getSellGuiManager().getSellPrice(item);
        if (pricePerItem <= 0.0) {
            return 0.0;
        }
        return pricePerItem * (double)item.getAmount();
    }

    public static double getItemStackPriceBuy(ItemStack item) {
        if (plugin == null || item == null) {
            return 0.0;
        }
        return plugin.getBuySellMenuManager().getBuyPrice(item);
    }

    public static boolean canSellItem(ItemStack item) {
        if (plugin == null || item == null) {
            return false;
        }
        return plugin.getSellGuiManager().canSellItem(item);
    }

    public static boolean canBuyItem(ItemStack item) {
        if (plugin == null || item == null) {
            return false;
        }
        return plugin.getBuySellMenuManager().canBuyItem(item);
    }

    public static double getTotalSellValue(Player player, ItemStack item) {
        if (plugin == null || player == null || item == null) {
            return 0.0;
        }
        return plugin.getSellGuiManager().getTotalSellValue(player, item);
    }

    public static int getSellableItemCount(Player player, ItemStack item) {
        if (plugin == null || player == null || item == null) {
            return 0;
        }
        return plugin.getSellGuiManager().getSellableItemCount(player, item);
    }

    public static boolean isAvailable() {
        return plugin != null;
    }

    public static String getVersion() {
        if (plugin == null) {
            return "Unknown";
        }
        return plugin.getDescription().getVersion();
    }

    public static boolean registerItemProvider(CustomItemProvider provider) {
        return CustomItemRegistry.registerItemProvider(provider);
    }

    public static boolean registerItem(String pluginName, String itemName, ItemStack itemStack) {
        return CustomItemRegistry.registerItem(pluginName, itemName, itemStack);
    }

    public static ItemStack getCustomItem(String pluginName, String itemName) {
        return CustomItemRegistry.getCustomItem(pluginName, itemName);
    }

    public static boolean hasCustomItem(String pluginName, String itemName) {
        return CustomItemRegistry.hasCustomItem(pluginName, itemName);
    }

    public static boolean unregisterItemProvider(String pluginName) {
        return CustomItemRegistry.unregisterItemProvider(pluginName);
    }

    public static int getCustomItemProviderCount() {
        return CustomItemRegistry.getProviderCount();
    }

    public static int getCustomItemCount() {
        return CustomItemRegistry.getItemCount();
    }

    public static void clearAllRegistrations() {
        CustomItemRegistry.clearAll();
    }
}

