/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.commands;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.utils.ColorSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class MusCommand
implements CommandExecutor,
TabCompleter {
    private final MrUltimateShop plugin;

    public MusCommand(MrUltimateShop plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("mrultimateshop.reload")) {
                    sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("errors.no-permission", "&cYou don't have permission to use this command!")));
                    return true;
                }
                this.plugin.reloadConfiguration();
                sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("commands.config-reloaded", "&aConfiguration has been successfully loaded!")));
                return true;
            }
            case "shop": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("errors.player-only", "&cThis command can only be used by a player!")));
                    return true;
                }
                Player player = (Player)sender;
                if (!player.hasPermission("mrultimateshop.shop")) {
                    player.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("errors.no-permission", "&cYou don't have permission to use this command!")));
                    return true;
                }
                this.plugin.getMenuManager().openMainMenu(player);
                return true;
            }
            case "help": {
                this.sendHelpMessage(sender);
                return true;
            }
            case "list": {
                if (!sender.hasPermission("mrultimateshop.list")) {
                    sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("errors.no-permission", "&cYou don't have permission to use this command!")));
                    return true;
                }
                sender.sendMessage(ColorSystem.colorize("&a&l[MrUltimateShop] &fAvailable shops:"));
                Set<String> shops = this.plugin.getMenuManager().getAvailableShops();
                if (shops.isEmpty()) {
                    sender.sendMessage(ColorSystem.colorize("&cNo shops found!"));
                } else {
                    for (String shopName : shops) {
                        sender.sendMessage(ColorSystem.colorize("&e- " + shopName));
                    }
                }
                return true;
            }
        }
        this.sendHelpMessage(sender);
        return true;
    }

    private void sendHelpMessage(CommandSender sender) {
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("commands.help-header", "&a&l[MrUltimateShop] &fHelp:")));
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("commands.help-reload", "&e/mus reload &f- Loads configuration")));
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("commands.help-shop", "&e/mus shop &f- Opens shop menu")));
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("commands.help-list", "&e/mus list &f- Lists available shops")));
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("commands.help-help", "&e/mus help &f- Shows this help")));
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("commands.help-author", "&fAuthor: &e_MrNeznamy_")));
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("commands.help-version", "&fVersion: &e1.0.0")));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subcommands = Arrays.asList("reload", "shop", "list", "help");
            return subcommands.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).filter(s -> this.hasPermissionForSubcommand(sender, (String)s)).collect(Collectors.toList());
        }
        return completions;
    }

    private boolean hasPermissionForSubcommand(CommandSender sender, String subcommand) {
        switch (subcommand) {
            case "reload": {
                return sender.hasPermission("mrultimateshop.reload");
            }
            case "shop": {
                return sender.hasPermission("mrultimateshop.shop");
            }
            case "list": {
                return sender.hasPermission("mrultimateshop.list");
            }
        }
        return true;
    }
}

