/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrultimateshop.managers;

import eu.mrneznamy.mrultimateshop.MrUltimateShop;
import eu.mrneznamy.mrultimateshop.utils.ColorSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private final MrUltimateShop plugin;
    private FileConfiguration messagesConfig;
    private File messagesFile;

    public MessageManager(MrUltimateShop plugin) {
        this.plugin = plugin;
    }

    public void loadMessages() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defConfigStream = this.plugin.getResource("messages.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.messagesConfig.setDefaults((Configuration)defConfig);
        }
    }

    public void reloadMessages() {
        if (this.messagesFile == null) {
            this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defConfigStream = this.plugin.getResource("messages.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.messagesConfig.setDefaults((Configuration)defConfig);
        }
    }

    public void saveMessages() {
        if (this.messagesConfig == null || this.messagesFile == null) {
            return;
        }
        try {
            this.messagesConfig.save(this.messagesFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getMessage(String path) {
        String message = this.messagesConfig.getString(path);
        if (message == null) {
            return "&cZpr\u00e1va nenalezena: " + path;
        }
        String prefix = this.messagesConfig.getString("MrUltimateShop.Prefix", "{#FF58DF>}&lMrUltimateShop{#FF58C4<} &8| ");
        if ((message = message.replace("{Prefix}", prefix)).contains("[CURRENCY_SYMBOL]")) {
            String currencySymbol = this.plugin.getEconomyManager().getCurrencySymbol();
            message = message.replace("[CURRENCY_SYMBOL]", currencySymbol);
        }
        return ColorSystem.colorize(message);
    }

    public String getMessage(String path, String defaultMessage) {
        String message = this.messagesConfig.getString(path, defaultMessage);
        String prefix = this.messagesConfig.getString("MrUltimateShop.Prefix", "{#FF58DF>}&lMrUltimateShop{#FF58C4<} &8| ");
        if ((message = message.replace("{Prefix}", prefix)).contains("[CURRENCY_SYMBOL]")) {
            String currencySymbol = this.plugin.getEconomyManager().getCurrencySymbol();
            message = message.replace("[CURRENCY_SYMBOL]", currencySymbol);
        }
        return ColorSystem.colorize(message);
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }
}

