/*
 * Decompiled with CFR 0.152.
 */
package net.theevilm.pochatok.config;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="pochatok")
public class Configs
implements ConfigData {
    private boolean forceShowNameTags = false;
    private boolean hidePlayersNameTags = false;
    private boolean isLightVisible = false;
    private boolean creativeFlyToggled = false;
    private boolean signClick = true;
    @ConfigEntry.BoundedDiscrete(min=1L, max=200L)
    private int nameTagForceRenderDistance = 32;
    @ConfigEntry.Gui.Excluded
    private float minCreativeFlySpeed = 0.05f;
    @ConfigEntry.Gui.Excluded
    private float maxCreativeFlySpeed = 1.0f;
    @ConfigEntry.BoundedDiscrete(min=5L, max=100L)
    private int toggledFlySpeed = 50;

    public boolean isForceShowNameTags() {
        return this.forceShowNameTags;
    }

    public void setShowNameTags(boolean setShowNameTags) {
        this.forceShowNameTags = setShowNameTags;
    }

    public boolean isHidePlayersNameTags() {
        return this.hidePlayersNameTags;
    }

    public void setHideAllNameTags(boolean hideAllNameTags) {
        this.hidePlayersNameTags = hideAllNameTags;
    }

    public int getNameTagForceRenderDistance() {
        return this.nameTagForceRenderDistance;
    }

    public boolean isSignClick() {
        return this.signClick;
    }

    public boolean isLightVisible() {
        return this.isLightVisible;
    }

    public void setLightVisible(boolean lightVisible) {
        this.isLightVisible = lightVisible;
    }

    private float ensureRange(float value, float min, float max) {
        return Math.min(Math.max(value, min), max);
    }

    public boolean isCreativeFlyToggled() {
        return this.creativeFlyToggled;
    }

    public void setCreativeFlyToggled(boolean creativeFlyToggled) {
        this.creativeFlyToggled = creativeFlyToggled;
    }

    public float getMinCreativeFlySpeed() {
        return this.minCreativeFlySpeed;
    }

    public float getMaxCreativeFlySpeed() {
        return this.maxCreativeFlySpeed;
    }

    public float getToggledFlySpeed() {
        float flySpeed = (float)this.toggledFlySpeed / 100.0f;
        return this.ensureRange(flySpeed, this.getMinCreativeFlySpeed(), this.getMaxCreativeFlySpeed());
    }

    public void setToggledFlySpeed(float speed) {
        float flySpeed = this.ensureRange(speed, this.getMinCreativeFlySpeed(), this.getMaxCreativeFlySpeed());
        this.toggledFlySpeed = Math.round(flySpeed * 100.0f);
    }

    public float getCurrentFlySpeed() {
        return this.isCreativeFlyToggled() ? this.getToggledFlySpeed() : this.getMinCreativeFlySpeed();
    }
}

