/*
 * Decompiled with CFR 0.152.
 */
package net.theevilm.pochatok.event;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.theevilm.pochatok.renderer.SignRenderer;
import net.theevilm.pochatok.util.InfoProvider;

public class SignSearchHandler {
    private static void registerRender(SignRenderer signRenderer) {
        WorldRenderEvents.LAST.register(context -> {
            if (signRenderer.isSearchString()) {
                signRenderer.findAndRenderSigns();
                signRenderer.render(context.matrixStack());
            }
        });
        ClientPlayConnectionEvents.INIT.register((handler, client) -> signRenderer.disable());
    }

    private static void registerCommand(SignRenderer signRenderer) {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"signsearch").then(ClientCommandManager.argument((String)"query", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            if (!signRenderer.isEnabled()) {
                signRenderer.enable();
            }
            String searchText = StringArgumentType.getString((CommandContext)context, (String)"query");
            signRenderer.setMask(false);
            signRenderer.setSearchString(searchText);
            signRenderer.clearVisited();
            InfoProvider.showSignMessage(true, searchText);
            return 1;
        }))).executes(context -> {
            signRenderer.disable();
            InfoProvider.showSignMessage(false, "");
            signRenderer.clearSearchString();
            return 1;
        })));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"signsearchmask").then(ClientCommandManager.argument((String)"query", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            if (!signRenderer.isEnabled()) {
                signRenderer.enable();
            }
            String searchText = StringArgumentType.getString((CommandContext)context, (String)"query");
            signRenderer.setMask(true);
            signRenderer.setSearchString(searchText);
            signRenderer.clearVisited();
            InfoProvider.showSignMessage(true, searchText);
            return 1;
        }))).executes(context -> {
            signRenderer.disable();
            InfoProvider.showSignMessage(false, "");
            signRenderer.clearSearchString();
            return 1;
        })));
    }

    public static void register(SignRenderer signRenderer) {
        SignSearchHandler.registerRender(signRenderer);
        SignSearchHandler.registerCommand(signRenderer);
    }
}

