/*
 * Decompiled with CFR 0.152.
 */
package net.theevilm.pochatok.renderer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2818;
import net.minecraft.class_4587;
import net.theevilm.pochatok.PochatokClient;
import net.theevilm.pochatok.renderer.SignBlockNPos;
import net.theevilm.pochatok.renderer.SignBoxRenderer;

public class SignRenderer {
    protected final ArrayList<SignBlockNPos> boxes_list = new ArrayList();
    public boolean enabled = false;
    private final Set<class_2338> visited = new HashSet<class_2338>();
    private String searchString = "";
    private boolean mask = false;

    public void setMask(boolean isMask) {
        this.mask = isMask;
    }

    public void setSearchString(String newString) {
        this.searchString = newString;
    }

    public void clearSearchString() {
        this.searchString = "";
    }

    public void addToVisited(class_2338 pos) {
        this.visited.add(pos);
    }

    public void clearVisited() {
        this.visited.clear();
    }

    public boolean isSearchString() {
        return !this.searchString.isEmpty();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable() {
        this.enabled = true;
        this.clearVisited();
    }

    public void disable() {
        this.enabled = false;
        this.boxes_list.clear();
        this.clearVisited();
        this.clearSearchString();
    }

    public void findAndRenderSigns() {
        if (PochatokClient.MC.field_1687 == null) {
            return;
        }
        this.boxes_list.clear();
        ArrayList blockEntities = this.getBlockEntitiesStream().collect(Collectors.toCollection(ArrayList::new));
        for (class_2586 blockEntity : blockEntities) {
            class_2338 pos;
            class_238 box;
            if (!(blockEntity instanceof class_2625) || !this.textMatchesSign((class_2625)blockEntity) || (box = PochatokClient.MC.field_1687.method_8320(pos = blockEntity.method_11016()).method_26218((class_1922)PochatokClient.MC.field_1687, pos).method_1107().method_996(pos)) == null) continue;
            this.boxes_list.add(new SignBlockNPos(box, pos));
        }
    }

    public void render(class_4587 matrices) {
        SignBoxRenderer.renderSigns(matrices, this.boxes_list, this.visited);
    }

    public Stream<class_2586> getBlockEntitiesStream() {
        return this.getChuncksStream().flatMap(chunk -> chunk.method_12214().values().stream());
    }

    public Stream<class_2818> getChuncksStream() {
        if (PochatokClient.MC.field_1724 == null) {
            return Stream.empty();
        }
        int radius = Math.min(2, PochatokClient.MC.field_1690.method_38521());
        int diameter = radius * 2 + 1;
        class_1923 center = PochatokClient.MC.field_1724.method_31476();
        class_1923 min = new class_1923(center.field_9181 - radius, center.field_9180 - radius);
        class_1923 max = new class_1923(center.field_9181 + radius, center.field_9180 + radius);
        Stream<class_2818> stream = Stream.iterate(min, pos -> {
            int x = pos.field_9181;
            int z = pos.field_9180;
            if (++x > max.field_9181) {
                x = min.field_9181;
                ++z;
            }
            if (z > max.field_9180) {
                throw new IllegalStateException("meh...");
            }
            return new class_1923(x, z);
        }).limit((long)diameter * (long)diameter).filter(c -> PochatokClient.MC.field_1687 != null && PochatokClient.MC.field_1687.method_8393(c.field_9181, c.field_9180)).map(c -> PochatokClient.MC.field_1687.method_8497(c.field_9181, c.field_9180)).filter(Objects::nonNull);
        return stream;
    }

    public boolean textMatchesSign(class_2625 sign) {
        if (this.searchString.isEmpty()) {
            return false;
        }
        StringBuilder signText = new StringBuilder();
        for (class_2561 class_25612 : sign.method_49853().method_49877(false)) {
            class_25612.method_27657(part -> {
                signText.append(part);
                return Optional.empty();
            });
            signText.append(" ");
        }
        for (class_2561 class_25613 : sign.method_49854().method_49877(false)) {
            class_25613.method_27657(part -> {
                signText.append(part);
                return Optional.empty();
            });
            signText.append(" ");
        }
        if (this.mask) {
            Pattern pattern = Pattern.compile(this.searchString);
            Matcher matcher = pattern.matcher(signText.toString().toLowerCase());
            return matcher.find();
        }
        for (String string : this.searchString.split(" ")) {
            if (!signText.toString().toLowerCase().contains(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

