/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.test.runner.TestMode;
import ch.njol.skript.util.Version;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.bound.BoundConfig;
import com.shanebeestudios.skbee.api.fastboard.FastBoardManager;
import com.shanebeestudios.skbee.api.listener.EntityListener;
import com.shanebeestudios.skbee.api.listener.NBTListener;
import com.shanebeestudios.skbee.api.listener.OnTheFlipSide;
import com.shanebeestudios.skbee.api.nbt.NBTApi;
import com.shanebeestudios.skbee.api.nbt.utils.MinecraftVersion;
import com.shanebeestudios.skbee.api.property.PropertyRegistry;
import com.shanebeestudios.skbee.api.structure.StructureManager;
import com.shanebeestudios.skbee.api.util.LoggerBee;
import com.shanebeestudios.skbee.api.util.SkriptUtils;
import com.shanebeestudios.skbee.api.util.Util;
import com.shanebeestudios.skbee.api.virtualfurnace.api.VirtualFurnaceAPI;
import com.shanebeestudios.skbee.config.Config;
import com.shanebeestudios.skbee.elements.virtualfurnace.listener.VirtualFurnaceListener;
import com.shanebeestudios.skbee.elements.worldcreator.objects.BeeWorldConfig;
import java.io.IOException;
import org.bukkit.Statistic;
import org.bukkit.boss.BossBar;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Objective;

public class AddonLoader {
    private final SkBee plugin;
    private final PluginManager pluginManager;
    private final Config config;
    private final Plugin skriptPlugin;
    private SkriptAddon addon;
    private boolean textComponentEnabled;

    public AddonLoader(SkBee plugin) {
        this.plugin = plugin;
        this.pluginManager = plugin.getServer().getPluginManager();
        this.config = plugin.getPluginConfig();
        MinecraftVersion.replaceLogger(LoggerBee.getLogger());
        this.skriptPlugin = this.pluginManager.getPlugin("Skript");
    }

    boolean canLoadPlugin() {
        if (this.skriptPlugin == null) {
            Util.logLoading("&cDependency Skript was not found, Skript elements cannot load.", new Object[0]);
            return false;
        }
        if (!this.skriptPlugin.isEnabled()) {
            Util.logLoading("&cDependency Skript is not enabled, Skript elements cannot load.", new Object[0]);
            Util.logLoading("&cThis could mean SkBee is being forced to load before Skript.", new Object[0]);
            return false;
        }
        Version skriptVersion = Skript.getVersion();
        if (skriptVersion.isSmallerThan(new Version(new int[]{2, 9, 999}))) {
            Util.logLoading("&cDependency Skript outdated, Skript elements cannot load.", new Object[0]);
            Util.logLoading("&eSkBee requires Skript 2.10+ but found Skript " + String.valueOf(skriptVersion), new Object[0]);
            return false;
        }
        if (!Skript.isAcceptRegistrations()) {
            Util.logLoading("&cSkript is no longer accepting registrations, addons can no longer be loaded!", new Object[0]);
            if (this.isPlugmanReloaded()) {
                Util.logLoading("&cIt appears you're running PlugMan.", new Object[0]);
                Util.logLoading("&cIf you're trying to reload/enable SkBee with PlugMan.... you can't.", new Object[0]);
                Util.logLoading("&ePlease restart your server!", new Object[0]);
            } else {
                Util.logLoading("&cNo clue how this could happen.", new Object[0]);
                Util.logLoading("&cSeems a plugin is delaying SkBee loading, which is after Skript stops accepting registrations.", new Object[0]);
            }
            return false;
        }
        Version version = new Version(SkBee.EARLIEST_VERSION);
        if (!Skript.isRunningMinecraft((Version)version)) {
            Util.logLoading("&cYour server version &7'&bMC %s&7'&c is not supported, only &7'&bMC %s+&7'&c is supported!", Skript.getMinecraftVersion(), version);
            Util.logLoading("&7For outdated server versions please see: &ehttps://github.com/ShaneBeee/SkBee#outdated", new Object[0]);
            return false;
        }
        this.loadSkriptElements();
        return true;
    }

    private void loadSkriptElements() {
        this.addon = Skript.registerAddon((JavaPlugin)this.plugin);
        this.addon.setLanguageFileDirectory("lang");
        int[] elementCountBefore = SkriptUtils.getElementCount();
        this.loadRegistryElements();
        this.loadOtherElements();
        this.loadNBTElements();
        this.loadTextElements();
        this.loadAdvancementElements();
        this.loadBossBarElements();
        this.loadBoundElements();
        this.loadDamageSourceElements();
        this.loadDisplayEntityElements();
        this.loadFastboardElements();
        this.loadFishingElements();
        this.loadGameEventElements();
        this.loadItemComponentElements();
        this.loadParticleElements();
        this.loadPropertyElements();
        this.loadRayTraceElements();
        this.loadRecipeElements();
        this.loadScoreboardElements();
        this.loadStatisticElements();
        this.loadStructureElements();
        this.loadSwitchCaseElements();
        this.loadTickManagerElements();
        this.loadVillagerElements();
        this.loadVirtualFurnaceElements();
        this.loadWorldBorderElements();
        this.loadWorldCreatorElements();
        this.loadChunkGenElements();
        this.loadTestingElements();
        int[] elementCountAfter = SkriptUtils.getElementCount();
        int[] finish = new int[elementCountBefore.length];
        int total = 0;
        for (int i = 0; i < elementCountBefore.length; ++i) {
            finish[i] = elementCountAfter[i] - elementCountBefore[i];
            total += finish[i];
        }
        String[] elementNames = new String[]{"event", "effect", "expression", "condition", "section"};
        Util.log("Loaded (%s) elements:", total);
        for (int i = 0; i < finish.length; ++i) {
            Util.log(" - %s %s%s", finish[i], elementNames[i], finish[i] == 1 ? "" : "s");
        }
        if (this.config.ELEMENTS_PROPERTY) {
            int size = PropertyRegistry.properties().size();
            Util.log(" - %s properties", size);
        }
        if (this.config.RUNTIME_DISABLE_ERRORS) {
            Util.logLoading("&eRuntime Errors have been disabled via config!", new Object[0]);
        }
        if (this.config.RUNTIME_DISABLE_WARNINGS) {
            Util.logLoading("&eRuntime Warnings have been disabled via config!", new Object[0]);
        }
    }

    private void loadNBTElements() {
        if (!this.config.ELEMENTS_NBT) {
            Util.logLoading("&5NBT Elements &cdisabled via config", new Object[0]);
            return;
        }
        NBTApi.initializeAPI();
        if (!NBTApi.isEnabled()) {
            String ver = Skript.getMinecraftVersion().toString();
            Util.logLoading("&5NBT Elements &cDISABLED!", new Object[0]);
            Util.logLoading(" - Your server version [&b" + ver + "&7] is not currently supported by the NBT-API", new Object[0]);
            Util.logLoading(" - This is not a bug!", new Object[0]);
            Util.logLoading(" - NBT elements will resume once the API is updated to work with [&b" + ver + "&7]", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.nbt", new String[0]);
            new NBTListener(this.plugin);
            Util.logLoading("&5NBT Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("NBT", ex);
        }
    }

    private void loadRecipeElements() {
        if (!this.config.ELEMENTS_RECIPE) {
            Util.logLoading("&5Recipe Elements &cdisabled via config", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.recipe", new String[0]);
            Util.logLoading("&5Recipe Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("Recipe", ex);
        }
    }

    private void loadFastboardElements() {
        if (!this.config.ELEMENTS_FASTBOARD) {
            Util.logLoading("&5Fastboard Elements &cdisabled via config", new Object[0]);
            return;
        }
        try {
            this.pluginManager.registerEvents((Listener)new FastBoardManager(this.plugin, this.textComponentEnabled), (Plugin)this.plugin);
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.fastboard", new String[0]);
            String type = this.textComponentEnabled ? "Adventure" : "Legacy";
            Util.logLoading("&5Fastboard&7[&b%s&7] &5Elements &asuccessfully loaded", type);
        }
        catch (Exception ex) {
            this.logFailure("Fastboard", ex);
        }
    }

    private void loadScoreboardElements() {
        if (!this.config.ELEMENTS_SCOREBOARD) {
            Util.logLoading("&5Scoreboard Elements &cdisabled via config", new Object[0]);
            return;
        }
        if (Classes.getClassInfoNoError((String)"objective") != null || Classes.getExactClassInfo(Objective.class) != null) {
            Util.logLoading("&5Scoreboard Elements &cdisabled", new Object[0]);
            Util.logLoading("&7It appears another Skript addon may have registered Scoreboard syntax.", new Object[0]);
            Util.logLoading("&7To use SkBee Scoreboards, please remove the addon which has registered Scoreboard already.", new Object[0]);
            return;
        }
        if (Util.IS_RUNNING_FOLIA) {
            Util.logLoading("&5Scoreboard Elements &cdisabled &7(&eCurrently not supported on Folia&7)", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.scoreboard", new String[0]);
            Util.logLoading("&5Scoreboard Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("Scoreboard", ex);
        }
    }

    private void loadTickManagerElements() {
        if (!this.config.ELEMENTS_TICK_MANAGER) {
            Util.logLoading("&5Tick Manager Elements &cdisabled via config", new Object[0]);
            return;
        }
        if (!Skript.classExists((String)"org.bukkit.ServerTickManager")) {
            Util.logLoading("&5Tick Manager Elements &cdisabled &7(&eRequires Minecraft 1.20.4+&7)", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.tickmanager", new String[0]);
            Util.logLoading("&5Tick Manager Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("Tick Manager", ex);
        }
    }

    private void loadBoundElements() {
        if (!this.config.ELEMENTS_BOUND) {
            Util.logLoading("&5Bound Elements &cdisabled via config", new Object[0]);
            return;
        }
        try {
            this.plugin.boundConfig = new BoundConfig(this.plugin);
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.bound", new String[0]);
            Util.logLoading("&5Bound Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("Bound", ex);
        }
    }

    private void loadTextElements() {
        if (!this.config.ELEMENTS_TEXT_COMPONENT) {
            Util.logLoading("&5Text Component Elements &cdisabled via config", new Object[0]);
            return;
        }
        if (!Skript.classExists((String)"io.papermc.paper.event.player.AsyncChatEvent")) {
            Util.logLoading("&5Text Component Elements &cdisabled", new Object[0]);
            Util.logLoading("&7- Text components require a PaperMC server.", new Object[0]);
            return;
        }
        if (Classes.getClassInfoNoError((String)"textcomponent") != null) {
            Util.logLoading("&5Text Component Elements &cdisabled", new Object[0]);
            Util.logLoading("&7It appears another Skript addon may have registered Text Component syntax.", new Object[0]);
            Util.logLoading("&7To use SkBee Text Components, please remove the addon which has registered Text Components already.", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.text", new String[0]);
            Util.logLoading("&5Text Component Elements &asuccessfully loaded", new Object[0]);
            this.textComponentEnabled = true;
        }
        catch (Exception ex) {
            this.logFailure("Text Component", ex);
        }
    }

    private void loadStructureElements() {
        if (!this.config.ELEMENTS_STRUCTURE) {
            Util.logLoading("&5Structure Elements &cdisabled via config", new Object[0]);
            return;
        }
        this.plugin.structureManager = new StructureManager();
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.structure", new String[0]);
            Util.logLoading("&5Structure Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("Structure", ex);
        }
    }

    private void loadVirtualFurnaceElements() {
        if (!this.config.ELEMENTS_VIRTUAL_FURNACE) {
            Util.logLoading("&5Virtual Furnace Elements &cdisabled via config", new Object[0]);
            return;
        }
        if (!Skript.classExists((String)"net.kyori.adventure.text.Component")) {
            Util.logLoading("&5Virtual Furnace Elements &cdisabled", new Object[0]);
            Util.logLoading("&7- Virtual Furnace require a PaperMC server.", new Object[0]);
            return;
        }
        try {
            this.plugin.virtualFurnaceAPI = new VirtualFurnaceAPI(this.plugin, true);
            this.pluginManager.registerEvents((Listener)new VirtualFurnaceListener(), (Plugin)this.plugin);
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.virtualfurnace", new String[0]);
            Util.logLoading("&5Virtual Furnace Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("Virtual Furnace", ex);
        }
    }

    private void loadOtherElements() {
        try {
            if (Skript.classExists((String)"com.destroystokyo.paper.event.entity.EntityAddToWorldEvent")) {
                this.pluginManager.registerEvents((Listener)new OnTheFlipSide(), (Plugin)this.plugin);
            }
            this.pluginManager.registerEvents((Listener)new EntityListener(), (Plugin)this.plugin);
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.other", new String[0]);
        }
        catch (Exception ex) {
            this.logFailure("Other", ex);
        }
    }

    private void loadWorldCreatorElements() {
        if (!this.config.ELEMENTS_WORLD_CREATOR) {
            Util.logLoading("&5World Creator Elements &cdisabled via config", new Object[0]);
            return;
        }
        if (Util.IS_RUNNING_FOLIA) {
            Util.logLoading("&5World Creator Elements &cdisabled &7(&eCurrently not supported on Folia&7)", new Object[0]);
            return;
        }
        try {
            this.plugin.beeWorldConfig = new BeeWorldConfig(this.plugin);
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.worldcreator", new String[0]);
            Util.logLoading("&5World Creator Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("World Creator", ex);
        }
    }

    private void loadChunkGenElements() {
        if (!this.config.ELEMENTS_CHUNK_GEN) {
            Util.logLoading("&5Chunk Generator Elements &cdisabled via config", new Object[0]);
            return;
        }
        if (!this.config.ELEMENTS_WORLD_CREATOR) {
            Util.logLoading("&5Chunk Generator &cdisabled via World Creator config", new Object[0]);
            return;
        }
        if (Util.IS_RUNNING_FOLIA) {
            Util.logLoading("&5Chunk Generator Elements &cdisabled &7(&eCurrently not supported on Folia&7)", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.generator", new String[0]);
            Util.logLoading("&5Chunk Generator Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("Chunk Generator", ex);
        }
    }

    private void loadGameEventElements() {
        if (!this.config.ELEMENTS_GAME_EVENT) {
            Util.logLoading("&5Game Event Elements &cdisabled via config", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.gameevent", new String[0]);
            Util.logLoading("&5Game Event Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("Game Event", ex);
        }
    }

    private void loadBossBarElements() {
        if (!this.config.ELEMENTS_BOSS_BAR) {
            Util.logLoading("&5BossBar Elements &cdisabled via config", new Object[0]);
            return;
        }
        if (Classes.getClassInfoNoError((String)"bossbar") != null || Classes.getExactClassInfo(BossBar.class) != null) {
            Util.logLoading("&5BossBar Elements &cdisabled", new Object[0]);
            Util.logLoading("&7It appears another Skript addon may have registered BossBar syntax.", new Object[0]);
            Util.logLoading("&7To use SkBee BossBars, please remove the addon which has registered BossBars already.", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.bossbar", new String[0]);
            Util.logLoading("&5BossBar Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("BossBar", ex);
        }
    }

    private void loadStatisticElements() {
        if (!this.config.ELEMENTS_STATISTIC) {
            Util.logLoading("&5Statistic Elements &cdisabled via config", new Object[0]);
            return;
        }
        if (Classes.getClassInfoNoError((String)"statistic") != null || Classes.getExactClassInfo(Statistic.class) != null) {
            Util.logLoading("&5Statistic Elements &cdisabled", new Object[0]);
            Util.logLoading("&7It appears another Skript addon may have registered Statistic syntax.", new Object[0]);
            Util.logLoading("&7To use SkBee Statistics, please remove the addon which has registered Statistic already.", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.statistic", new String[0]);
            Util.logLoading("&5Statistic Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("Statistic", ex);
        }
    }

    private void loadVillagerElements() {
        if (!this.config.ELEMENTS_VILLAGER) {
            Util.logLoading("&5Villager Elements &cdisabled via config", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.villager", new String[0]);
            Util.logLoading("&5Villager Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("Villager", ex);
        }
    }

    private void loadAdvancementElements() {
        if (!this.config.ELEMENTS_ADVANCEMENT) {
            Util.logLoading("&5Advancement Elements &cdisabled via config", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.advancement", new String[0]);
            Util.logLoading("&5Advancement Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("Advancement", ex);
        }
    }

    private void loadWorldBorderElements() {
        if (!this.config.ELEMENTS_WORLD_BORDER) {
            Util.logLoading("&5World Border Elements &cdisabled via config", new Object[0]);
            return;
        }
        if (Util.IS_RUNNING_SKRIPT_2_11) {
            Util.logLoading("&5World Border Elements &cdisabled &7(&enow in Skript&7)", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.worldborder", new String[0]);
            Util.logLoading("&5World Border Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("World Border", ex);
        }
    }

    private void loadParticleElements() {
        if (!this.config.ELEMENTS_PARTICLE) {
            Util.logLoading("&5Particle Elements &cdisabled via config", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.particle", new String[0]);
            Util.logLoading("&5Particle Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("Particle", ex);
        }
    }

    private void loadRayTraceElements() {
        if (!this.config.ELEMENTS_RAYTRACE) {
            Util.logLoading("&5RayTrace Elements &cdisabled via config", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.raytrace", new String[0]);
            Util.logLoading("&5RayTrace Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("RayTrace", ex);
        }
    }

    private void loadFishingElements() {
        if (!this.config.ELEMENTS_FISHING) {
            Util.logLoading("&5Fishing Elements &cdisabled via config", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.fishing", new String[0]);
            Util.logLoading("&5Fishing Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("Fishing", ex);
        }
    }

    private void loadDisplayEntityElements() {
        if (!this.config.ELEMENTS_DISPLAY) {
            Util.logLoading("&5Display Entity Elements &cdisabled via config", new Object[0]);
            return;
        }
        if (!Skript.classExists((String)"org.bukkit.entity.TextDisplay$TextAlignment")) {
            Util.logLoading("&5Display Entity Elements &cdisabled due to a Bukkit API change!", new Object[0]);
            Util.logLoading("&7- &eYou need to update your server to fix this issue!", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.display", new String[0]);
            Util.logLoading("&5Display Entity Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("Display Entity", ex);
        }
    }

    private void loadDamageSourceElements() {
        if (!this.config.ELEMENTS_DAMAGE_SOURCE) {
            Util.logLoading("&5Damage Source Elements &cdisabled via config", new Object[0]);
            return;
        }
        if (!Skript.classExists((String)"org.bukkit.damage.DamageSource")) {
            Util.logLoading("&5Damage Source Elements &cdisabled &7(&eRequires Minecraft 1.20.4+&7)", new Object[0]);
            return;
        }
        if (Util.IS_RUNNING_SKRIPT_2_12) {
            Util.logLoading("&5Damage Source Elements &cdisabled &7(&enow in Skript&7)", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.damagesource", new String[0]);
            Util.logLoading("&5Damage Source Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("Damage Source", ex);
        }
    }

    private void loadItemComponentElements() {
        if (!this.config.ELEMENTS_ITEM_COMPONENT) {
            Util.logLoading("&5Item Component Elements &cdisabled via config", new Object[0]);
            return;
        }
        if (!Skript.classExists((String)"io.papermc.paper.datacomponent.DataComponentTypes")) {
            Util.logLoading("&5Item Component Elements &cdisabled &7(&eRequires Paper 1.21.3+&7)", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.itemcomponent", new String[0]);
            Util.logLoading("&5Item Component Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("Item Component", ex);
        }
    }

    private void loadTestingElements() {
        if (!TestMode.ENABLED) {
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.testing", new String[0]);
            Util.logLoading("&5Testing Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("Testing", ex);
        }
    }

    private void loadRegistryElements() {
        if (!Skript.classExists((String)"io.papermc.paper.registry.tag.TagKey") || !Skript.classExists((String)"io.papermc.paper.registry.RegistryKey")) {
            Util.logLoading("&5Registry Elements &cdisabled &7(&eRequires Paper 1.21+&7)", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.registry", new String[0]);
            Util.logLoading("&5Registry Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("Registry", ex);
        }
    }

    private void loadSwitchCaseElements() {
        if (!this.config.ELEMENTS_SWITCH_CASE) {
            Util.logLoading("&5SwitchCase Elements &cdisabled via config", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.switchcase", new String[0]);
            Util.logLoading("&5SwitchCase Elements &asuccessfully loaded", new Object[0]);
        }
        catch (Exception ex) {
            this.logFailure("SwitchCase", ex);
        }
    }

    private void loadPropertyElements() {
        if (!this.config.ELEMENTS_PROPERTY) {
            Util.logLoading("&5Property elements &cdisabled via config", new Object[0]);
            return;
        }
        try {
            this.addon.loadClasses("com.shanebeestudios.skbee.elements.property", new String[0]);
            Util.logLoading("&5Property Elements &asuccessfully loaded", new Object[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void logFailure(String element, Exception ex) {
        Skript.exception((Throwable)ex, (String[])new String[0]);
        Util.logLoading("&e%s Elements &7failed to load due to &r'&c%s&r'", element, ex.getCause().getMessage());
    }

    public boolean isTextComponentEnabled() {
        return this.textComponentEnabled;
    }

    private boolean isPlugmanReloaded() {
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            if (!stackTraceElement.toString().contains("rylinaux.plugman.command.")) continue;
            return true;
        }
        return false;
    }
}

