/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee;

import ch.njol.skript.Skript;
import ch.njol.skript.test.runner.TestMode;
import com.shanebeestudios.skbee.AddonLoader;
import com.shanebeestudios.skbee.api.bound.Bound;
import com.shanebeestudios.skbee.api.bound.BoundConfig;
import com.shanebeestudios.skbee.api.command.SkBeeInfo;
import com.shanebeestudios.skbee.api.region.TaskUtils;
import com.shanebeestudios.skbee.api.structure.StructureManager;
import com.shanebeestudios.skbee.api.util.Util;
import com.shanebeestudios.skbee.api.util.update.UpdateChecker;
import com.shanebeestudios.skbee.api.virtualfurnace.api.VirtualFurnaceAPI;
import com.shanebeestudios.skbee.api.wrapper.LazyLocation;
import com.shanebeestudios.skbee.config.Config;
import com.shanebeestudios.skbee.elements.worldcreator.objects.BeeWorldConfig;
import com.shanebeestudios.skbee.metrics.bukkit.Metrics;
import com.shanebeestudios.skbee.metrics.charts.SimplePie;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SkBee
extends JavaPlugin {
    static final int[] EARLIEST_VERSION;
    private static SkBee instance;
    private boolean properlyEnabled = true;
    private Config config;
    BoundConfig boundConfig = null;
    VirtualFurnaceAPI virtualFurnaceAPI;
    BeeWorldConfig beeWorldConfig;
    StructureManager structureManager = null;
    private AddonLoader addonLoader = null;

    public void onEnable() {
        long start = System.currentTimeMillis();
        instance = this;
        this.config = new Config(this);
        TaskUtils.initialize((Plugin)this, Util.IS_RUNNING_FOLIA || this.config.settings_use_paper_schedulers);
        this.addonLoader = new AddonLoader(this);
        this.properlyEnabled = this.addonLoader.canLoadPlugin();
        this.loadCommands();
        this.loadMetrics();
        String version = this.getDescription().getVersion();
        if (version.contains("-")) {
            Util.log("&eThis is a BETA build, things may not work as expected, please report any bugs on GitHub", new Object[0]);
            Util.log("&ehttps://github.com/ShaneBeee/SkBee/issues", new Object[0]);
        }
        new UpdateChecker(this);
        Util.log("&aSuccessfully enabled v%s&7 in &b%.2f seconds", version, Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f));
        if (this.properlyEnabled && this.beeWorldConfig != null) {
            this.beeWorldConfig.loadCustomWorlds();
        }
    }

    private void loadCommands() {
        this.getCommand("skbee").setExecutor((CommandExecutor)new SkBeeInfo(this));
    }

    private void loadMetrics() {
        Metrics metrics = new Metrics((Plugin)this, 6719);
        metrics.addCustomChart(new SimplePie("skript_version", () -> Skript.getVersion().toString()));
        metrics.addCustomChart(new SimplePie("virtual_furnace", () -> String.valueOf(this.config.ELEMENTS_VIRTUAL_FURNACE)));
    }

    public void onDisable() {
        if (this.properlyEnabled) {
            TaskUtils.cancelTasks();
        }
        if (this.virtualFurnaceAPI != null) {
            this.virtualFurnaceAPI.disableAPI();
        }
        if (!TestMode.ENABLED && this.boundConfig != null) {
            this.boundConfig.saveAllBoundsOnShutdown();
        }
        Util.clearDebugs();
    }

    public static SkBee getPlugin() {
        return instance;
    }

    public Config getPluginConfig() {
        return this.config;
    }

    public BoundConfig getBoundConfig() {
        return this.boundConfig;
    }

    public BeeWorldConfig getBeeWorldConfig() {
        return this.beeWorldConfig;
    }

    public VirtualFurnaceAPI getVirtualFurnaceAPI() {
        return this.virtualFurnaceAPI;
    }

    public StructureManager getStructureManager() {
        return this.structureManager;
    }

    public AddonLoader getAddonLoader() {
        return this.addonLoader;
    }

    public static boolean isDebug() {
        Config config = SkBee.instance.config;
        if (config != null) {
            return config.settings_debug;
        }
        return false;
    }

    static {
        ConfigurationSerialization.registerClass(Bound.class, (String)"Bound");
        ConfigurationSerialization.registerClass(LazyLocation.class, (String)"LazyLocation");
        EARLIEST_VERSION = new int[]{1, 18, 2};
    }
}

