/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.fastboard;

import com.shanebeestudios.skbee.api.fastboard.FastBoardBase;
import com.shanebeestudios.skbee.api.fastboard.base.adventure.FastBoard;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class FastBoardAdventure
extends FastBoardBase<ComponentWrapper, Component> {
    public FastBoardAdventure(Player player) {
        super(player, new FastBoard(player));
        this.title = ComponentWrapper.empty();
        this.lines = new ComponentWrapper[15];
        this.formats = new ComponentWrapper[15];
    }

    @Override
    public void setTitle(Object title) {
        ComponentWrapper titleComp;
        if (title instanceof ComponentWrapper) {
            ComponentWrapper cw;
            titleComp = cw = (ComponentWrapper)title;
        } else if (title instanceof String) {
            String s = (String)title;
            titleComp = ComponentWrapper.fromText(s);
        } else {
            return;
        }
        if (((ComponentWrapper)this.title).equals(titleComp)) {
            return;
        }
        this.title = titleComp;
        if (!this.visible) {
            return;
        }
        if (this.fastBoard == null) {
            return;
        }
        this.fastBoard.updateTitle(titleComp.getComponent());
    }

    @Override
    public void setLine(int lineNumber, Object line, @Nullable Object lineFormat) {
        ComponentWrapper lineComp;
        if (lineNumber > 15 || lineNumber < 1) {
            return;
        }
        if (line instanceof ComponentWrapper) {
            ComponentWrapper cw;
            lineComp = cw = (ComponentWrapper)line;
        } else if (line instanceof String) {
            String s = (String)line;
            lineComp = ComponentWrapper.fromText(s);
        } else {
            lineComp = null;
        }
        ComponentWrapper formatComp = null;
        if (lineFormat instanceof ComponentWrapper) {
            ComponentWrapper cw;
            formatComp = cw = (ComponentWrapper)lineFormat;
        } else if (lineFormat instanceof String) {
            String s = (String)lineFormat;
            formatComp = ComponentWrapper.fromText(s);
        }
        ComponentWrapper previousLine = ((ComponentWrapper[])this.lines)[REVERSE ? 15 - lineNumber : lineNumber - 1];
        ComponentWrapper previousScore = ((ComponentWrapper[])this.formats)[REVERSE ? 15 - lineNumber : lineNumber - 1];
        if (previousLine != null && previousLine.equals(lineComp)) {
            if (previousScore == null && formatComp == null) {
                return;
            }
            if (previousScore != null && previousScore.equals(formatComp)) {
                return;
            }
        }
        ((ComponentWrapper[])this.lines)[FastBoardAdventure.REVERSE ? 15 - lineNumber : lineNumber - 1] = lineComp;
        ((ComponentWrapper[])this.formats)[FastBoardAdventure.REVERSE ? 15 - lineNumber : lineNumber - 1] = formatComp;
        if (!this.visible) {
            return;
        }
        this.updateLines();
    }

    @Override
    public void clear() {
        this.title = ComponentWrapper.empty();
        this.lines = new ComponentWrapper[15];
        this.formats = new ComponentWrapper[15];
        if (this.fastBoard == null) {
            return;
        }
        this.fastBoard.updateTitle(((ComponentWrapper)this.title).getComponent());
        this.fastBoard.updateLines(new Component[0]);
    }

    @Override
    public void show() {
        if (this.visible) {
            return;
        }
        this.fastBoard = new FastBoard(this.player);
        this.fastBoard.updateTitle(((ComponentWrapper)this.title).getComponent());
        this.visible = true;
        this.updateLines();
    }

    @Override
    protected void updateLines() {
        ArrayList<Component> lines = new ArrayList<Component>();
        ArrayList<TextComponent> formats = new ArrayList<TextComponent>();
        for (int i = 0; i < 15; ++i) {
            if (((ComponentWrapper[])this.lines)[i] == null) continue;
            lines.add(((ComponentWrapper[])this.lines)[i].getComponent());
            formats.add((TextComponent)(((ComponentWrapper[])this.formats)[i] != null ? ((ComponentWrapper[])this.formats)[i].getComponent() : Component.empty()));
        }
        if (this.fastBoard == null) {
            return;
        }
        this.fastBoard.updateLines(lines, formats);
    }
}

