/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.fastboard;

import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FastBoardBase<T, B> {
    protected static boolean REVERSE;
    private static Scoreboard DUMMY_BOARD;
    protected final Player player;
    protected com.shanebeestudios.skbee.api.fastboard.base.FastBoardBase<B> fastBoard;
    protected boolean visible = true;
    protected T title;
    protected T[] lines;
    protected T[] formats;

    public static void init(SkBee plugin) {
        REVERSE = plugin.getPluginConfig().SETTINGS_FASTBOARD_LINES;
        DUMMY_BOARD = Util.IS_RUNNING_FOLIA ? null : Bukkit.getScoreboardManager().getNewScoreboard();
    }

    public FastBoardBase(Player player, com.shanebeestudios.skbee.api.fastboard.base.FastBoardBase<B> fastBoard) {
        this.player = player;
        this.fastBoard = fastBoard;
    }

    public abstract void setTitle(Object var1);

    @NotNull
    public T getTitle() {
        return this.title;
    }

    public abstract void setLine(int var1, Object var2, @Nullable Object var3);

    @Nullable
    public T getLine(int lineNumber) {
        if (lineNumber > 15 || lineNumber < 1) {
            return null;
        }
        return this.lines[REVERSE ? 15 - lineNumber : lineNumber - 1];
    }

    public void deleteLine(int line) {
        this.setLine(line, null, null);
    }

    public abstract void clear();

    public void hide() {
        this.visible = false;
        if (this.fastBoard == null) {
            return;
        }
        this.fastBoard.delete();
        this.fastBoard = null;
        if (DUMMY_BOARD != null) {
            Scoreboard previous = this.player.getScoreboard();
            this.player.setScoreboard(DUMMY_BOARD);
            this.player.setScoreboard(previous);
        }
    }

    public abstract void show();

    public void toggle() {
        if (this.visible) {
            this.hide();
        } else {
            this.show();
        }
    }

    public boolean isOn() {
        return this.visible;
    }

    public void deleteFastboard() {
        if (this.fastBoard == null) {
            return;
        }
        this.fastBoard.delete();
    }

    protected abstract void updateLines();
}

