/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.listener;

import ch.njol.skript.Skript;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.bound.Bound;
import com.shanebeestudios.skbee.api.bound.BoundConfig;
import com.shanebeestudios.skbee.api.event.bound.BoundEnterEvent;
import com.shanebeestudios.skbee.api.event.bound.BoundExitEvent;
import com.shanebeestudios.skbee.api.region.TaskUtils;
import com.shanebeestudios.skbee.config.Config;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;

public class BoundBorderListener
implements Listener {
    private final BoundConfig boundConfig;
    private static final boolean HAS_MOUNT_EVENT = Skript.classExists((String)"org.bukkit.event.entity.EntityMountEvent");
    private static final boolean HAS_DISMOUNT_EVENT = Skript.classExists((String)"org.bukkit.event.entity.EntityDismountEvent");

    public BoundBorderListener(SkBee plugin) {
        Config config = plugin.getPluginConfig();
        this.boundConfig = plugin.getBoundConfig();
        this.setupListeners(plugin, config);
    }

    private void setupListeners(SkBee plugin, Config config) {
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (config.BOUND_EVENTS_PLAYER_MOVE) {
            pluginManager.registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                private void onBoundBorder(PlayerMoveEvent event) {
                    Location to;
                    Location from;
                    Player player = event.getPlayer();
                    if (BoundBorderListener.this.preventBoundMovement(player, from = event.getFrom(), to = event.getTo())) {
                        event.setCancelled(true);
                        Entity vehicle = player.getVehicle();
                        if (vehicle != null) {
                            vehicle.removePassenger((Entity)player);
                            vehicle.teleport(from);
                        }
                    }
                }
            }, (Plugin)plugin);
        }
        if (config.BOUND_EVENTS_PLAYER_TELEPORT) {
            pluginManager.registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                private void onPlayerTeleport(PlayerTeleportEvent event) {
                    Location to;
                    Location from;
                    Player player = event.getPlayer();
                    if (BoundBorderListener.this.preventBoundMovement(player, from = event.getFrom(), to = event.getTo(), false)) {
                        event.setCancelled(true);
                    }
                }
            }, (Plugin)plugin);
        }
        if (config.BOUND_EVENTS_PLAYER_RESPAWN) {
            pluginManager.registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                private void onRespawn(PlayerRespawnEvent event) {
                    Location to;
                    Location from;
                    Player player = event.getPlayer();
                    if (BoundBorderListener.this.preventBoundMovement(player, from = player.getLocation(), to = event.getRespawnLocation())) {
                        event.setRespawnLocation(((World)Bukkit.getWorlds().getFirst()).getSpawnLocation());
                        if (event.isBedSpawn() || event.isAnchorSpawn()) {
                            player.setBedSpawnLocation(null);
                        }
                    }
                }
            }, (Plugin)plugin);
        }
        if (config.BOUND_EVENTS_PLAYER_BED_ENTER) {
            pluginManager.registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                private void onEnterBed(PlayerBedEnterEvent event) {
                    Location to;
                    Location from;
                    Player player = event.getPlayer();
                    if (BoundBorderListener.this.preventBoundMovement(player, from = player.getLocation(), to = event.getBed().getLocation())) {
                        event.setCancelled(true);
                    }
                }
            }, (Plugin)plugin);
        }
        if (config.BOUND_EVENTS_PLAYER_BED_LEAVE) {
            pluginManager.registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                private void onExitBed(PlayerBedLeaveEvent event) {
                    Player player = event.getPlayer();
                    Location from = event.getBed().getLocation();
                    TaskUtils.getEntityScheduler((Entity)player).runTaskLater(() -> {
                        Location to = player.getLocation();
                        if (BoundBorderListener.this.preventBoundMovement(player, from, to)) {
                            player.teleport(from.clone().add(0.0, 1.0, 0.0));
                        }
                    }, 1L);
                }
            }, (Plugin)plugin);
        }
        if (config.BOUND_EVENTS_ENTITY_MOUNT && HAS_MOUNT_EVENT) {
            pluginManager.registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                private void onMount(EntityMountEvent event) {
                    Location to;
                    Location from;
                    Player player;
                    Entity entity = event.getEntity();
                    if (entity instanceof Player && BoundBorderListener.this.preventBoundMovement(player = (Player)entity, from = player.getLocation(), to = event.getMount().getLocation())) {
                        event.setCancelled(true);
                    }
                }
            }, (Plugin)plugin);
        }
        if (config.BOUND_EVENTS_ENTITY_DISMOUNT && HAS_DISMOUNT_EVENT) {
            pluginManager.registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                private void onDismount(EntityDismountEvent event) {
                    Entity entity = event.getEntity();
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        Location from = event.getDismounted().getLocation().clone();
                        TaskUtils.getEntityScheduler((Entity)player).runTaskLater(() -> {
                            Location to = player.getLocation();
                            if (BoundBorderListener.this.preventBoundMovement(player, from, to)) {
                                from.setYaw(player.getLocation().getYaw());
                                from.setPitch(player.getLocation().getPitch());
                                player.teleport(from);
                            }
                        }, 1L);
                    }
                }
            }, (Plugin)plugin);
        }
        if (config.BOUND_EVENTS_VEHICLE_ENTER) {
            pluginManager.registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                private void onVehicleEnter(VehicleEnterEvent event) {
                    Location to;
                    Location from;
                    Player player;
                    Entity entity = event.getEntered();
                    if (entity instanceof Player && BoundBorderListener.this.preventBoundMovement(player = (Player)entity, from = player.getLocation(), to = event.getVehicle().getLocation())) {
                        event.setCancelled(true);
                    }
                }
            }, (Plugin)plugin);
        }
        if (config.BOUND_EVENTS_VEHICLE_EXIT) {
            pluginManager.registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                private void onVehicleExit(VehicleExitEvent event) {
                    Location from = event.getVehicle().getLocation().clone();
                    LivingEntity livingEntity = event.getExited();
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        TaskUtils.getEntityScheduler((Entity)player).runTaskLater(() -> {
                            Location to = player.getLocation();
                            if (BoundBorderListener.this.preventBoundMovement(player, from, to)) {
                                from.setYaw(player.getLocation().getYaw());
                                from.setPitch(player.getLocation().getPitch());
                                player.teleport(from);
                            }
                        }, 1L);
                    }
                }
            }, (Plugin)plugin);
        }
        if (config.BOUND_EVENTS_VEHICLE_MOVE) {
            pluginManager.registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                private void onVehicleMove(VehicleMoveEvent event) {
                    Vehicle vehicle = event.getVehicle();
                    vehicle.getPassengers().forEach(entity -> {
                        Location to;
                        Location from;
                        Player player;
                        if (entity instanceof Player && BoundBorderListener.this.preventBoundMovement(player = (Player)entity, from = event.getFrom().clone(), to = event.getTo())) {
                            vehicle.removePassenger((Entity)player);
                            from.setYaw(player.getLocation().getYaw());
                            from.setPitch(player.getLocation().getPitch());
                            player.teleport(from);
                        }
                    });
                }
            }, (Plugin)plugin);
        }
        if (config.BOUND_EVENTS_VEHICLE_DESTROY) {
            pluginManager.registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                private void onVehicleDestroy(VehicleDestroyEvent event) {
                    Vehicle vehicle = event.getVehicle();
                    Location from = vehicle.getLocation().clone();
                    TaskUtils.getEntityScheduler((Entity)vehicle).runTaskLater(() -> {
                        for (Entity passenger : vehicle.getPassengers()) {
                            Player player;
                            Location to = passenger.getLocation();
                            if (!(passenger instanceof Player) || !BoundBorderListener.this.preventBoundMovement(player = (Player)passenger, from, to)) continue;
                            from.setYaw(player.getLocation().getYaw());
                            from.setPitch(player.getLocation().getPitch());
                            player.teleport(from);
                        }
                    }, 1L);
                }
            }, (Plugin)plugin);
        }
    }

    private boolean preventBoundMovement(@NotNull Player player, @NotNull Location from, @NotNull Location to) {
        return this.preventBoundMovement(player, from, to, true);
    }

    private boolean preventBoundMovement(@NotNull Player player, @NotNull Location from, @NotNull Location to, boolean ignoreWorldChange) {
        from = from.clone();
        from.setPitch(to.getPitch());
        from.setYaw(to.getYaw());
        if (to.equals((Object)from)) {
            return false;
        }
        if (ignoreWorldChange && !to.getWorld().equals((Object)from.getWorld())) {
            return false;
        }
        for (Bound bound : this.boundConfig.getBoundsInRegion(from)) {
            if (bound.isInRegion(to) || !bound.isInRegion(from)) continue;
            BoundExitEvent exitEvent = new BoundExitEvent(bound, player);
            Bukkit.getPluginManager().callEvent((Event)exitEvent);
            if (!exitEvent.isCancelled()) continue;
            return true;
        }
        for (Bound bound : this.boundConfig.getBoundsInRegion(to)) {
            if (!bound.isInRegion(to) || bound.isInRegion(from)) continue;
            BoundEnterEvent enterEvent = new BoundEnterEvent(bound, player);
            Bukkit.getPluginManager().callEvent((Event)enterEvent);
            if (!enterEvent.isCancelled()) continue;
            return true;
        }
        return false;
    }
}

