/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.listener;

import ch.njol.skript.config.Config;
import ch.njol.skript.events.bukkit.PreScriptLoadEvent;
import com.google.common.io.Files;
import com.shanebeestudios.skbee.api.util.Util;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.text.StringEscapeUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;

public class ScriptListener
implements Listener {
    private final List<String> DISABLED_SCRIPTS = new ArrayList<String>();
    private static final List<String> CHECK_STRINGS = new ArrayList<String>();

    @EventHandler
    private void onCommand(ServerCommandEvent event) {
        this.processCommand((Cancellable)event, event.getSender(), event.getCommand());
    }

    @EventHandler
    private void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        this.processCommand((Cancellable)event, (CommandSender)event.getPlayer(), event.getMessage());
    }

    private void processCommand(Cancellable event, CommandSender sender, String command) {
        if (!((command = command.toLowerCase(Locale.ROOT)).contains(" reload") || command.contains(" enable") || command.contains(" disable"))) {
            return;
        }
        for (String disabled_script : this.DISABLED_SCRIPTS) {
            if (!command.contains(disabled_script.toLowerCase())) continue;
            event.setCancelled(true);
            Util.sendColMsg(sender, "&cScript &7'&b%s&7' &chas been disabled by SkBee!", disabled_script);
        }
    }

    @EventHandler
    private void onLoadScript(PreScriptLoadEvent event) {
        ArrayList scriptsToRemove = new ArrayList();
        for (Config script : event.getScripts()) {
            String content;
            File scriptFile = script.getFile();
            assert (scriptFile != null);
            try {
                content = String.join((CharSequence)"\n", Files.readLines((File)scriptFile, (Charset)Charset.defaultCharset())).toLowerCase(Locale.ROOT);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            CHECK_STRINGS.forEach(string -> {
                if (content.contains(StringEscapeUtils.unescapeJava((String)string).toLowerCase(Locale.ROOT))) {
                    scriptsToRemove.add(script);
                    String scriptName = scriptFile.getName().replace(".sk", "");
                    this.DISABLED_SCRIPTS.add(scriptName);
                }
            });
        }
        for (Config config : scriptsToRemove) {
            event.getScripts().remove(config);
        }
    }
}

