/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.nbt;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.registrations.Classes;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.nbt.NBT;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.nbt.NBTCompoundList;
import com.shanebeestudios.skbee.api.nbt.NBTContainer;
import com.shanebeestudios.skbee.api.nbt.NBTCustom;
import com.shanebeestudios.skbee.api.nbt.NBTCustomBlock;
import com.shanebeestudios.skbee.api.nbt.NBTCustomEntity;
import com.shanebeestudios.skbee.api.nbt.NBTCustomItemStack;
import com.shanebeestudios.skbee.api.nbt.NBTCustomOfflinePlayer;
import com.shanebeestudios.skbee.api.nbt.NBTCustomTileEntity;
import com.shanebeestudios.skbee.api.nbt.NBTCustomType;
import com.shanebeestudios.skbee.api.nbt.NBTFile;
import com.shanebeestudios.skbee.api.nbt.NBTItem;
import com.shanebeestudios.skbee.api.nbt.NBTList;
import com.shanebeestudios.skbee.api.nbt.NBTType;
import com.shanebeestudios.skbee.api.nbt.NbtApiException;
import com.shanebeestudios.skbee.api.nbt.iface.ReadWriteNBT;
import com.shanebeestudios.skbee.api.nbt.iface.ReadWriteNBTList;
import com.shanebeestudios.skbee.api.nbt.utils.MinecraftVersion;
import com.shanebeestudios.skbee.api.util.Pair;
import com.shanebeestudios.skbee.api.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NBTApi {
    private static boolean ENABLED;

    public static void initializeAPI() {
        Util.log("&aLoading NBTApi...", new Object[0]);
        MinecraftVersion version = MinecraftVersion.getVersion();
        if (version == MinecraftVersion.UNKNOWN) {
            Util.log("&cFailed to load NBTApi!", new Object[0]);
            ENABLED = false;
        } else {
            Util.log("&aSuccessfully loaded NBTApi!", new Object[0]);
            new NBTContainer("{a:1}").toString();
            ENABLED = true;
        }
    }

    public static boolean isEnabled() {
        return ENABLED;
    }

    @Nullable
    public static NBTCompound validateNBT(String nbtString) {
        if (nbtString == null) {
            return null;
        }
        NBTCompound compound = (NBTCompound)NBT.createNBTObject();
        try {
            compound.mergeCompound(NBT.parseNBT(nbtString));
        }
        catch (Exception ex) {
            Util.skriptError("&cInvalid NBT: &7'&b%s&7'&c", nbtString);
            if (SkBee.isDebug()) {
                ex.printStackTrace();
            } else {
                String cause = ex.getCause().getCause().getCause().toString();
                cause = cause.replace("com.mojang.brigadier.exceptions.CommandSyntaxException", "MalformedNBT");
                Util.skriptError("&cMessage: &e%s", cause);
            }
            Util.errorForAdmins("Invalid NBT, please check console for more details.", new Object[0]);
            return null;
        }
        return compound;
    }

    @Nullable
    public static Pair<String, NBTCompound> getNestedCompound(String tag, NBTCompound compound, boolean requiresNested) {
        if (compound == null || tag == null) {
            return null;
        }
        if (tag.contains(";")) {
            String subTag = tag.substring(0, tag.lastIndexOf(";")).replace(".", "\\.").replace(";", ".");
            compound = requiresNested ? (NBTCompound)compound.resolveCompound(subTag) : (NBTCompound)compound.resolveOrCreateCompound(subTag);
            tag = NBTApi.getNestedTag(tag);
        }
        if (compound == null || tag == null) {
            return null;
        }
        return new Pair<String, NBTCompound>(tag, compound);
    }

    public static String getNestedTag(String tag) {
        if (tag.contains(";")) {
            String[] splits = tag.split(";(?=(([^\"]*\"){2})*[^\"]*$)");
            return splits[splits.length - 1];
        }
        return tag;
    }

    public static boolean hasTag(NBTCompound compound, String tag) {
        if (!tag.contains(";")) {
            return compound.hasTag(tag);
        }
        Pair<String, NBTCompound> nestedCompound = NBTApi.getNestedCompound(tag, compound, true);
        if (nestedCompound != null) {
            return nestedCompound.second().hasTag(nestedCompound.first());
        }
        return false;
    }

    @Nullable
    public static NBTCustomType getTagType(NBTCompound compound, String tag) {
        Pair<String, NBTCompound> nestedCompound = NBTApi.getNestedCompound(tag, compound, true);
        if (nestedCompound != null) {
            tag = nestedCompound.first();
            compound = nestedCompound.second();
            return NBTCustomType.getByTag(compound, tag);
        }
        return null;
    }

    @Nullable
    public static NBTFile getNBTFile(String fileName) {
        fileName = !fileName.endsWith(".dat") && !fileName.endsWith(".nbt") ? fileName + ".nbt" : fileName;
        try {
            return new NBTFile(new File(fileName));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public static NBTCustomOfflinePlayer getNBTOfflinePlayer(OfflinePlayer offlinePlayer) {
        if (!offlinePlayer.hasPlayedBefore()) {
            return null;
        }
        try {
            return new NBTCustomOfflinePlayer(offlinePlayer);
        }
        catch (IOException ignore) {
            return null;
        }
    }

    public static boolean nbtFileExists(String fileName) {
        fileName = !fileName.endsWith(".dat") && !fileName.endsWith(".nbt") ? fileName + ".nbt" : fileName;
        File file = new File(fileName);
        return file.exists();
    }

    @Nullable
    public static ItemType getItemTypeWithNBT(ItemType itemType, NBTCompound nbtCompound, boolean custom) {
        NBTContainer itemNBT = NBTItem.convertItemtoNBT(itemType.getRandom());
        if (nbtCompound.hasTag("components")) {
            if (nbtCompound.hasTag("id") && !itemNBT.getString("id").equalsIgnoreCase(nbtCompound.getString("id"))) {
                return itemType;
            }
            itemNBT.mergeCompound(nbtCompound);
        } else {
            NBTCompound components = itemNBT.getOrCreateCompound("components");
            if (custom) {
                components = components.getOrCreateCompound("minecraft:custom_data");
            }
            components.mergeCompound(nbtCompound);
        }
        ItemStack newItemStack = NBTItem.convertNBTtoItem(itemNBT);
        if (newItemStack == null) {
            return null;
        }
        return new ItemType(newItemStack);
    }

    public static void deleteTag(@NotNull String tag, @NotNull NBTCompound compound) {
        Pair<String, NBTCompound> nestedCompound;
        if (tag.equalsIgnoreCase("custom") && compound instanceof NBTCustom) {
            NBTCustom nbtCustom = (NBTCustom)((Object)compound);
            if (!(compound instanceof NBTCustomItemStack)) {
                nbtCustom.deleteCustomNBT();
                return;
            }
        }
        if ((nestedCompound = NBTApi.getNestedCompound(tag, compound, true)) == null) {
            return;
        }
        tag = nestedCompound.first();
        compound = nestedCompound.second();
        compound.removeKey(tag);
    }

    public static void setTag(@NotNull String tag, @NotNull NBTCompound compound, @NotNull Object[] object, NBTCustomType type) {
        Pair<String, NBTCompound> nestedCompound = NBTApi.getNestedCompound(tag, compound, false);
        if (nestedCompound == null) {
            return;
        }
        compound = nestedCompound.second();
        tag = nestedCompound.first();
        Object singleObject = object[0];
        switch (type) {
            case NBTTagBoolean: {
                if (!(singleObject instanceof Boolean)) break;
                Boolean bool = (Boolean)singleObject;
                compound.setBoolean(tag, bool);
                break;
            }
            case NBTTagByte: {
                if (!(singleObject instanceof Number)) break;
                Number number = (Number)singleObject;
                compound.setByte(tag, number.byteValue());
                break;
            }
            case NBTTagShort: {
                if (!(singleObject instanceof Number)) break;
                Number number = (Number)singleObject;
                compound.setShort(tag, number.shortValue());
                break;
            }
            case NBTTagInt: {
                if (!(singleObject instanceof Number)) break;
                Number number = (Number)singleObject;
                compound.setInteger(tag, number.intValue());
                break;
            }
            case NBTTagLong: {
                if (!(singleObject instanceof Number)) break;
                Number number = (Number)singleObject;
                compound.setLong(tag, number.longValue());
                break;
            }
            case NBTTagFloat: {
                if (!(singleObject instanceof Number)) break;
                Number number = (Number)singleObject;
                compound.setFloat(tag, Float.valueOf(number.floatValue()));
                break;
            }
            case NBTTagDouble: {
                if (!(singleObject instanceof Number)) break;
                Number number = (Number)singleObject;
                compound.setDouble(tag, number.doubleValue());
                break;
            }
            case NBTTagByteArray: {
                if (!(singleObject instanceof Number)) break;
                byte[] ba = new byte[object.length];
                for (int i = 0; i < object.length; ++i) {
                    ba[i] = ((Number)object[i]).byteValue();
                }
                compound.setByteArray(tag, ba);
                break;
            }
            case NBTTagIntArray: {
                if (!(singleObject instanceof Number)) break;
                int[] ia = new int[object.length];
                for (int i = 0; i < object.length; ++i) {
                    ia[i] = ((Number)object[i]).intValue();
                }
                compound.setIntArray(tag, ia);
                break;
            }
            case NBTTagUUID: {
                UUID uuid = null;
                int[] ints = new int[]{};
                if (singleObject instanceof String) {
                    String string = (String)singleObject;
                    try {
                        uuid = UUID.fromString(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (singleObject instanceof UUID) {
                    UUID u;
                    uuid = u = (UUID)singleObject;
                } else if (singleObject instanceof Entity) {
                    Entity entity = (Entity)singleObject;
                    uuid = entity.getUniqueId();
                } else if (singleObject instanceof OfflinePlayer) {
                    OfflinePlayer offlinePlayer = (OfflinePlayer)singleObject;
                    uuid = offlinePlayer.getUniqueId();
                } else if (singleObject instanceof Number) {
                    ints = new int[object.length];
                    for (int i = 0; i < object.length; ++i) {
                        ints[i] = ((Number)object[i]).intValue();
                    }
                }
                if (uuid != null) {
                    compound.setUUID(tag, uuid);
                    break;
                }
                if (ints.length != 4) break;
                compound.setIntArray(tag, ints);
                break;
            }
            case NBTTagString: {
                if (singleObject instanceof String) {
                    String string = (String)singleObject;
                    compound.setString(tag, string);
                    break;
                }
                compound.setString(tag, Classes.toString((Object)singleObject));
                break;
            }
            case NBTTagCompound: {
                if (singleObject instanceof NBTCompound) {
                    NBTCompound nbt = (NBTCompound)singleObject;
                    NBTContainer copy = new NBTContainer();
                    copy.mergeCompound(nbt);
                    NBTCompound subCompound = compound.getOrCreateCompound(tag);
                    if (subCompound == null) {
                        return;
                    }
                    subCompound.clearNBT();
                    subCompound.mergeCompound(copy);
                }
            }
            case NBTTagIntList: {
                if (!(singleObject instanceof Number)) break;
                ReadWriteNBTList intList = compound.getIntegerList(tag);
                ((NBTList)intList).clear();
                for (Object o : object) {
                    if (!(o instanceof Number)) continue;
                    Number number = (Number)o;
                    ((NBTList)intList).add(number.intValue());
                }
                break;
            }
            case NBTTagLongList: {
                if (!(singleObject instanceof Number)) break;
                ReadWriteNBTList longList = compound.getLongList(tag);
                ((NBTList)longList).clear();
                for (Object o : object) {
                    if (!(o instanceof Number)) continue;
                    Number number = (Number)o;
                    ((NBTList)longList).add(number.longValue());
                }
                break;
            }
            case NBTTagFloatList: {
                if (!(singleObject instanceof Number)) break;
                ReadWriteNBTList floatList = compound.getFloatList(tag);
                ((NBTList)floatList).clear();
                for (Object o : object) {
                    if (!(o instanceof Number)) continue;
                    Number number = (Number)o;
                    ((NBTList)floatList).add(Float.valueOf(number.floatValue()));
                }
                break;
            }
            case NBTTagDoubleList: {
                if (!(singleObject instanceof Number)) break;
                ReadWriteNBTList doubleList = compound.getDoubleList(tag);
                ((NBTList)doubleList).clear();
                for (Object o : object) {
                    if (!(o instanceof Number)) continue;
                    Number number = (Number)o;
                    ((NBTList)doubleList).add(number.doubleValue());
                }
                break;
            }
            case NBTTagStringList: {
                if (!(singleObject instanceof String)) break;
                ReadWriteNBTList stringList = compound.getStringList(tag);
                ((NBTList)stringList).clear();
                for (Object o : object) {
                    if (!(o instanceof String)) continue;
                    String string = (String)o;
                    ((NBTList)stringList).add(string);
                }
                break;
            }
            case NBTTagCompoundList: {
                if (!(singleObject instanceof NBTCompound)) break;
                NBTCompoundList compoundList = compound.getCompoundList(tag);
                compoundList.clear();
                for (Object o : object) {
                    if (!(o instanceof NBTCompound)) continue;
                    NBTCompound comp = (NBTCompound)o;
                    compoundList.addCompound(comp);
                }
                break;
            }
        }
    }

    public static void addToTag(@NotNull String tag, @NotNull NBTCompound compound, @NotNull Object[] object, NBTCustomType type) {
        Pair<String, NBTCompound> nestedCompound = NBTApi.getNestedCompound(tag, compound, false);
        if (nestedCompound == null) {
            return;
        }
        tag = nestedCompound.first();
        compound = nestedCompound.second();
        NBTCustomType byTag = NBTCustomType.getByTag(compound, tag);
        if (byTag != NBTCustomType.NBTTagEnd && byTag != type) {
            return;
        }
        Object singleObject = object[0];
        switch (type) {
            case NBTTagByte: {
                if (!(singleObject instanceof Number)) break;
                Number number = (Number)singleObject;
                compound.setByte(tag, (byte)(compound.getByte(tag) + number.byteValue()));
                break;
            }
            case NBTTagShort: {
                if (!(singleObject instanceof Number)) break;
                Number number = (Number)singleObject;
                compound.setShort(tag, (short)(compound.getShort(tag) + number.shortValue()));
                break;
            }
            case NBTTagInt: {
                if (!(singleObject instanceof Number)) break;
                Number number = (Number)singleObject;
                compound.setInteger(tag, compound.getInteger(tag) + number.intValue());
                break;
            }
            case NBTTagLong: {
                if (!(singleObject instanceof Number)) break;
                Number number = (Number)singleObject;
                compound.setLong(tag, compound.getLong(tag) + number.longValue());
                break;
            }
            case NBTTagFloat: {
                if (!(singleObject instanceof Number)) break;
                Number number = (Number)singleObject;
                compound.setFloat(tag, Float.valueOf(compound.getFloat(tag).floatValue() + number.floatValue()));
                break;
            }
            case NBTTagDouble: {
                if (!(singleObject instanceof Number)) break;
                Number number = (Number)singleObject;
                compound.setDouble(tag, compound.getDouble(tag) + number.doubleValue());
                break;
            }
            case NBTTagByteArray: {
                if (!(singleObject instanceof Number)) break;
                byte[] byteArray = compound.getByteArray(tag);
                for (Object o : object) {
                    if (!(o instanceof Number)) continue;
                    Number number = (Number)o;
                    byteArray = ArrayUtils.add((byte[])byteArray, (byte)number.byteValue());
                }
                compound.setByteArray(tag, byteArray);
                break;
            }
            case NBTTagIntArray: {
                if (!(singleObject instanceof Number)) break;
                int[] intArray = compound.getIntArray(tag);
                for (Object o : object) {
                    if (!(o instanceof Number)) continue;
                    Number number = (Number)o;
                    intArray = ArrayUtils.add((int[])intArray, (int)number.intValue());
                }
                compound.setIntArray(tag, intArray);
                break;
            }
            case NBTTagIntList: {
                if (!(singleObject instanceof Number)) break;
                ReadWriteNBTList intList = compound.getIntegerList(tag);
                for (Object o : object) {
                    if (!(o instanceof Number)) continue;
                    Number number = (Number)o;
                    ((NBTList)intList).add(number.intValue());
                }
                break;
            }
            case NBTTagLongList: {
                if (!(singleObject instanceof Number)) break;
                ReadWriteNBTList longList = compound.getLongList(tag);
                for (Object o : object) {
                    if (!(o instanceof Number)) continue;
                    Number number = (Number)o;
                    ((NBTList)longList).add(number.longValue());
                }
                break;
            }
            case NBTTagFloatList: {
                if (!(singleObject instanceof Number)) break;
                ReadWriteNBTList floatList = compound.getFloatList(tag);
                for (Object o : object) {
                    if (!(o instanceof Number)) continue;
                    Number number = (Number)o;
                    ((NBTList)floatList).add(Float.valueOf(number.floatValue()));
                }
                break;
            }
            case NBTTagDoubleList: {
                if (!(singleObject instanceof Number)) break;
                ReadWriteNBTList doubleList = compound.getDoubleList(tag);
                for (Object o : object) {
                    if (!(o instanceof Number)) continue;
                    Number number = (Number)o;
                    ((NBTList)doubleList).add(number.doubleValue());
                }
                break;
            }
            case NBTTagStringList: {
                if (!(singleObject instanceof String)) break;
                ReadWriteNBTList stringList = compound.getStringList(tag);
                for (Object o : object) {
                    if (!(o instanceof String)) continue;
                    String string = (String)o;
                    ((NBTList)stringList).add(string);
                }
                break;
            }
            case NBTTagCompoundList: {
                if (!(singleObject instanceof NBTCompound)) break;
                NBTCompoundList compoundList = compound.getCompoundList(tag);
                for (Object o : object) {
                    if (!(o instanceof NBTCompound)) continue;
                    NBTCompound comp = (NBTCompound)o;
                    compoundList.addCompound(comp);
                }
                break;
            }
        }
    }

    public static void removeFromTag(@NotNull String tag, @NotNull NBTCompound compound, @NotNull Object[] object, NBTCustomType type) {
        Pair<String, NBTCompound> nestedCompound = NBTApi.getNestedCompound(tag, compound, false);
        if (nestedCompound == null) {
            return;
        }
        tag = nestedCompound.first();
        compound = nestedCompound.second();
        if (NBTCustomType.getByTag(compound, tag) != type) {
            return;
        }
        Object singleObject = object[0];
        switch (type) {
            case NBTTagByte: {
                if (!(singleObject instanceof Number)) break;
                Number number = (Number)singleObject;
                compound.setByte(tag, (byte)(compound.getByte(tag) - number.byteValue()));
                break;
            }
            case NBTTagShort: {
                if (!(singleObject instanceof Number)) break;
                Number number = (Number)singleObject;
                compound.setShort(tag, (short)(compound.getShort(tag) - number.shortValue()));
                break;
            }
            case NBTTagInt: {
                if (!(singleObject instanceof Number)) break;
                Number number = (Number)singleObject;
                compound.setInteger(tag, compound.getInteger(tag) - number.intValue());
                break;
            }
            case NBTTagLong: {
                if (!(singleObject instanceof Number)) break;
                Number number = (Number)singleObject;
                compound.setLong(tag, compound.getLong(tag) - number.longValue());
                break;
            }
            case NBTTagFloat: {
                if (!(singleObject instanceof Number)) break;
                Number number = (Number)singleObject;
                compound.setFloat(tag, Float.valueOf(compound.getFloat(tag).floatValue() - number.floatValue()));
                break;
            }
            case NBTTagDouble: {
                if (!(singleObject instanceof Number)) break;
                Number number = (Number)singleObject;
                compound.setDouble(tag, compound.getDouble(tag) - number.doubleValue());
                break;
            }
            case NBTTagByteArray: {
                if (!(singleObject instanceof Number)) break;
                byte[] byteArray = compound.getByteArray(tag);
                if (byteArray == null) {
                    return;
                }
                for (Object o : object) {
                    if (!(o instanceof Number)) continue;
                    Number number = (Number)o;
                    int index = ArrayUtils.indexOf((byte[])byteArray, (byte)number.byteValue());
                    byteArray = ArrayUtils.remove((byte[])byteArray, (int)index);
                }
                if (byteArray.length > 0) {
                    compound.setByteArray(tag, byteArray);
                    break;
                }
                compound.removeKey(tag);
                break;
            }
            case NBTTagIntArray: {
                if (!(singleObject instanceof Number)) break;
                int[] intArray = compound.getIntArray(tag);
                if (intArray == null) {
                    return;
                }
                for (Object o : object) {
                    if (!(o instanceof Number)) continue;
                    Number number = (Number)o;
                    int index = ArrayUtils.indexOf((int[])intArray, (int)number.intValue());
                    intArray = ArrayUtils.remove((int[])intArray, (int)index);
                }
                if (intArray.length > 0) {
                    compound.setIntArray(tag, intArray);
                    break;
                }
                compound.removeKey(tag);
                break;
            }
            case NBTTagIntList: {
                if (!(singleObject instanceof Number)) break;
                ReadWriteNBTList intList = compound.getIntegerList(tag);
                for (Object o : object) {
                    if (!(o instanceof Number)) continue;
                    Number number = (Number)o;
                    ((NBTList)intList).remove((Object)number.intValue());
                }
                if (!((NBTList)intList).isEmpty()) break;
                compound.removeKey(tag);
                break;
            }
            case NBTTagLongList: {
                if (!(singleObject instanceof Number)) break;
                ReadWriteNBTList longList = compound.getLongList(tag);
                for (Object o : object) {
                    if (!(o instanceof Number)) continue;
                    Number number = (Number)o;
                    ((NBTList)longList).remove(number.longValue());
                }
                if (!((NBTList)longList).isEmpty()) break;
                compound.removeKey(tag);
                break;
            }
            case NBTTagFloatList: {
                if (!(singleObject instanceof Number)) break;
                ReadWriteNBTList floatList = compound.getFloatList(tag);
                for (Object o : object) {
                    if (!(o instanceof Number)) continue;
                    Number number = (Number)o;
                    ((NBTList)floatList).remove(Float.valueOf(number.floatValue()));
                }
                if (!((NBTList)floatList).isEmpty()) break;
                compound.removeKey(tag);
                break;
            }
            case NBTTagDoubleList: {
                if (!(singleObject instanceof Number)) break;
                ReadWriteNBTList doubleList = compound.getDoubleList(tag);
                for (Object o : object) {
                    if (!(o instanceof Number)) continue;
                    Number number = (Number)o;
                    ((NBTList)doubleList).remove(number.doubleValue());
                }
                if (!((NBTList)doubleList).isEmpty()) break;
                compound.removeKey(tag);
                break;
            }
            case NBTTagStringList: {
                if (!(singleObject instanceof String)) break;
                ReadWriteNBTList stringList = compound.getStringList(tag);
                for (Object o : object) {
                    if (!(o instanceof String)) continue;
                    String string = (String)o;
                    ((NBTList)stringList).remove(string);
                }
                if (!((NBTList)stringList).isEmpty()) break;
                compound.removeKey(tag);
                break;
            }
        }
    }

    @Nullable
    private static Object resolveFromList(NBTCompound compound, String tag, NBTCustomType type) {
        Class<?> typeClass = type.getTypeClass();
        String tagWithoutBracket = tag.split("\\[")[0];
        if (!typeClass.isArray() && compound.hasTag(tagWithoutBracket)) {
            try {
                if (type == NBTCustomType.NBTTagCompound) {
                    return compound.resolveCompound(tag);
                }
                return compound.resolveOrNull(tag, typeClass);
            }
            catch (NbtApiException nbtApiException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static Object getTag(@NotNull String tag, @NotNull NBTCompound compound, @NotNull NBTCustomType type) {
        Pair<String, NBTCompound> nestedCompound = NBTApi.getNestedCompound(tag, compound, type != NBTCustomType.NBTTagCompound);
        if (nestedCompound == null) {
            return null;
        }
        tag = nestedCompound.first();
        compound = nestedCompound.second();
        if (tag.contains("[") && tag.contains("]")) {
            return NBTApi.resolveFromList(compound, tag, type);
        }
        if (!(type == NBTCustomType.NBTTagCompound || compound.hasTag(tag) && compound.getType(tag) == type.getNbtType())) {
            return null;
        }
        switch (type) {
            case NBTTagString: {
                return compound.getString(tag);
            }
            case NBTTagByteArray: {
                ArrayList<Byte> byteArray = new ArrayList<Byte>();
                for (byte i : compound.getByteArray(tag)) {
                    byteArray.add(i);
                }
                return byteArray;
            }
            case NBTTagIntArray: {
                ArrayList<Integer> intArray = new ArrayList<Integer>();
                for (int i : compound.getIntArray(tag)) {
                    intArray.add(i);
                }
                return intArray;
            }
            case NBTTagUUID: {
                try {
                    UUID uuid = compound.getUUID(tag);
                    if (uuid != null) {
                        if (Util.IS_RUNNING_SKRIPT_2_11) {
                            return uuid;
                        }
                        return uuid.toString();
                    }
                }
                catch (NbtApiException nbtApiException) {}
                break;
            }
            case NBTTagBoolean: {
                return compound.getBoolean(tag);
            }
            case NBTTagByte: {
                return compound.getByte(tag);
            }
            case NBTTagShort: {
                return compound.getShort(tag);
            }
            case NBTTagInt: {
                return compound.getInteger(tag);
            }
            case NBTTagLong: {
                return compound.getLong(tag);
            }
            case NBTTagFloat: {
                return compound.getFloat(tag);
            }
            case NBTTagDouble: {
                return compound.getDouble(tag);
            }
            case NBTTagEnd: {
                return null;
            }
            case NBTTagCompound: {
                if (compound.hasTag(tag)) {
                    if (compound.getType(tag) != NBTType.NBTTagCompound) break;
                    return compound.getCompound(tag);
                }
                return compound.getOrCreateCompound(tag);
            }
            case NBTTagCompoundList: {
                return new ArrayList<ReadWriteNBT>(compound.getCompoundList(tag));
            }
            case NBTTagStringList: {
                return new ArrayList(compound.getStringList(tag));
            }
            case NBTTagDoubleList: {
                return new ArrayList(compound.getDoubleList(tag));
            }
            case NBTTagFloatList: {
                return new ArrayList(compound.getFloatList(tag));
            }
            case NBTTagIntList: {
                return new ArrayList(compound.getIntegerList(tag));
            }
            case NBTTagLongList: {
                return new ArrayList(compound.getLongList(tag));
            }
            default: {
                if (!SkBee.isDebug()) break;
                throw new IllegalArgumentException("Unknown tag type, please let the dev know -> type: " + String.valueOf((Object)type));
            }
        }
        return null;
    }

    public static void addNBTToBlock(Block block, NBTCompound compound) {
        if (block.getType().isAir()) {
            return;
        }
        BlockState blockState = block.getState();
        if (blockState instanceof TileState) {
            TileState tileState = (TileState)blockState;
            NBTCustomTileEntity nbtBlock = new NBTCustomTileEntity((BlockState)tileState);
            nbtBlock.mergeCompound(compound);
        } else {
            NBTCustomBlock nbtCustomBlock = new NBTCustomBlock(block);
            nbtCustomBlock.mergeCompound(compound);
        }
    }

    public static void addNBTToEntity(Entity entity, NBTCompound compound) {
        NBTCustomEntity nbtEntity = new NBTCustomEntity(entity);
        nbtEntity.mergeCompound(compound);
    }
}

