/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.region.scheduler;

import com.shanebeestudios.skbee.api.region.TaskUtils;
import com.shanebeestudios.skbee.api.region.scheduler.Scheduler;
import com.shanebeestudios.skbee.api.region.scheduler.task.FoliaTask;
import com.shanebeestudios.skbee.api.region.scheduler.task.Task;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class FoliaScheduler
implements Scheduler<ScheduledTask> {
    private static final GlobalRegionScheduler GLOBAL_SCHEDULER = Bukkit.getGlobalRegionScheduler();
    private static final RegionScheduler REGION_SCHEDULER = Bukkit.getRegionScheduler();
    private static final AsyncScheduler ASYNC_SCHEDULER = Bukkit.getAsyncScheduler();
    @Nullable
    private final Entity entity;
    @Nullable
    private final Location location;

    public static FoliaScheduler getGlobalScheduler() {
        return new FoliaScheduler(null, null);
    }

    public static FoliaScheduler getRegionalScheduler(Location location) {
        return new FoliaScheduler(null, location);
    }

    public static FoliaScheduler getEntityScheduler(Entity entity) {
        return new FoliaScheduler(entity, null);
    }

    public FoliaScheduler(@Nullable Entity entity, @Nullable Location location) {
        this.entity = entity;
        this.location = location;
    }

    public FoliaTask runTask(Runnable task) {
        ScheduledTask scheduledTask = this.entity != null ? this.entity.getScheduler().run(TaskUtils.getPlugin(), t -> task.run(), null) : (this.location != null ? REGION_SCHEDULER.run(TaskUtils.getPlugin(), this.location, t -> task.run()) : GLOBAL_SCHEDULER.run(TaskUtils.getPlugin(), t -> task.run()));
        return new FoliaTask(scheduledTask);
    }

    public FoliaTask runTaskAsync(Runnable task) {
        ScheduledTask scheduledTask = ASYNC_SCHEDULER.runNow(TaskUtils.getPlugin(), t -> task.run());
        return new FoliaTask(scheduledTask);
    }

    public FoliaTask runTaskLater(Runnable task, long delay) {
        if (delay <= 0L) {
            delay = 1L;
        }
        ScheduledTask scheduledTask = this.entity != null ? this.entity.getScheduler().runDelayed(TaskUtils.getPlugin(), t -> task.run(), null, delay) : (this.location != null ? REGION_SCHEDULER.runDelayed(TaskUtils.getPlugin(), this.location, t -> task.run(), delay) : GLOBAL_SCHEDULER.runDelayed(TaskUtils.getPlugin(), t -> task.run(), delay));
        return new FoliaTask(scheduledTask);
    }

    @Override
    public Task<ScheduledTask> runTaskLaterAsync(Runnable task, long delay) {
        if (delay <= 0L) {
            delay = 1L;
        }
        ScheduledTask scheduledTask = ASYNC_SCHEDULER.runDelayed(TaskUtils.getPlugin(), t -> task.run(), delay * 50L, TimeUnit.MILLISECONDS);
        return new FoliaTask(scheduledTask);
    }

    public FoliaTask runTaskTimer(Runnable task, long delay, long period) {
        if (delay <= 0L) {
            delay = 1L;
        }
        ScheduledTask scheduledTask = this.entity != null ? this.entity.getScheduler().runAtFixedRate(TaskUtils.getPlugin(), t -> task.run(), null, delay, period) : (this.location != null ? REGION_SCHEDULER.runAtFixedRate(TaskUtils.getPlugin(), this.location, t -> task.run(), delay, period) : GLOBAL_SCHEDULER.runAtFixedRate(TaskUtils.getPlugin(), t -> task.run(), delay, period));
        return new FoliaTask(scheduledTask);
    }

    @Override
    public Task<ScheduledTask> runTaskTimerAsync(Runnable task, long delay, long period) {
        if (delay <= 0L) {
            delay = 1L;
        }
        ScheduledTask scheduledTask = ASYNC_SCHEDULER.runAtFixedRate(TaskUtils.getPlugin(), t -> task.run(), delay * 50L, period * 50L, TimeUnit.MILLISECONDS);
        return new FoliaTask(scheduledTask);
    }
}

