/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.registry;

import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import com.shanebeestudios.skbee.api.registry.RegistryHolder;
import com.shanebeestudios.skbee.api.registry.RegistryUtils;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.tag.TagKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import net.kyori.adventure.key.Key;
import org.bukkit.GameEvent;
import org.bukkit.JukeboxSong;
import org.bukkit.Keyed;
import org.bukkit.MusicInstrument;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockType;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.generator.structure.Structure;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.comparator.Comparators;
import org.skriptlang.skript.lang.comparator.Relation;
import org.skriptlang.skript.lang.converter.Converter;

public class RegistryHolders {
    private static final Registry<BlockType> BLOCK_REGISTRY = RegistryUtils.getRegistry(RegistryKey.BLOCK);
    private static final Registry<ItemType> ITEM_REGISTRY = RegistryUtils.getRegistry(RegistryKey.ITEM);
    private static final Map<String, RegistryHolder> REGISTRY_HOLDERS_BY_NAME = new HashMap<String, RegistryHolder>();
    private static final Map<RegistryKey, RegistryHolder> REGISTRY_HOLDERS_BY_REGISTRY_KEY = new HashMap<RegistryKey, RegistryHolder>();

    private static <F extends Keyed, T extends Keyed> void register(RegistryKey<F> key, Class<T> returnType) {
        RegistryHolders.register(key, returnType, null, (o1, o2) -> {
            TypedKey typedKey = TypedKey.create((RegistryKey)o1.registryKey(), (Key)o2.key());
            return Relation.get((boolean)RegistryAccess.registryAccess().getRegistry(o1.registryKey()).getTag(o1).contains(typedKey));
        });
    }

    private static <F extends Keyed, T> void register(RegistryKey<F> key, Class<T> returnType, @Nullable Converter<F, T> converter) {
        RegistryHolders.register(key, returnType, converter, null);
    }

    private static <F extends Keyed, T> void register(RegistryKey<F> key, Class<T> returnType, @Nullable Converter<F, T> converter, @Nullable org.skriptlang.skript.lang.comparator.Comparator<TagKey, T> tagComparator) {
        Object name = key.key().value();
        name = ((String)name).substring(((String)name).lastIndexOf("/") + 1);
        name = (String)name + " registry";
        RegistryHolder<F, T> registryHolder = new RegistryHolder<F, T>(key, returnType, (String)name, converter);
        REGISTRY_HOLDERS_BY_NAME.put((String)name, registryHolder);
        String nameNoUnderscore = ((String)name).replace("_", " ");
        if (!REGISTRY_HOLDERS_BY_NAME.containsKey(nameNoUnderscore)) {
            REGISTRY_HOLDERS_BY_NAME.put(nameNoUnderscore, registryHolder);
        }
        REGISTRY_HOLDERS_BY_REGISTRY_KEY.put(key, registryHolder);
        Class<TagKey> tkc = TagKey.class;
        if (tagComparator != null) {
            Comparators.registerComparator(tkc, returnType, tagComparator);
        }
    }

    public static String getDocUsage() {
        ArrayList docNames = new ArrayList();
        REGISTRY_HOLDERS_BY_REGISTRY_KEY.forEach((key, holder) -> docNames.add(holder.getDocString()));
        Collections.sort(docNames);
        return String.join((CharSequence)"\n", docNames);
    }

    public static Supplier<Iterator<RegistryKey>> getSupplier() {
        ArrayList keys = new ArrayList();
        REGISTRY_HOLDERS_BY_REGISTRY_KEY.keySet().stream().sorted(Comparator.comparing(Object::toString)).forEach(keys::add);
        return keys::iterator;
    }

    public static Parser<RegistryKey<?>> createParser() {
        return new Parser<RegistryKey<?>>(){

            @Nullable
            public RegistryKey<?> parse(String string, ParseContext context) {
                RegistryHolder registryHolder = REGISTRY_HOLDERS_BY_NAME.get(string = string.replace("minecraft:", ""));
                if (registryHolder != null) {
                    return registryHolder.getRegistryKey();
                }
                return null;
            }

            public String toString(RegistryKey<?> registryKey, int flags) {
                return String.valueOf(registryKey.key()) + " registry";
            }

            public String toVariableNameString(RegistryKey<?> registryKey) {
                return this.toString(registryKey, 0);
            }
        };
    }

    @NotNull
    public static RegistryHolder getRegistryHolder(RegistryKey<?> key) {
        return REGISTRY_HOLDERS_BY_REGISTRY_KEY.get(key);
    }

    static {
        org.skriptlang.skript.lang.comparator.Comparator itemTypeComparator = (tagKey, itemType) -> {
            Key key = itemType.getMaterial().key();
            if (tagKey.registryKey() == RegistryKey.BLOCK) {
                TypedKey typedKey = TypedKey.create((RegistryKey)RegistryKey.BLOCK, (Key)key);
                return Relation.get((boolean)BLOCK_REGISTRY.getTag(tagKey).contains(typedKey));
            }
            if (tagKey.registryKey() == RegistryKey.ITEM) {
                TypedKey typedKey = TypedKey.create((RegistryKey)RegistryKey.ITEM, (Key)key);
                return Relation.get((boolean)ITEM_REGISTRY.getTag(tagKey).contains(typedKey));
            }
            return null;
        };
        RegistryHolders.register(RegistryKey.ATTRIBUTE, Attribute.class);
        RegistryHolders.register(RegistryKey.BIOME, Biome.class);
        RegistryHolders.register(RegistryKey.BLOCK, ch.njol.skript.aliases.ItemType.class, blockType -> new ch.njol.skript.aliases.ItemType(blockType.asMaterial()), itemTypeComparator);
        RegistryHolders.register(RegistryKey.ENCHANTMENT, Enchantment.class);
        RegistryHolders.register(RegistryKey.ENTITY_TYPE, EntityType.class);
        RegistryHolders.register(RegistryKey.DAMAGE_TYPE, DamageType.class);
        RegistryHolders.register(RegistryKey.GAME_EVENT, GameEvent.class);
        RegistryHolders.register(RegistryKey.INSTRUMENT, MusicInstrument.class);
        RegistryHolders.register(RegistryKey.ITEM, ch.njol.skript.aliases.ItemType.class, itemType -> new ch.njol.skript.aliases.ItemType(itemType.asMaterial()));
        RegistryHolders.register(RegistryKey.JUKEBOX_SONG, JukeboxSong.class);
        RegistryHolders.register(RegistryKey.MOB_EFFECT, PotionEffectType.class);
        RegistryHolders.register(RegistryKey.POTION, PotionType.class);
        RegistryHolders.register(RegistryKey.PARTICLE_TYPE, Particle.class);
        RegistryHolders.register(RegistryKey.SOUND_EVENT, String.class, soundEvent -> soundEvent.key().toString());
        RegistryHolders.register(RegistryKey.STRUCTURE, Structure.class);
        RegistryHolders.register(RegistryKey.TRIM_MATERIAL, TrimMaterial.class);
        RegistryHolders.register(RegistryKey.TRIM_PATTERN, TrimPattern.class);
        RegistryHolders.register(RegistryKey.VILLAGER_PROFESSION, Villager.Profession.class);
        RegistryHolders.register(RegistryKey.VILLAGER_TYPE, Villager.Type.class);
    }
}

