/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.skript.runtime;

import ch.njol.skript.Skript;
import ch.njol.skript.test.runner.TestMode;
import com.shanebeestudios.skbee.SkBee;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface SyntaxRuntimeErrorProducer
extends org.skriptlang.skript.log.runtime.SyntaxRuntimeErrorProducer {
    public static final boolean DISABLE_ERROR = SkBee.getPlugin().getPluginConfig().RUNTIME_DISABLE_ERRORS;
    public static final boolean DISABLE_WARNING = SkBee.getPlugin().getPluginConfig().RUNTIME_DISABLE_WARNINGS;

    default public void error(String message) {
        this.error(message, null);
    }

    default public void errorRegex(String message, String regex) {
        if (DISABLE_ERROR) {
            return;
        }
        if (TestMode.ENABLED) {
            Skript.error((String)message);
            return;
        }
        if (regex != null && this.getNode() != null) {
            String fullLine = this.getNode().save().trim();
            Pattern pattern = Pattern.compile("(" + regex + ")");
            Matcher matcher = pattern.matcher(fullLine);
            if (matcher.find()) {
                regex = matcher.group(1);
            }
        }
        super.error(message, regex);
    }

    default public void error(String message, String highlight) {
        if (DISABLE_ERROR) {
            return;
        }
        if (TestMode.ENABLED) {
            Skript.error((String)message);
            return;
        }
        super.error(message, highlight);
    }

    default public void warning(String message) {
        this.warning(message, null);
    }

    default public void warningRegex(String message, String regex) {
        if (DISABLE_WARNING) {
            return;
        }
        if (TestMode.ENABLED) {
            Skript.error((String)message);
            return;
        }
        if (regex != null && this.getNode() != null) {
            String fullLine = this.getNode().save().trim();
            Pattern pattern = Pattern.compile("(" + regex + ")");
            Matcher matcher = pattern.matcher(fullLine);
            if (matcher.find()) {
                regex = matcher.group(1);
            }
        }
        super.warning(message, regex);
    }

    default public void warning(String message, String highlight) {
        if (DISABLE_WARNING) {
            return;
        }
        if (TestMode.ENABLED) {
            Skript.error((String)message);
            return;
        }
        super.warning(message, highlight);
    }
}

