/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.structure;

import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.util.MathUtil;
import com.shanebeestudios.skbee.api.util.Util;
import com.shanebeestudios.skbee.api.wrapper.PDCWrapper;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.RegionAccessor;
import org.bukkit.block.BlockState;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.structure.Palette;
import org.bukkit.structure.Structure;
import org.bukkit.structure.StructureManager;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class StructureWrapper {
    private static final StructureManager STRUCTURE_MANAGER = Bukkit.getStructureManager();
    private static final String ROTATION_KEY = "rotation";
    private static final String MIRROR_KEY = "mirror";
    private static final String INTEGRITY_KEY = "integrity";
    private static final String INCLUDE_ENTITIES_KEY = "includeEntities";
    private static final String LAST_SAVED_LOCATION_KEY = "lastSavedLocation";
    private final Structure structure;
    private final NamespacedKey key;
    private StructureRotation rotation;
    private Mirror mirror;
    private float integrity = 1.0f;
    private boolean includeEntities = true;
    private final PDCWrapper pdcWrapper;
    private Location lastPlacedLocation;

    public static StructureWrapper wrap(Structure structure, NamespacedKey key) {
        return new StructureWrapper(structure, key);
    }

    private StructureWrapper(Structure structure, NamespacedKey key) {
        this.key = key;
        this.structure = structure;
        this.pdcWrapper = PDCWrapper.wrap((PersistentDataHolder)structure);
        this.rotation = StructureRotation.values()[this.pdcWrapper.getByte(ROTATION_KEY)];
        this.mirror = Mirror.values()[this.pdcWrapper.getByte(MIRROR_KEY)];
        if (this.pdcWrapper.hasKey(INTEGRITY_KEY)) {
            this.integrity = MathUtil.clamp(this.pdcWrapper.getFloat(INTEGRITY_KEY), 0.0f, 1.0f);
        }
        if (this.pdcWrapper.hasKey(INCLUDE_ENTITIES_KEY)) {
            this.includeEntities = this.pdcWrapper.getBoolean(INCLUDE_ENTITIES_KEY);
        }
        this.lastPlacedLocation = this.pdcWrapper.getLocation(LAST_SAVED_LOCATION_KEY);
    }

    public void fill(Location location, BlockVector blockVector) {
        this.structure.fill(location, blockVector, true);
    }

    public void place(Location location, int palette) {
        this.lastPlacedLocation = location;
        this.pdcWrapper.setLocation(LAST_SAVED_LOCATION_KEY, location);
        palette = MathUtil.clamp(palette, -1, this.structure.getPaletteCount() - 1);
        this.structure.place(location, this.includeEntities, this.rotation, this.mirror, palette, this.integrity, new Random());
    }

    public void place(LimitedRegion region, Vector vector) {
        this.structure.place((RegionAccessor)region, new BlockVector(vector), this.includeEntities, this.rotation, this.mirror, -1, this.integrity, new Random());
    }

    public void place(Location location) {
        this.place(location, -1);
    }

    public void save() {
        block2: {
            try {
                STRUCTURE_MANAGER.saveStructure(this.key, this.structure);
            }
            catch (IOException e) {
                Util.skriptError("Could not save structure '%s', enable debug in SkBee config for more info.", this.getName());
                if (!SkBee.isDebug()) break block2;
                e.printStackTrace();
            }
        }
    }

    public void delete() {
        block2: {
            try {
                STRUCTURE_MANAGER.deleteStructure(this.key, true);
                STRUCTURE_MANAGER.unregisterStructure(this.key);
            }
            catch (IOException e) {
                Util.skriptError("Could not delete structure '%s', enable debug in SkBee config for more info.", this.getName());
                if (!SkBee.isDebug()) break block2;
                e.printStackTrace();
            }
        }
    }

    @Nullable
    public List<BlockState> getBlockStates() {
        if (this.structure.getPaletteCount() > 0) {
            return ((Palette)this.structure.getPalettes().get(0)).getBlocks();
        }
        return null;
    }

    public Structure getBukkitStructure() {
        return this.structure;
    }

    public String getName() {
        return this.key.getKey();
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public StructureRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(StructureRotation rotation) {
        this.rotation = rotation;
        this.pdcWrapper.setByte(ROTATION_KEY, (byte)rotation.ordinal());
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public void setMirror(Mirror mirror) {
        this.mirror = mirror;
        this.pdcWrapper.setByte(MIRROR_KEY, (byte)mirror.ordinal());
    }

    public float getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(float integrity) {
        this.integrity = MathUtil.clamp(integrity, 0.0f, 1.0f);
        this.pdcWrapper.setFloat(INTEGRITY_KEY, this.integrity);
    }

    public boolean isIncludeEntities() {
        return this.includeEntities;
    }

    public void setIncludeEntities(boolean includeEntities) {
        this.includeEntities = includeEntities;
        this.pdcWrapper.setBoolean(INCLUDE_ENTITIES_KEY, includeEntities);
    }

    public Vector getSize() {
        BlockVector size = this.structure.getSize();
        return new Vector(size.getX(), size.getY(), size.getZ());
    }

    public Location getLastPlacedLocation() {
        return this.lastPlacedLocation;
    }

    public void reset() {
        this.setMirror(Mirror.NONE);
        this.setRotation(StructureRotation.NONE);
        this.setIntegrity(1.0f);
        this.setIncludeEntities(true);
    }

    public String toString() {
        return String.format("Structure{key=\"%s\", rotation=%s, mirror=%s, integrity=%s, includeEntities=%s (%s), size=[%s]}", this.key, this.rotation, this.mirror, Float.valueOf(this.integrity), this.includeEntities, this.structure.getEntityCount(), this.structure.getSize());
    }
}

