/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.util;

import ch.njol.skript.Skript;
import com.shanebeestudios.skbee.api.util.MathUtil;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.ArrayList;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.Nullable;

public class BlockDataUtils {
    private static final boolean HAS_ITEMTYPE = Skript.classExists((String)"org.bukkit.inventory.ItemType");

    public static String @Nullable [] getBlockDataTagValues(BlockData blockData) {
        String[] splits1 = blockData.getAsString().split("\\[");
        if (splits1.length >= 2) {
            String[] splits2 = splits1[1].split("]");
            return splits2[0].split(",");
        }
        return null;
    }

    public static String @Nullable [] getBlockDataTags(BlockData blockData) {
        String[] splitData = BlockDataUtils.getBlockDataTagValues(blockData);
        ArrayList<String> tags = new ArrayList<String>();
        if (splitData == null) {
            return null;
        }
        for (String splitDatum : splitData) {
            tags.add(splitDatum.split("=")[0]);
        }
        return tags.toArray(new String[0]);
    }

    @Nullable
    public static Material getBlockForm(Material material) {
        if (material.isBlock()) {
            return material;
        }
        if (HAS_ITEMTYPE) {
            ItemType itemType = (ItemType)Registry.ITEM.get(material.getKey());
            if (itemType != null && itemType.hasBlockType()) {
                return itemType.getBlockType().asMaterial();
            }
            return null;
        }
        return switch (material) {
            case Material.WHEAT_SEEDS -> Material.WHEAT;
            case Material.POTATO -> Material.POTATOES;
            case Material.CARROT -> Material.CARROTS;
            case Material.BEETROOT_SEEDS -> Material.BEETROOTS;
            case Material.PUMPKIN_SEEDS -> Material.PUMPKIN_STEM;
            case Material.MELON_SEEDS -> Material.MELON_STEM;
            case Material.SWEET_BERRIES -> Material.SWEET_BERRY_BUSH;
            default -> material;
        };
    }

    @Nullable
    public static Object getBlockDataValueFromTag(BlockData blockData, String tag) {
        String[] sp = BlockDataUtils.getBlockDataTagValues(blockData);
        if (sp != null) {
            for (String string : sp) {
                String[] s = string.split("=");
                if (!s[0].equals(tag)) continue;
                String value = s[1];
                if (value == null) {
                    return null;
                }
                if (MathUtil.isBoolean(value)) {
                    return Boolean.valueOf(value);
                }
                if (MathUtil.isNumber(value)) {
                    return Integer.parseInt(value);
                }
                return value;
            }
        }
        return null;
    }

    @Nullable
    public static BlockData setBlockDataTag(BlockData oldBlockData, String tag, Object value) {
        if (oldBlockData.getAsString().contains("[")) {
            String newData = String.valueOf(oldBlockData.getMaterial().getKey()) + "[" + tag.toLowerCase(Locale.ROOT) + "=" + String.valueOf(value) + "]";
            try {
                BlockData blockData = Bukkit.createBlockData((String)newData);
                return oldBlockData.merge(blockData);
            }
            catch (IllegalArgumentException ex) {
                Util.debug("Could not parse block data: %s", newData);
            }
        }
        return null;
    }
}

