/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.util;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.slot.InventorySlot;
import ch.njol.skript.util.slot.Slot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemUtils {
    public static final boolean HAS_KEY = Skript.methodExists(AttributeModifier.class, (String)"getKey", (Class[])new Class[0]);
    public static final boolean HAS_EQUIPMENT_SLOT_GROUP = Skript.methodExists(AttributeModifier.class, (String)"getSlotGroup", (Class[])new Class[0]);

    public static boolean hasAttributeModifier(ItemMeta itemMeta, Attribute attribute, AttributeModifier modifier) {
        if (itemMeta.hasAttributeModifiers()) {
            Collection attributeModifiers = itemMeta.getAttributeModifiers(attribute);
            if (attributeModifiers == null) {
                return false;
            }
            for (AttributeModifier mod : attributeModifiers) {
                if (HAS_KEY && modifier.getKey().equals((Object)mod.getKey())) {
                    return true;
                }
                if (!modifier.getName().equalsIgnoreCase(mod.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static String attributeModifierToString(AttributeModifier attributeModifier) {
        StringBuilder builder = new StringBuilder("AttributeModifier{");
        if (HAS_KEY) {
            builder.append("key='").append(attributeModifier.getKey()).append("'");
        } else {
            builder.append("name='").append(attributeModifier.getName()).append("'");
            builder.append(",uuid='").append(attributeModifier.getUniqueId()).append("'");
        }
        builder.append(",amount=").append(attributeModifier.getAmount());
        if (HAS_EQUIPMENT_SLOT_GROUP) {
            builder.append(",slot=").append(Classes.toString((Object)attributeModifier.getSlotGroup()));
        } else {
            builder.append(",slot=").append(Classes.toString((Object)attributeModifier.getSlot()));
        }
        builder.append(",operation=").append(Classes.toString((Object)attributeModifier.getOperation()));
        builder.append("}");
        return builder.toString();
    }

    public static List<ItemStack> addItemTypesToList(List<ItemType> itemTypes, List<ItemStack> itemStacks) {
        ArrayList<ItemStack> originalList = itemStacks != null ? new ArrayList<ItemStack>(itemStacks) : new ArrayList();
        ItemStack[] buffer = originalList.toArray(new ItemStack[1000]);
        for (ItemType itemType : itemTypes) {
            itemType.addTo(buffer);
        }
        ArrayList<ItemStack> newList = new ArrayList<ItemStack>();
        for (ItemStack itemStack : buffer) {
            if (itemStack == null || itemStack.isEmpty()) continue;
            newList.add(itemStack);
        }
        return newList;
    }

    public static List<ItemStack> removeItemTypesFromList(List<ItemStack> itemStacks, List<ItemType> itemTypes) {
        ArrayList<ItemStack> copyList = new ArrayList<ItemStack>(itemStacks);
        for (ItemType itemType : itemTypes) {
            itemType.removeFrom(new List[]{copyList});
        }
        ArrayList<ItemStack> newItems = new ArrayList<ItemStack>();
        for (ItemStack itemStack : copyList) {
            if (itemStack == null || itemStack.isEmpty()) continue;
            newItems.add(itemStack);
        }
        return newItems;
    }

    public static void modifyItemMeta(ItemType itemType, Consumer<ItemMeta> meta) {
        ItemMeta itemMeta = itemType.getItemMeta();
        meta.accept(itemMeta);
        itemType.setItemMeta(itemMeta);
    }

    public static void modifyItemMeta(ItemStack itemStack, Consumer<ItemMeta> meta) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        meta.accept(itemMeta);
        itemStack.setItemMeta(itemMeta);
    }

    @Nullable
    public static ItemStack getItemStackFromObjects(Object object) {
        if (object instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object;
            return itemStack;
        }
        if (object instanceof ItemType) {
            ItemType itemType = (ItemType)object;
            return itemType.getRandom();
        }
        if (object instanceof Slot) {
            Slot slot = (Slot)object;
            return slot.getItem();
        }
        return null;
    }

    public static void modifyItems(Object[] objects, Consumer<ItemStack> itemConsumer) {
        for (Object object : objects) {
            ItemUtils.modifyItems(object, itemConsumer);
        }
    }

    public static void modifyItems(Object object, Consumer<ItemStack> itemConsumer) {
        Slot slot;
        ItemStack itemStack = null;
        if (object instanceof ItemStack) {
            ItemStack i;
            itemStack = i = (ItemStack)object;
        } else if (object instanceof ItemType) {
            ItemType itemType = (ItemType)object;
            itemStack = itemType.getRandom();
        } else if (object instanceof Slot) {
            Slot slot2 = (Slot)object;
            itemStack = slot2.getItem();
        }
        if (itemStack == null) {
            return;
        }
        itemConsumer.accept(itemStack);
        if (object instanceof ItemType) {
            ItemType itemType = (ItemType)object;
            itemType.setItemMeta(itemStack.getItemMeta());
        } else if (object instanceof Slot && (slot = (Slot)object) instanceof InventorySlot) {
            slot.setItem(itemStack);
        }
    }

    @Nullable
    public static <T> T getValue(Object itemObject, Function<ItemStack, T> itemFunction) {
        ItemStack itemStack = null;
        if (itemObject instanceof ItemStack) {
            ItemStack i;
            itemStack = i = (ItemStack)itemObject;
        } else if (itemObject instanceof ItemType) {
            ItemType itemType = (ItemType)itemObject;
            itemStack = itemType.getRandom();
        } else if (itemObject instanceof Slot) {
            Slot slot = (Slot)itemObject;
            itemStack = slot.getItem();
        }
        if (itemStack == null) {
            return null;
        }
        return itemFunction.apply(itemStack);
    }

    @NotNull
    public static <T> List<T> getValues(Object[] itemObjects, Function<ItemStack, T> itemFunction) {
        ArrayList<T> values = new ArrayList<T>();
        for (Object itemObject : itemObjects) {
            T value = ItemUtils.getValue(itemObject, itemFunction);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }
}

