/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.util;

import ch.njol.skript.Skript;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.util.Version;
import com.shanebeestudios.skbee.SkBee;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class Util {
    private static final String PREFIX = "&7[&bSk&3Bee&7] ";
    private static final String PREFIX_ERROR = "&7[&bSk&3Bee &cERROR&7] ";
    private static final Pattern HEX_PATTERN = Pattern.compile("<#([A-Fa-f\\d]){6}>");
    private static final boolean SKRIPT_IS_THERE = Bukkit.getPluginManager().getPlugin("Skript") != null;
    public static final boolean IS_RUNNING_FOLIA = Skript.classExists((String)"io.papermc.paper.threadedregions.FoliaWatchdogThread");
    public static final String MCWIKI_TICK_COMMAND = "See [**Tick Command**](https://minecraft.wiki/w/Commands/tick) on McWiki for more details.";
    public static final boolean IS_RUNNING_SKRIPT_2_11 = Skript.getVersion().isLargerThan(new Version(new int[]{2, 10, 999}));
    public static final boolean IS_RUNNING_SKRIPT_2_12 = Skript.getVersion().isLargerThan(new Version(new int[]{2, 11, 999}));
    public static final boolean IS_RUNNING_SKRIPT_2_13 = Skript.getVersion().isLargerThan(new Version(new int[]{2, 12, 999}));
    public static final boolean IS_RUNNING_MC_1_21 = Skript.isRunningMinecraft((int)1, (int)21);
    public static final boolean IS_RUNNING_MC_1_21_2 = Skript.isRunningMinecraft((int)1, (int)21, (int)2);
    public static final boolean IS_RUNNING_MC_1_21_4 = Skript.isRunningMinecraft((int)1, (int)21, (int)4);
    public static final boolean IS_RUNNING_MC_1_21_5 = Skript.isRunningMinecraft((int)1, (int)21, (int)5);
    public static final boolean IS_RUNNING_MC_1_21_9 = Skript.isRunningMinecraft((int)1, (int)21, (int)9);
    private static final List<String> DEBUGS = new ArrayList<String>();

    public static String getColString(String string) {
        Matcher matcher = HEX_PATTERN.matcher((CharSequence)string);
        if (SKRIPT_IS_THERE) {
            while (matcher.find()) {
                ChatColor hexColor = ChatColor.of((String)matcher.group().substring(1, matcher.group().length() - 1));
                String before = ((String)string).substring(0, matcher.start());
                String after = ((String)string).substring(matcher.end());
                string = before + String.valueOf(hexColor) + after;
                matcher = HEX_PATTERN.matcher((CharSequence)string);
            }
        } else {
            string = HEX_PATTERN.matcher((CharSequence)string).replaceAll("");
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static void sendColMsg(CommandSender receiver, String format, Object ... objects) {
        receiver.sendMessage(Util.getColString(String.format(format, objects)));
    }

    public static void log(String format, Object ... objects) {
        String log = String.format(format, objects);
        Bukkit.getConsoleSender().sendMessage(Util.getColString(PREFIX + log));
    }

    public static void skriptError(String format, Object ... objects) {
        String error = String.format(format, objects);
        Skript.error((String)Util.getColString(PREFIX_ERROR + error), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
    }

    public static void errorForAdmins(String format, Object ... objects) {
        String error = "&7[&bSk&3Bee &cERROR&7] &c" + format;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("skbee.admin")) continue;
            Util.sendColMsg((CommandSender)player, error, objects);
        }
    }

    public static void debug(String format, Object ... objects) {
        if (SkBee.isDebug()) {
            String debug = String.format(format, objects);
            Bukkit.getConsoleSender().sendMessage(Util.getColString(PREFIX_ERROR + debug));
        }
    }

    public static void logLoading(String format, Object ... objects) {
        String form = String.format(format, objects);
        DEBUGS.add(form);
        Util.log(form, new Object[0]);
    }

    public static List<String> getDebugs() {
        return DEBUGS;
    }

    public static void clearDebugs() {
        DEBUGS.clear();
    }

    @Nullable
    public static NamespacedKey getNamespacedKey(@Nullable String key, boolean error) {
        NamespacedKey namespacedKey;
        if (key == null) {
            return null;
        }
        if (!((String)key).contains(":")) {
            key = "minecraft:" + (String)key;
        }
        if (((String)key).length() > 255) {
            if (error) {
                Util.skriptError("An invalid key was provided, key must be less than 256 characters: %s", key);
            }
            return null;
        }
        if (((String)(key = ((String)key).toLowerCase())).contains(" ")) {
            key = ((String)key).replace(" ", "_");
        }
        if ((namespacedKey = NamespacedKey.fromString((String)key)) == null && error) {
            Util.skriptError("An invalid key was provided, that didn't follow [a-z0-9/._-:]. key: %s", key);
        }
        return namespacedKey;
    }

    public static int[] uuidToIntArray(UUID uuid) {
        long most = uuid.getMostSignificantBits();
        long least = uuid.getLeastSignificantBits();
        return new int[]{(int)(most >> 32), (int)most, (int)(least >> 32), (int)least};
    }

    public static boolean isMaterialTag(Tag<?> tag) {
        ParameterizedType superC = (ParameterizedType)tag.getClass().getGenericSuperclass();
        for (Type arg : superC.getActualTypeArguments()) {
            if (!arg.equals(Material.class)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntityTypeTag(Tag<?> tag) {
        ParameterizedType superC = (ParameterizedType)tag.getClass().getGenericSuperclass();
        for (Type arg : superC.getActualTypeArguments()) {
            if (!arg.equals(EntityType.class)) continue;
            return true;
        }
        return false;
    }
}

