/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.virtualfurnace.api;

import com.shanebeestudios.skbee.api.virtualfurnace.api.VirtualFurnaceAPI;
import com.shanebeestudios.skbee.api.virtualfurnace.api.machine.Furnace;
import com.shanebeestudios.skbee.api.virtualfurnace.api.machine.Machine;
import com.shanebeestudios.skbee.api.virtualfurnace.api.property.FurnaceProperties;
import com.shanebeestudios.skbee.api.virtualfurnace.api.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FurnaceManager {
    private static final boolean HAS_GLINT = Util.methodExists(ItemMeta.class, "getEnchantmentGlintOverride", new Class[0]);
    @NotNull
    private static final Enchantment SHARPNESS = (Enchantment)Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)"sharpness"));
    @NotNull
    private static final Enchantment INFINITY = (Enchantment)Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)"infinity"));
    private final VirtualFurnaceAPI virtualFurnaceAPI;
    private File machineFile;
    private FileConfiguration machineConfig;
    private final Map<UUID, Machine> machineMap;
    private final NamespacedKey key;

    FurnaceManager(VirtualFurnaceAPI virtualFurnaceAPI) {
        this.virtualFurnaceAPI = virtualFurnaceAPI;
        this.machineMap = new HashMap<UUID, Machine>();
        this.key = new NamespacedKey((Plugin)virtualFurnaceAPI.getJavaPlugin(), "furnaceID");
        this.loadFurnaceConfig();
    }

    @Deprecated(since="1.1.0")
    public Collection<Furnace> getAllFurnaces() {
        ArrayList<Furnace> furnaces = new ArrayList<Furnace>();
        for (Machine value : this.machineMap.values()) {
            if (!(value instanceof Furnace)) continue;
            Furnace furnace = (Furnace)value;
            furnaces.add(furnace);
        }
        return furnaces;
    }

    public Collection<Machine> getAllMachines() {
        return Collections.unmodifiableCollection(this.machineMap.values());
    }

    public Machine getByID(@NotNull UUID uuid) {
        return this.machineMap.get(uuid);
    }

    public Furnace createFurnace(@NotNull String name) {
        return this.createFurnace(name, FurnaceProperties.FURNACE, null);
    }

    public Furnace createFurnace(@NotNull String name, @NotNull FurnaceProperties furnaceProperties) {
        return this.createFurnace(name, furnaceProperties, null);
    }

    public Furnace createFurnace(@NotNull String name, @NotNull Consumer<Furnace> function) {
        return this.createFurnace(name, FurnaceProperties.FURNACE, function);
    }

    public Furnace createFurnace(@NotNull String name, @NotNull FurnaceProperties furnaceProperties, @Nullable Consumer<Furnace> function) {
        Furnace furnace = new Furnace(name, furnaceProperties);
        if (function != null) {
            function.accept(furnace);
        }
        this.machineMap.put(furnace.getUniqueID(), furnace);
        this.saveFurnace(furnace, true);
        return furnace;
    }

    public ItemStack createItemWithFurnace(@NotNull String name, @NotNull Material material, boolean glowing) {
        return this.createItemWithFurnace(name, new ItemStack(material), glowing);
    }

    public ItemStack createItemWithFurnace(@NotNull String name, @NotNull FurnaceProperties furnaceProperties, @NotNull Material material, boolean glowing) {
        return this.createItemWithFurnace(name, furnaceProperties, new ItemStack(material), glowing);
    }

    public ItemStack createItemWithFurnace(@NotNull String name, @NotNull Material material, boolean glowing, @Nullable Consumer<Furnace> function) {
        return this.createItemWithFurnace(name, new ItemStack(material), glowing, function);
    }

    public ItemStack createItemWithFurnace(@NotNull String name, @NotNull FurnaceProperties furnaceProperties, @NotNull Material material, boolean glowing, @Nullable Consumer<Furnace> function) {
        return this.createItemWithFurnace(name, furnaceProperties, new ItemStack(material), glowing, function);
    }

    public ItemStack createItemWithFurnace(@NotNull String name, @NotNull ItemStack itemStack, boolean glowing) {
        return this.createItemWithFurnace(name, itemStack, glowing, null);
    }

    public ItemStack createItemWithFurnace(@NotNull String name, @NotNull FurnaceProperties furnaceProperties, @NotNull ItemStack itemStack, boolean glowing) {
        return this.createItemWithFurnace(name, furnaceProperties, itemStack, glowing, null);
    }

    public ItemStack createItemWithFurnace(@NotNull String name, @NotNull ItemStack itemStack, boolean glowing, @Nullable Consumer<Furnace> function) {
        return this.createItemWithFurnace(name, FurnaceProperties.FURNACE, itemStack, glowing, function);
    }

    public ItemStack createItemWithFurnace(@NotNull String name, @NotNull FurnaceProperties furnaceProperties, @NotNull ItemStack itemStack, boolean glowing, @Nullable Consumer<Furnace> function) {
        ItemStack item = itemStack.clone();
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        if (glowing) {
            if (HAS_GLINT) {
                meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
            } else {
                if (item.getType() == Material.ARROW) {
                    meta.addEnchant(SHARPNESS, 1, true);
                } else {
                    meta.addEnchant(INFINITY, 1, true);
                }
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
        }
        Furnace furnace = function == null ? this.createFurnace(name, furnaceProperties) : this.createFurnace(name, furnaceProperties, function);
        meta.getPersistentDataContainer().set(this.key, PersistentDataType.STRING, (Object)furnace.getUniqueID().toString());
        item.setItemMeta(meta);
        return item;
    }

    @Deprecated(since="1.1.0")
    public Furnace getFurnaceFromItemStack(@NotNull ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null && meta.getPersistentDataContainer().has(this.key, PersistentDataType.STRING)) {
            String u = (String)meta.getPersistentDataContainer().get(this.key, PersistentDataType.STRING);
            if (u == null) {
                return null;
            }
            Machine machine = this.getByID(UUID.fromString(u));
            if (machine instanceof Furnace) {
                Furnace furnace = (Furnace)machine;
                return furnace;
            }
        }
        return null;
    }

    public Machine getMachineFromItemStack(@NotNull ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null && meta.getPersistentDataContainer().has(this.key, PersistentDataType.STRING)) {
            String u = (String)meta.getPersistentDataContainer().get(this.key, PersistentDataType.STRING);
            if (u == null) {
                return null;
            }
            return this.getByID(UUID.fromString(u));
        }
        return null;
    }

    private void loadFurnaceConfig() {
        if (this.machineFile == null) {
            this.machineFile = new File(this.virtualFurnaceAPI.getJavaPlugin().getDataFolder(), "furnaces.yml");
        }
        if (!this.machineFile.exists()) {
            this.virtualFurnaceAPI.getJavaPlugin().saveResource("furnaces.yml", false);
        }
        this.machineConfig = YamlConfiguration.loadConfiguration((File)this.machineFile);
        this.loadFurnaces();
    }

    void loadFurnaces() {
        ConfigurationSection section = this.machineConfig.getConfigurationSection("furnaces");
        if (section != null) {
            for (String string : section.getKeys(true)) {
                Object object = section.get(string);
                if (!(object instanceof Furnace)) continue;
                Furnace furnace = (Furnace)object;
                this.machineMap.put(UUID.fromString(string), furnace);
            }
        }
        Util.log("Loaded: &b" + this.machineMap.size() + "&7 furnaces");
    }

    public void saveFurnace(@NotNull Machine machine, boolean saveToFile) {
        this.machineConfig.set("furnaces." + String.valueOf(machine.getUniqueID()), (Object)machine);
        if (saveToFile) {
            this.saveConfig();
        }
    }

    public void removeFurnaceFromConfig(@NotNull Machine machine, boolean saveToFile) {
        this.machineConfig.set("furnaces." + String.valueOf(machine.getUniqueID()), null);
        if (saveToFile) {
            this.saveConfig();
        }
    }

    public void removeMachine(@NotNull Machine machine, boolean saveToFile) {
        this.machineMap.remove(machine.getUniqueID());
        this.removeFurnaceFromConfig(machine, saveToFile);
    }

    public void saveAll() {
        for (Machine machine : this.machineMap.values()) {
            this.saveFurnace(machine, false);
        }
        this.saveConfig();
    }

    public void saveConfig() {
        try {
            this.machineConfig.save(this.machineFile);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void shutdown() {
        this.saveAll();
        this.machineMap.clear();
    }
}

