/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.virtualfurnace.api.property;

import com.shanebeestudios.skbee.api.virtualfurnace.api.property.Properties;
import com.shanebeestudios.skbee.api.virtualfurnace.api.util.Util;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.jetbrains.annotations.NotNull;

public class FurnaceProperties
extends Properties
implements Keyed,
ConfigurationSerializable {
    public static final FurnaceProperties FURNACE = FurnaceProperties.build("furnace", 1.0, 1.0);
    public static final FurnaceProperties BLAST_FURNACE = FurnaceProperties.build("blast_furnace", 2.0, 1.0);
    public static final FurnaceProperties SMOKER = FurnaceProperties.build("smoker", 2.0, 1.0);
    private double cookX = 1.0;
    private double fuelX = 1.0;

    private static FurnaceProperties build(String key, double cookX, double fuelX) {
        return new FurnaceProperties("properties_" + key).cookMultiplier(cookX).fuelMultiplier(fuelX);
    }

    private static FurnaceProperties getProperty(String key) {
        for (NamespacedKey namespacedKey : KEY_MAP.keySet()) {
            if (!namespacedKey.getKey().equalsIgnoreCase(key)) continue;
            return (FurnaceProperties)KEY_MAP.get(namespacedKey);
        }
        return null;
    }

    public FurnaceProperties(String key) {
        super(Util.getKey(key.toLowerCase()));
    }

    public FurnaceProperties cookMultiplier(double amount) {
        this.cookX = amount;
        return this;
    }

    public double getCookMultiplier() {
        return this.cookX;
    }

    public FurnaceProperties fuelMultiplier(double amount) {
        this.fuelX = amount;
        return this;
    }

    public double getFuelMultiplier() {
        return this.fuelX;
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FurnaceProperties that = (FurnaceProperties)o;
        return Double.compare(that.cookX, this.cookX) == 0 && Double.compare(that.fuelX, this.fuelX) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.cookX, this.fuelX);
    }

    public String toString() {
        return "Properties{key=" + String.valueOf(this.key) + ", cookX=" + this.cookX + ", fuelX=" + this.fuelX + "}";
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("key", this.key.toString());
        result.put("cookX", this.cookX);
        result.put("fuelX", this.fuelX);
        return result;
    }

    public static FurnaceProperties deserialize(Map<String, Object> args) {
        String stringKey = ((String)args.get("key")).split(":")[1];
        double cook = (Double)args.get("cookX");
        double fuel = (Double)args.get("fuelX");
        FurnaceProperties furnaceProperties = FurnaceProperties.getProperty(stringKey);
        if (furnaceProperties != null) {
            return furnaceProperties;
        }
        return new FurnaceProperties(stringKey).cookMultiplier(cook).fuelMultiplier(fuel);
    }
}

