/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.virtualfurnace.api.recipe;

import com.shanebeestudios.skbee.api.virtualfurnace.api.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.jetbrains.annotations.NotNull;

public class Fuel
implements Keyed {
    private static final List<Fuel> VANILLA_FUELS = new ArrayList<Fuel>();
    public static final Fuel LAVA_BUCKET = Fuel.get("lava_bucket", Material.LAVA_BUCKET, 20000);
    public static final Fuel BLOCK_OF_COAL = Fuel.get("block_of_coal", Material.COAL_BLOCK, 16000);
    public static final Fuel BLAZE_ROD = Fuel.get("blaze_rod", Material.BLAZE_ROD, 2400);
    public static final Fuel COAL = Fuel.get("coal", Material.COAL, 1600);
    public static final Fuel CHARCOAL = Fuel.get("charcoal", Material.CHARCOAL, 1600);
    public static final Fuel LOGS = Fuel.get("logs", (Tag<Material>)Tag.LOGS, 300);
    public static final Fuel PLANKS = Fuel.get("planks", (Tag<Material>)Tag.PLANKS, 300);
    public static final Fuel WOODEN_STAIRS = Fuel.get("wooden_stairs", (Tag<Material>)Tag.WOODEN_STAIRS, 300);
    public static final Fuel WOODEN_SLABS = Fuel.get("wooden_slabs", (Tag<Material>)Tag.WOODEN_SLABS, 150);
    public static final Fuel WOODEN_TRAPDOORS = Fuel.get("wooden_trapdoors", (Tag<Material>)Tag.WOODEN_TRAPDOORS, 300);
    public static final Fuel WOODEN_PRESSURE_PLATES = Fuel.get("wooden_pressure_plates", (Tag<Material>)Tag.WOODEN_PRESSURE_PLATES, 300);
    public static final Fuel WOODEN_FENCES = Fuel.get("wooden_fences", (Tag<Material>)Tag.WOODEN_FENCES, 300);
    public static final Fuel FENCE_GATES = Fuel.get("fence_gates", (Tag<Material>)Tag.FENCE_GATES, 300);
    public static final Fuel NOTE_BLOCK = Fuel.get("note_block", Material.NOTE_BLOCK, 300);
    public static final Fuel BOOKSHELF = Fuel.get("bookshelf", Material.BOOKSHELF, 300);
    public static final Fuel CHISELED_BOOKSHELF;
    public static final Fuel LECTERN;
    public static final Fuel JUKEBOX;
    public static final Fuel CHEST;
    public static final Fuel TRAPPED_CHEST;
    public static final Fuel CRAFTING_TABLE;
    public static final Fuel DAYLIGHT_DETECTOR;
    public static final Fuel BANNERS;
    public static final Fuel BOW;
    public static final Fuel FISHING_ROD;
    public static final Fuel LADDER;
    public static final Fuel SIGNS;
    public static final Fuel HANGING_SIGNS;
    public static final Fuel WOODEN_SHOVEL;
    public static final Fuel WOODEN_SWORD;
    public static final Fuel WOODEN_HOE;
    public static final Fuel WOODEN_AXE;
    public static final Fuel WOODEN_PICKAXE;
    public static final Fuel WOODEN_DOORS;
    public static final Fuel BOATS;
    public static final Fuel WOOL;
    public static final Fuel WOODEN_BUTTONS;
    public static final Fuel STICK;
    public static final Fuel SAPLINGS;
    public static final Fuel BOWL;
    public static final Fuel WOOL_CARPETS;
    public static final Fuel DRIED_KELP_BLOCK;
    public static final Fuel CROSSBOW;
    public static final Fuel BAMBOO;
    public static final Fuel DEAD_BUSH;
    public static final Fuel SCAFFOLDING;
    public static final Fuel LOOM;
    public static final Fuel BARREL;
    public static final Fuel CARTOGRAPHY_TABLE;
    public static final Fuel FLETCHING_TABLE;
    public static final Fuel SMITHING_TABLE;
    public static final Fuel COMPOSTER;
    public static final Fuel AZALEA;
    public static final Fuel FLOWERING_AZALEA;
    public static final Fuel MANGROVE_ROOTS;
    private final NamespacedKey key;
    private final Material material;
    private final Tag<Material> tag;
    private final int burnTime;

    private static Fuel get(String name, Material fuel, int burnTicks) {
        Fuel fuel1 = new Fuel(Util.getKey("mc_fuel_" + name), fuel, burnTicks);
        VANILLA_FUELS.add(fuel1);
        return fuel1;
    }

    private static Fuel get(String name, Tag<Material> fuelTag, int burnTicks) {
        Fuel fuel = new Fuel(Util.getKey("mc_fuel_" + name), fuelTag, burnTicks);
        VANILLA_FUELS.add(fuel);
        return fuel;
    }

    public static List<Fuel> getVanillaFuels() {
        return Collections.unmodifiableList(VANILLA_FUELS);
    }

    public Fuel(NamespacedKey key, Material fuelMaterial, int burnTime) {
        this.key = key;
        this.material = fuelMaterial;
        this.tag = null;
        this.burnTime = burnTime;
    }

    public Fuel(NamespacedKey key, Tag<Material> fuelTag, int burnTime) {
        this.key = key;
        this.material = null;
        this.tag = fuelTag;
        this.burnTime = burnTime;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @Deprecated
    public Material getFuel() {
        return this.material;
    }

    public Material getFuelMaterial() {
        return this.material;
    }

    public Tag<Material> getTag() {
        return this.tag;
    }

    public boolean matchFuel(Material material) {
        if (this.material != null && this.material == material) {
            return true;
        }
        return this.tag != null && this.tag.isTagged((Keyed)material);
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fuel fuel = (Fuel)o;
        return this.burnTime == fuel.burnTime && Objects.equals(this.key, fuel.key) && this.material == fuel.material && Objects.equals(this.tag, fuel.tag);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.material, this.tag, this.burnTime);
    }

    public String toString() {
        return "Fuel{key=" + String.valueOf(this.key) + (this.material != null ? ", material=" + String.valueOf(this.material) : ", tag=" + String.valueOf(this.tag.getKey())) + ", burnTime=" + this.burnTime + "}";
    }

    static {
        LECTERN = Fuel.get("lectern", Material.LECTERN, 300);
        JUKEBOX = Fuel.get("jukebox", Material.JUKEBOX, 300);
        CHEST = Fuel.get("chest", Material.CHEST, 300);
        TRAPPED_CHEST = Fuel.get("trapped_chest", Material.TRAPPED_CHEST, 300);
        CRAFTING_TABLE = Fuel.get("crafting_table", Material.CRAFTING_TABLE, 300);
        DAYLIGHT_DETECTOR = Fuel.get("daylight_detector", Material.DAYLIGHT_DETECTOR, 300);
        BANNERS = Fuel.get("banners", (Tag<Material>)Tag.BANNERS, 300);
        BOW = Fuel.get("bow", Material.BOW, 300);
        FISHING_ROD = Fuel.get("fishing_rod", Material.FISHING_ROD, 300);
        LADDER = Fuel.get("ladder", Material.LADDER, 300);
        SIGNS = Fuel.get("signs", (Tag<Material>)Tag.SIGNS, 200);
        WOODEN_SHOVEL = Fuel.get("wooden_shovel", Material.WOODEN_SHOVEL, 200);
        WOODEN_SWORD = Fuel.get("wooden_sword", Material.WOODEN_SWORD, 200);
        WOODEN_HOE = Fuel.get("wooden_hoe", Material.WOODEN_HOE, 200);
        WOODEN_AXE = Fuel.get("wooden_axe", Material.WOODEN_AXE, 200);
        WOODEN_PICKAXE = Fuel.get("wooden_pickaxe", Material.WOODEN_PICKAXE, 200);
        WOODEN_DOORS = Fuel.get("wooden_doors", (Tag<Material>)Tag.WOODEN_DOORS, 200);
        BOATS = Fuel.get("boats", (Tag<Material>)Tag.ITEMS_BOATS, 1200);
        WOOL = Fuel.get("wool", (Tag<Material>)Tag.WOOL, 100);
        WOODEN_BUTTONS = Fuel.get("wooden_buttons", (Tag<Material>)Tag.WOODEN_BUTTONS, 100);
        STICK = Fuel.get("stick", Material.STICK, 100);
        SAPLINGS = Fuel.get("saplings", (Tag<Material>)Tag.SAPLINGS, 100);
        BOWL = Fuel.get("bowl", Material.BOWL, 100);
        WOOL_CARPETS = Fuel.get("wool_carpets", (Tag<Material>)Tag.WOOL_CARPETS, 67);
        DRIED_KELP_BLOCK = Fuel.get("dried_kelp_block", Material.DRIED_KELP_BLOCK, 4001);
        CROSSBOW = Fuel.get("crossbow", Material.CROSSBOW, 300);
        BAMBOO = Fuel.get("bamboo", Material.BAMBOO, 50);
        DEAD_BUSH = Fuel.get("dead_bush", Material.DEAD_BUSH, 100);
        SCAFFOLDING = Fuel.get("scaffolding", Material.SCAFFOLDING, 50);
        LOOM = Fuel.get("loom", Material.LOOM, 300);
        BARREL = Fuel.get("barrel", Material.BARREL, 300);
        CARTOGRAPHY_TABLE = Fuel.get("cartography_table", Material.CARTOGRAPHY_TABLE, 300);
        FLETCHING_TABLE = Fuel.get("fletching_table", Material.FLETCHING_TABLE, 300);
        SMITHING_TABLE = Fuel.get("smithing_table", Material.SMITHING_TABLE, 300);
        COMPOSTER = Fuel.get("composter", Material.COMPOSTER, 300);
        AZALEA = Fuel.get("azalea", Material.AZALEA, 100);
        FLOWERING_AZALEA = Fuel.get("flowering_azalea", Material.FLOWERING_AZALEA, 100);
        MANGROVE_ROOTS = Util.isRunningMinecraft(1, 19) ? Fuel.get("mangrove_roots", Material.MANGROVE_ROOTS, 300) : null;
        if (Util.isRunningMinecraft(1, 20)) {
            CHISELED_BOOKSHELF = Fuel.get("chiseled_bookshelf", Material.CHISELED_BOOKSHELF, 300);
            HANGING_SIGNS = Fuel.get("hanging_signs", (Tag<Material>)Tag.ITEMS_HANGING_SIGNS, 800);
        } else {
            CHISELED_BOOKSHELF = null;
            HANGING_SIGNS = null;
        }
    }
}

