/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.virtualfurnace.api.task;

import com.shanebeestudios.skbee.api.virtualfurnace.api.FurnaceManager;
import com.shanebeestudios.skbee.api.virtualfurnace.api.VirtualFurnaceAPI;
import com.shanebeestudios.skbee.api.virtualfurnace.api.machine.Machine;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class MachineTick
extends BukkitRunnable {
    private final FurnaceManager furnaceManager;
    private final VirtualFurnaceAPI virtualFurnaceAPI;
    private int tick;
    private int id;
    private boolean running;

    public MachineTick(VirtualFurnaceAPI virtualFurnaceAPI) {
        this.virtualFurnaceAPI = virtualFurnaceAPI;
        this.furnaceManager = virtualFurnaceAPI.getFurnaceManager();
        this.tick = 0;
    }

    public void start() {
        BukkitTask task = this.runTaskTimerAsynchronously((Plugin)this.virtualFurnaceAPI.getJavaPlugin(), 15L, 1L);
        this.id = task.getTaskId();
    }

    public void run() {
        this.running = true;
        try {
            for (Machine machine : this.furnaceManager.getAllMachines()) {
                if (!this.running) {
                    return;
                }
                machine.tick();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++this.tick;
        if (this.tick >= 6000) {
            this.tick = 0;
            this.furnaceManager.saveAll();
        }
    }

    public synchronized void cancel() throws IllegalStateException {
        this.running = false;
        Bukkit.getScheduler().cancelTask(this.id);
    }
}

