/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.wrapper;

import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.NumberConversions;
import org.jetbrains.annotations.NotNull;

public class LazyLocation
extends Location {
    private String worldName;

    public LazyLocation(World world, double x, double y, double z, float yaw, float pitch) {
        super(world, x, y, z, yaw, pitch);
        this.worldName = world.getName();
    }

    public LazyLocation(String worldName, double x, double y, double z, float yaw, float pitch) {
        super(null, x, y, z, yaw, pitch);
        this.worldName = worldName;
    }

    public LazyLocation(Location location) {
        super(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public Location getLocation() {
        World world;
        if (super.getWorld() == null && (world = Bukkit.getWorld((String)this.worldName)) != null) {
            this.setWorld(world);
        }
        return this;
    }

    @NotNull
    public Map<String, Object> serialize() {
        Map data = super.serialize();
        if (!data.containsKey("world")) {
            data.put("world", this.worldName);
        }
        return data;
    }

    @NotNull
    public static Location deserialize(@NotNull Map<String, Object> args) {
        String name;
        World world = null;
        if (args.containsKey("world") && (world = Bukkit.getWorld((String)(name = (String)args.get("world")))) == null) {
            return new LazyLocation(name, NumberConversions.toDouble((Object)args.get("x")), NumberConversions.toDouble((Object)args.get("y")), NumberConversions.toDouble((Object)args.get("z")), NumberConversions.toFloat((Object)args.get("yaw")), NumberConversions.toFloat((Object)args.get("pitch")));
        }
        return new LazyLocation(world, NumberConversions.toDouble((Object)args.get("x")), NumberConversions.toDouble((Object)args.get("y")), NumberConversions.toDouble((Object)args.get("z")), NumberConversions.toFloat((Object)args.get("yaw")), NumberConversions.toFloat((Object)args.get("pitch")));
    }
}

