/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.wrapper;

import com.shanebeestudios.skbee.SkBee;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PDCWrapper {
    private static final PersistentDataType<String, String> STRING = PersistentDataType.STRING;
    private static final PersistentDataType<Integer, Integer> INT = PersistentDataType.INTEGER;
    private static final PersistentDataType<Byte, Byte> BYTE = PersistentDataType.BYTE;
    private static final PersistentDataType<Float, Float> FLOAT = PersistentDataType.FLOAT;
    private static final PersistentDataType<int[], int[]> INT_ARRAY = PersistentDataType.INTEGER_ARRAY;
    private final PersistentDataContainer container;

    public static PDCWrapper wrap(PersistentDataHolder holder) {
        return new PDCWrapper(holder);
    }

    private PDCWrapper(PersistentDataHolder holder) {
        this.container = holder.getPersistentDataContainer();
    }

    private NamespacedKey getKey(String key) {
        return new NamespacedKey((Plugin)SkBee.getPlugin(), key);
    }

    private <T> void setValue(String key, PersistentDataType<T, T> type, T value) {
        NamespacedKey namespacedKey = this.getKey(key);
        this.container.set(namespacedKey, type, value);
    }

    @Nullable
    private <T> T getValue(String key, PersistentDataType<T, T> type) {
        NamespacedKey namespacedKey = this.getKey(key);
        if (this.container.has(namespacedKey, type)) {
            return (T)this.container.get(namespacedKey, type);
        }
        return null;
    }

    public boolean hasKey(String key) {
        return this.container.has(this.getKey(key));
    }

    public void deleteKey(String key) {
        this.container.remove(this.getKey(key));
    }

    public void setBoolean(String key, boolean value) {
        this.container.set(this.getKey(key), BYTE, (Object)(value ? (byte)1 : 0));
    }

    public boolean getBoolean(String key) {
        Byte value = this.getValue(key, BYTE);
        return value != null && value == 1;
    }

    public void setString(String key, String value) {
        this.setValue(key, STRING, value);
    }

    @Nullable
    public String getString(String key) {
        return this.getValue(key, STRING);
    }

    public void setInt(String key, int value) {
        this.setValue(key, INT, value);
    }

    public int getInt(String key) {
        Integer intValue = this.getValue(key, INT);
        if (intValue == null) {
            return 0;
        }
        return intValue;
    }

    public void setByte(String key, byte value) {
        this.setValue(key, BYTE, value);
    }

    public byte getByte(String key) {
        Byte byteValue = this.getValue(key, BYTE);
        if (byteValue == null) {
            return 0;
        }
        return byteValue;
    }

    public void setFloat(String key, float value) {
        this.setValue(key, FLOAT, Float.valueOf(value));
    }

    public float getFloat(String key) {
        Float floatValue = this.getValue(key, FLOAT);
        if (floatValue == null) {
            return 0.0f;
        }
        return floatValue.floatValue();
    }

    public void setLocation(String key, @NotNull Location location) {
        int[] coords = new int[]{location.getBlockX(), location.getBlockY(), location.getBlockZ()};
        String world = location.getWorld().getName();
        this.setValue(key + ".coords", INT_ARRAY, coords);
        this.setValue(key + ".world", STRING, world);
    }

    @Nullable
    public Location getLocation(String key) {
        String worldName = this.getValue(key + ".world", STRING);
        if (worldName == null) {
            return null;
        }
        int[] ints = this.getValue(key + ".coords", INT_ARRAY);
        if (ints == null || ints.length != 3) {
            return null;
        }
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return null;
        }
        return new Location(world, (double)ints[0], (double)ints[1], (double)ints[2]);
    }
}

