/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.config;

import ch.njol.skript.Skript;
import ch.njol.skript.test.runner.TestMode;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.util.Util;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    private static Boolean IS_TESTING = null;
    private final SkBee plugin;
    private FileConfiguration config;
    private File configFile;
    public boolean settings_debug;
    public boolean settings_use_paper_schedulers;
    public boolean SETTINGS_UPDATE_CHECKER_ENABLED;
    public boolean SETTINGS_UPDATE_CHECKER_ASYNC;
    public boolean SETTINGS_FASTBOARD_LINES;
    public boolean ELEMENTS_NBT;
    public boolean NBT_ALLOW_UNSAFE_OPERATIONS;
    public boolean NBT_EVENTS_BREAK_BLOCK;
    public boolean NBT_EVENTS_PISTON_EXTEND;
    public boolean NBT_EVENTS_ENTITY_CHANGE_BLOCK;
    public boolean NBT_EVENTS_ENTITY_EXPLODE;
    public boolean NBT_EVENTS_BLOCK_EXPLODE;
    public boolean ELEMENTS_BOUND;
    public boolean BOUND_EVENTS_PLAYER_MOVE;
    public boolean BOUND_EVENTS_PLAYER_TELEPORT;
    public boolean BOUND_EVENTS_PLAYER_RESPAWN;
    public boolean BOUND_EVENTS_PLAYER_BED_ENTER;
    public boolean BOUND_EVENTS_PLAYER_BED_LEAVE;
    public boolean BOUND_EVENTS_ENTITY_MOUNT;
    public boolean BOUND_EVENTS_ENTITY_DISMOUNT;
    public boolean BOUND_EVENTS_VEHICLE_ENTER;
    public boolean BOUND_EVENTS_VEHICLE_EXIT;
    public boolean BOUND_EVENTS_VEHICLE_DESTROY;
    public boolean BOUND_EVENTS_VEHICLE_MOVE;
    public boolean ELEMENTS_FASTBOARD;
    public boolean ELEMENTS_SCOREBOARD;
    public boolean ELEMENTS_RECIPE;
    public boolean ELEMENTS_STRUCTURE;
    public boolean ELEMENTS_VIRTUAL_FURNACE;
    public boolean ELEMENTS_TEXT_COMPONENT;
    public boolean ELEMENTS_WORLD_CREATOR;
    public boolean ELEMENTS_GAME_EVENT;
    public boolean ELEMENTS_BOSS_BAR;
    public boolean ELEMENTS_STATISTIC;
    public boolean ELEMENTS_VILLAGER;
    public boolean ELEMENTS_ADVANCEMENT;
    public boolean ELEMENTS_WORLD_BORDER;
    public boolean ELEMENTS_PARTICLE;
    public boolean ELEMENTS_RAYTRACE;
    public boolean ELEMENTS_FISHING;
    public boolean ELEMENTS_DISPLAY;
    public boolean ELEMENTS_TICK_MANAGER;
    public boolean ELEMENTS_DAMAGE_SOURCE;
    public boolean ELEMENTS_ITEM_COMPONENT;
    public boolean ELEMENTS_CHUNK_GEN;
    public boolean ELEMENTS_SWITCH_CASE;
    public boolean ELEMENTS_PROPERTY;
    public boolean AUTO_LOAD_WORLDS;
    public boolean RUNTIME_DISABLE_ERRORS;
    public boolean RUNTIME_DISABLE_WARNINGS;
    public boolean on_the_flip_side;

    public Config(SkBee plugin) {
        this.plugin = plugin;
        this.loadConfigFile();
    }

    private void loadConfigFile() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        }
        if (!this.configFile.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.matchConfig();
        this.loadConfigs();
    }

    private void matchConfig() {
        try {
            boolean hasUpdated = false;
            InputStream stream = this.plugin.getResource(this.configFile.getName());
            assert (stream != null);
            InputStreamReader is = new InputStreamReader(stream);
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)is);
            for (String key : defConfig.getConfigurationSection("").getKeys(true)) {
                if (this.config.contains(key)) continue;
                this.config.set(key, defConfig.get(key));
                hasUpdated = true;
            }
            for (String key : this.config.getConfigurationSection("").getKeys(true)) {
                if (defConfig.contains(key)) continue;
                this.config.set(key, null);
                hasUpdated = true;
            }
            if (hasUpdated) {
                this.config.save(this.configFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean getSetting(String setting) {
        return this.config.getBoolean("settings." + setting);
    }

    private boolean getElement(String element) {
        if (Config.isTestingEnabled()) {
            return true;
        }
        return this.config.getBoolean("elements." + element);
    }

    private boolean getNBTEvent(String nbtEvent) {
        return this.config.getBoolean("nbt-events." + nbtEvent);
    }

    private boolean getBoundEvent(String boundEvent) {
        return this.config.getBoolean("bound-events." + boundEvent);
    }

    private void loadConfigs() {
        this.settings_debug = this.getSetting("debug");
        boolean bl = this.settings_use_paper_schedulers = this.getSetting("use-paper-schedulers") && Skript.classExists((String)"io.papermc.paper.threadedregions.scheduler.RegionScheduler");
        if (this.settings_use_paper_schedulers) {
            Util.logLoading("&eUsing Paper schedulers.", new Object[0]);
        }
        this.SETTINGS_UPDATE_CHECKER_ENABLED = this.getSetting("update-checker.enabled");
        this.SETTINGS_UPDATE_CHECKER_ASYNC = this.getSetting("update-checker.async");
        this.SETTINGS_FASTBOARD_LINES = this.getSetting("fastboard-reverse-lines");
        this.ELEMENTS_NBT = this.getElement("nbt");
        this.NBT_ALLOW_UNSAFE_OPERATIONS = this.getSetting("allow-unsafe-nbt-operations");
        if (this.NBT_ALLOW_UNSAFE_OPERATIONS) {
            Util.logLoading("&eAllow Unsafe NBT Operations enabled!", new Object[0]);
        }
        this.NBT_EVENTS_BREAK_BLOCK = this.getNBTEvent("block-break");
        this.NBT_EVENTS_PISTON_EXTEND = this.getNBTEvent("piston-extend");
        this.NBT_EVENTS_ENTITY_CHANGE_BLOCK = this.getNBTEvent("entity-change-block");
        this.NBT_EVENTS_ENTITY_EXPLODE = this.getNBTEvent("entity-explode");
        this.NBT_EVENTS_BLOCK_EXPLODE = this.getNBTEvent("block-explode");
        this.ELEMENTS_BOUND = this.getElement("bound");
        this.BOUND_EVENTS_PLAYER_MOVE = this.getBoundEvent("player-move");
        this.BOUND_EVENTS_PLAYER_TELEPORT = this.getBoundEvent("player-teleport");
        this.BOUND_EVENTS_PLAYER_RESPAWN = this.getBoundEvent("player-respawn");
        this.BOUND_EVENTS_PLAYER_BED_ENTER = this.getBoundEvent("player-bed-enter");
        this.BOUND_EVENTS_PLAYER_BED_LEAVE = this.getBoundEvent("player-bed-leave");
        this.BOUND_EVENTS_ENTITY_MOUNT = this.getBoundEvent("entity-mount");
        this.BOUND_EVENTS_ENTITY_DISMOUNT = this.getBoundEvent("entity-dismount");
        this.BOUND_EVENTS_VEHICLE_ENTER = this.getBoundEvent("vehicle-enter");
        this.BOUND_EVENTS_VEHICLE_EXIT = this.getBoundEvent("vehicle-exit");
        this.BOUND_EVENTS_VEHICLE_MOVE = this.getBoundEvent("vehicle-move");
        this.BOUND_EVENTS_VEHICLE_DESTROY = this.getBoundEvent("vehicle-destroy");
        this.ELEMENTS_FASTBOARD = this.getElement("fastboard");
        this.ELEMENTS_SCOREBOARD = this.getElement("scoreboard");
        this.ELEMENTS_RECIPE = this.getElement("recipe");
        this.ELEMENTS_STRUCTURE = this.getElement("structure");
        this.ELEMENTS_VIRTUAL_FURNACE = this.getElement("virtual-furnace");
        this.ELEMENTS_TEXT_COMPONENT = this.getElement("text-component");
        this.ELEMENTS_WORLD_CREATOR = this.getElement("world-creator");
        this.ELEMENTS_GAME_EVENT = this.getElement("game-event");
        this.ELEMENTS_BOSS_BAR = this.getElement("boss-bar");
        this.ELEMENTS_STATISTIC = this.getElement("statistic");
        this.ELEMENTS_VILLAGER = this.getElement("villager");
        this.ELEMENTS_ADVANCEMENT = this.getElement("advancement");
        this.ELEMENTS_WORLD_BORDER = this.getElement("world-border");
        this.ELEMENTS_PARTICLE = this.getElement("particle");
        this.ELEMENTS_RAYTRACE = this.getElement("raytrace");
        this.ELEMENTS_FISHING = this.getElement("fishing");
        this.ELEMENTS_DISPLAY = this.getElement("display-entity");
        this.ELEMENTS_TICK_MANAGER = this.getElement("tick-manager");
        this.ELEMENTS_DAMAGE_SOURCE = this.getElement("damage-source");
        this.ELEMENTS_CHUNK_GEN = this.getElement("chunk-generator");
        this.ELEMENTS_ITEM_COMPONENT = this.getElement("item-component");
        this.ELEMENTS_SWITCH_CASE = this.getElement("switch-case");
        this.ELEMENTS_PROPERTY = this.getElement("property");
        this.AUTO_LOAD_WORLDS = this.getElement("auto-load-custom-worlds");
        this.RUNTIME_DISABLE_ERRORS = this.config.getBoolean("runtime.disable-errors");
        this.RUNTIME_DISABLE_WARNINGS = this.config.getBoolean("runtime.disable-warnings");
        this.on_the_flip_side = this.config.getBoolean("special.on-the-flip-side");
    }

    private static boolean isTestingEnabled() {
        if (IS_TESTING == null) {
            IS_TESTING = Bukkit.getPluginManager().getPlugin("Skript") != null && Skript.classExists((String)"ch.njol.skript.test.runner.TestMode") ? Boolean.valueOf(TestMode.ENABLED) : Boolean.valueOf(false);
        }
        return IS_TESTING;
    }
}

