/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.advancement.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Advancement - Load")
@Description(value={"Load an advancement represented by the specified string into the server.", "The advancement format is governed by Minecraft and has no specified layout.", "It is currently a JSON object, as described by [**McWiki**](https://minecraft.wiki/w/Advancement).", "Loaded advancements will be stored and persisted across server restarts and reloads.", "NOTE: Bukkit has marked this as 'Unsafe', so please use at your own risk.", "Watch console for errors when loading an advancement."})
@Examples(value={"\u00af\\_(\u30c4)_/\u00af"})
@Since(value={"1.17.0"})
public class EffAdvancementLoad
extends Effect {
    private Expression<String> advancement;
    private Expression<String> key;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.advancement = exprs[0];
        this.key = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        String key = (String)this.key.getSingle(event);
        String advancement = (String)this.advancement.getSingle(event);
        if (key == null || advancement == null) {
            return;
        }
        NamespacedKey namespacedKey = Util.getNamespacedKey(key, true);
        if (namespacedKey != null) {
            try {
                Bukkit.getUnsafe().loadAdvancement(namespacedKey, advancement);
            }
            catch (Exception ex) {
                if (SkBee.isDebug()) {
                    ex.printStackTrace();
                }
                Util.skriptError("Unable to load advancement with key: '%s'", namespacedKey);
                Util.skriptError("Error: " + ex.getMessage(), new Object[0]);
                Util.skriptError("Enable DEBUG in SkBee config for more info!", new Object[0]);
            }
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "load advancement " + this.advancement.toString(e, d) + " with key " + this.key.toString(e, d);
    }

    static {
        Skript.registerEffect(EffAdvancementLoad.class, (String[])new String[]{"load advancement %string% with (key|id) %string%"});
    }
}

