/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.advancement.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.iterator.IteratorIterable;
import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.advancement.Advancement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Advancement - All Available")
@Description(value={"Get a list of all available advancements currently registered on the server."})
@Examples(value={"set {_a::*} to all available advancements", "loop all available advancements:"})
@Since(value={"1.17.0"})
public class ExprAdvancementAll
extends SimpleExpression<Advancement> {
    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        return true;
    }

    @Nullable
    protected Advancement[] get(Event event) {
        ArrayList<Advancement> advancements = new ArrayList<Advancement>();
        Iterator<? extends Advancement> iterator = this.iterator(event);
        if (iterator == null) {
            return new Advancement[0];
        }
        for (Advancement advancement : new IteratorIterable(iterator)) {
            advancements.add(advancement);
        }
        return advancements.toArray(new Advancement[0]);
    }

    @Nullable
    public Iterator<? extends Advancement> iterator(Event event) {
        return Bukkit.advancementIterator();
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends Advancement> getReturnType() {
        return Advancement.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean b) {
        return "all available advancements";
    }

    static {
        Skript.registerExpression(ExprAdvancementAll.class, Advancement.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[all] available advancements"});
    }
}

