/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bossbar.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.SkriptColor;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.BossBarUtils;
import com.shanebeestudios.skbee.api.util.MathUtil;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="BossBar - Create")
@Description(value={"Create your own custom BossBar.", "**NOTE**: Progress is a number between 0-100.", "**NOTE**: This just creates a new custom bossbar. It will by default not be visible to anyone", "until you actually add players to it. See examples!!!", "**NOTE**: The ID is optional. If excluded, the BossBar will not save to the server."})
@Examples(value={"set {_bar} to boss bar with id \"le-bar\" with title \"My BossBar\"", "set {_bar} to boss bar with id \"le-bar\" with title \"Le Title\" with color pink with progress 50", "add all players to {_bar}"})
@Since(value={"2.14.1"})
public class ExprBossBarCreate
extends SimpleExpression<BossBar> {
    private Expression<String> key;
    private Expression<String> title;
    private Expression<SkriptColor> color;
    private Expression<BarStyle> barStyle;
    private Expression<Number> progress;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.key = exprs[0];
        this.title = exprs[1];
        this.color = exprs[2];
        this.barStyle = exprs[3];
        this.progress = exprs[4];
        return true;
    }

    @Nullable
    protected BossBar[] get(Event event) {
        Number proNumber;
        SkriptColor skriptColor;
        NamespacedKey key = null;
        if (this.key != null) {
            KeyedBossBar bossBar;
            String keyString = (String)this.key.getSingle(event);
            if (keyString != null) {
                key = Util.getNamespacedKey(keyString, false);
            }
            if (key != null && (bossBar = Bukkit.getBossBar((NamespacedKey)key)) != null) {
                return new BossBar[]{bossBar};
            }
        }
        String title = null;
        if (this.title != null && this.title.getSingle(event) != null) {
            title = (String)this.title.getSingle(event);
        }
        BarColor barColor = null;
        if (this.color != null && (skriptColor = (SkriptColor)this.color.getSingle(event)) != null) {
            barColor = BossBarUtils.getBossBarColor(skriptColor);
        }
        if (barColor == null) {
            barColor = BarColor.PURPLE;
        }
        BarStyle barStyle = null;
        if (this.barStyle != null) {
            barStyle = (BarStyle)this.barStyle.getSingle(event);
        }
        if (barStyle == null) {
            barStyle = BarStyle.SEGMENTED_20;
        }
        float progress = 1.0f;
        if (this.progress != null && (proNumber = (Number)this.progress.getSingle(event)) != null) {
            progress = MathUtil.clamp(proNumber.floatValue() / 100.0f, 0.0f, 1.0f);
        }
        Object bossBar = key != null ? Bukkit.createBossBar((NamespacedKey)key, (String)title, (BarColor)barColor, (BarStyle)barStyle, (BarFlag[])new BarFlag[0]) : Bukkit.createBossBar((String)title, (BarColor)barColor, (BarStyle)barStyle, (BarFlag[])new BarFlag[0]);
        bossBar.setProgress((double)progress);
        return new BossBar[]{bossBar};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends BossBar> getReturnType() {
        return BossBar.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String bar = "boss bar" + (String)(this.key != null ? " " + this.key.toString(e, d) : "");
        String title = this.title != null ? " named " + this.title.toString(e, d) : "";
        Object color = "";
        if (this.color != null) {
            color = " with color " + this.color.toString(e, d);
        }
        String style = this.barStyle != null ? " with style " + this.barStyle.toString(e, d) : "";
        String progress = this.progress != null ? " with progress " + this.progress.toString(e, d) : "";
        return bar + title + (String)color + style + progress;
    }

    static {
        Skript.registerExpression(ExprBossBarCreate.class, BossBar.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[new] boss[ ]bar [(named|with id) %-string%] with title %string% [with (color|colour) %-color%] [with style %-bossbarstyle%] [with progress %-number%]"});
    }
}

