/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bossbar.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Boss;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="BossBar - Entity/Player")
@Description(value={"Get a BossBar from an entity (such as a wither) or all BossBars of players.", "NOTE: BossBars from entities cannot be saved in global variables, as the entity may not be loaded on the", "server when that variable is trying to load. Custom BossBars and BossBars from players can be saved in variables."})
@Examples(value={"set {_bar} to boss bar of target entity", "set {_bars::*} to boss bars of player"})
@Since(value={"2.14.1"})
public class ExprBossBarEntity
extends SimpleExpression<BossBar> {
    private int pattern;
    private Expression<Entity> entity;
    private Expression<Player> players;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        this.entity = this.pattern == 0 ? exprs[0] : null;
        this.players = this.pattern == 1 ? exprs[0] : null;
        return true;
    }

    @Nullable
    protected BossBar[] get(Event event) {
        if (this.pattern == 0 && this.entity != null) {
            Entity entity = (Entity)this.entity.getSingle(event);
            if (entity instanceof Boss) {
                Boss boss = (Boss)entity;
                return new BossBar[]{boss.getBossBar()};
            }
        } else if (this.pattern == 1 && this.players != null) {
            ArrayList bars = new ArrayList();
            Player[] players = (Player[])this.players.getArray(event);
            Bukkit.getBossBars().forEachRemaining(bossBar -> {
                for (Player player : players) {
                    if (!bossBar.getPlayers().contains(player) || bars.contains(bossBar)) continue;
                    bars.add(bossBar);
                }
            });
            return bars.toArray(new BossBar[0]);
        }
        return null;
    }

    public boolean isSingle() {
        return this.pattern == 0;
    }

    @NotNull
    public Class<? extends BossBar> getReturnType() {
        return BossBar.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        if (this.pattern == 0) {
            return "boss bar of entity " + this.entity.toString(e, d);
        }
        return "boss bars of players " + this.players.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBossBarEntity.class, BossBar.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"boss[ ]bar of %entity%", "boss[ ]bars of %players%"});
    }
}

