/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bossbar.types;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.yggdrasil.Fields;
import com.shanebeestudios.skbee.api.util.Util;
import com.shanebeestudios.skbee.api.wrapper.EnumWrapper;
import java.io.StreamCorruptedException;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Types {
    static {
        if (Classes.getExactClassInfo(BossBar.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(BossBar.class, "bossbar").user(new String[]{"boss ?bars?"}).name("BossBar").description(new String[]{"Represents a BossBar. Either from an entity or a custom one.", "Players can be added to/removed from BossBars.", "Custom BossBars can be deleted, BossBars of entities cannot be deleted.", "NOTE: BossBars from entities cannot be saved in global variables, as the entity may not be loaded", "on the server when that variable is trying to load. Custom BossBars can be saved in variables."}).examples(new String[]{"set {_bar} to boss bar named \"le-bar\"", "add all players to {_bar}"}).since("1.16.0").parser((Parser)new Parser<BossBar>(){

                public boolean canParse(ParseContext context) {
                    return false;
                }

                @NotNull
                public String toString(BossBar bossBar, int flags) {
                    Object bar;
                    if (bossBar instanceof KeyedBossBar) {
                        KeyedBossBar keyedBossBar = (KeyedBossBar)bossBar;
                        bar = keyedBossBar.getKey().toString();
                    } else {
                        bar = "nokey:" + bossBar.getTitle();
                    }
                    return "BossBar[" + (String)bar + "]";
                }

                @NotNull
                public String toVariableNameString(BossBar bossBar) {
                    return this.toString(bossBar, 0);
                }
            }).changer((Changer)new Changer<BossBar>(){

                public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
                    if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.REMOVE_ALL) {
                        return (Class[])CollectionUtils.array((Object[])new Class[]{Player[].class});
                    }
                    if (mode == Changer.ChangeMode.DELETE) {
                        return (Class[])CollectionUtils.array((Object[])new Class[0]);
                    }
                    return null;
                }

                public void change(BossBar[] bossBars, @Nullable Object[] delta, Changer.ChangeMode mode) {
                    if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.REMOVE_ALL) {
                        if (delta == null) {
                            return;
                        }
                        for (BossBar bossBar : bossBars) {
                            for (Object object : delta) {
                                if (!(object instanceof Player)) continue;
                                Player player = (Player)object;
                                if (mode == Changer.ChangeMode.ADD) {
                                    bossBar.addPlayer(player);
                                    continue;
                                }
                                bossBar.removePlayer(player);
                            }
                        }
                    }
                    if (mode == Changer.ChangeMode.DELETE) {
                        for (BossBar bossBar : bossBars) {
                            bossBar.removeAll();
                            if (!(bossBar instanceof KeyedBossBar)) continue;
                            KeyedBossBar keyedBossBar = (KeyedBossBar)bossBar;
                            Bukkit.removeBossBar((NamespacedKey)keyedBossBar.getKey());
                        }
                    }
                }
            }).serializer((Serializer)new Serializer<BossBar>(){

                public Fields serialize(BossBar bossBar) {
                    Fields fields = new Fields();
                    if (bossBar instanceof KeyedBossBar) {
                        KeyedBossBar keyedBossBar = (KeyedBossBar)bossBar;
                        NamespacedKey key = keyedBossBar.getKey();
                        fields.putObject("namespace", (Object)key.getNamespace());
                        fields.putObject("key", (Object)key.getKey());
                    }
                    return fields;
                }

                public void deserialize(BossBar o, Fields f) {
                }

                protected BossBar deserialize(Fields fields) throws StreamCorruptedException {
                    String name = (String)fields.getObject("namespace", String.class);
                    String key = (String)fields.getObject("key", String.class);
                    assert (name != null);
                    assert (key != null);
                    NamespacedKey namespacedKey = new NamespacedKey(name, key);
                    KeyedBossBar bossBar = Bukkit.getBossBar((NamespacedKey)namespacedKey);
                    if (bossBar == null) {
                        throw new StreamCorruptedException("Missing Bossbar: [" + name + ":" + key + "]");
                    }
                    return bossBar;
                }

                public boolean mustSyncDeserialization() {
                    return false;
                }

                protected boolean canBeInstantiated() {
                    return false;
                }
            }));
        } else {
            Util.logLoading("&eIt looks like another addon registered 'bossbar' already.", new Object[0]);
            Util.logLoading("&eYou may have to use their BossBars in SkBee's BossBar elements.", new Object[0]);
        }
        if (Classes.getExactClassInfo(BarStyle.class) == null && Classes.getClassInfoNoError((String)"bossbarstyle") == null) {
            EnumWrapper<BarStyle> BAR_STYLE_ENUM = new EnumWrapper<BarStyle>(BarStyle.class);
            BAR_STYLE_ENUM.replace("solid", "solid bar");
            Classes.registerClass((ClassInfo)BAR_STYLE_ENUM.getClassInfo("bossbarstyle").user(new String[]{"boss ?bar ?styles?"}).name("BossBar Style").description(new String[]{"Represents the style options of a BossBar."}).examples(new String[]{"set bar style of {_bar} to segmented 20"}).since("1.16.0"));
        } else {
            Util.logLoading("&eIt looks like another addon registered 'boss bar style' already.", new Object[0]);
            Util.logLoading("&eYou may have to use their BossBar styles in SkBee's BossBar elements.", new Object[0]);
        }
        if (Classes.getExactClassInfo(BarFlag.class) == null && Classes.getClassInfoNoError((String)"bossbarflag") == null) {
            EnumWrapper<BarFlag> BAR_FLAG_ENUM = new EnumWrapper<BarFlag>(BarFlag.class);
            Classes.registerClass((ClassInfo)BAR_FLAG_ENUM.getClassInfo("bossbarflag").user(new String[]{"boss ?bar ?flags?"}).name("BossBar Flag").description(new String[]{"Represents the flag options of a BossBar."}).examples(new String[]{"set bar flag darken sky of {_bar} to true"}).since("1.16.0"));
        } else {
            Util.logLoading("&eIt looks like another addon registered 'boss bar flag' already.", new Object[0]);
            Util.logLoading("&eYou may have to use their BossBar flags in SkBee's BossBar elements.", new Object[0]);
        }
    }
}

