/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bound.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.bound.Bound;
import com.shanebeestudios.skbee.api.event.bound.BoundEnterEvent;
import com.shanebeestudios.skbee.api.event.bound.BoundEvent;
import com.shanebeestudios.skbee.api.event.bound.BoundExitEvent;
import com.shanebeestudios.skbee.api.listener.BoundBorderListener;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoundEvents
extends SkriptEvent {
    private static BoundBorderListener boundBorderListener;
    private Literal<String> boundID;

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.boundID = args[0];
        if (boundBorderListener == null) {
            SkBee plugin = SkBee.getPlugin();
            boundBorderListener = new BoundBorderListener(plugin);
            Bukkit.getPluginManager().registerEvents((Listener)boundBorderListener, (Plugin)plugin);
        }
        return true;
    }

    public boolean check(@NotNull Event event) {
        if (this.boundID == null) {
            return true;
        }
        return this.boundID.check(event, boundID -> {
            if (event instanceof BoundEvent) {
                BoundEvent boundEvent = (BoundEvent)event;
                return boundEvent.getBound().getId().equals(boundID);
            }
            return false;
        });
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "bound enter/exit" + (String)(this.boundID != null ? " with id " + this.boundID.toString(event, debug) : "");
    }

    static {
        Skript.registerEvent((String)"Bound - Enter", BoundEvents.class, BoundEnterEvent.class, (String[])new String[]{"(bound enter|enter bound) [with id %-string%]"}).description(new String[]{"Called when a player enters a bound. Optional ID of bound. 'event-string' = bound ID.", "NOTE: Due to breaking changes in Bukkit API, enter/exit events will not be called when a player mounts/dismounts an entity if running SkBee 3.5.0+ on MC 1.20.4 and below."}).examples(new String[]{"on bound enter:", "\tif event-bound = {bounds::spawn}:", "\t\tsend \"You entered spawn!\"", "on enter bound with id \"spawn\":", "\tcancel event"}).since("1.0.0, 1.12.2 (Bound IDs)");
        Skript.registerEvent((String)"Bound - Exit", BoundEvents.class, BoundExitEvent.class, (String[])new String[]{"(bound exit|exit bound) [with id %-string%]"}).description(new String[]{"Called when a player exits a bound. Optional ID of bound. 'event-string' = bound ID.", "NOTE: Due to breaking changes in Bukkit API, enter/exit events will not be called when a player mounts/dismounts an entity if running SkBee 3.5.0+ on MC 1.20.4 and below."}).examples(new String[]{"on bound exit:", "\tsend \"You left a bound\"", "\tif event-bound = {bound}:", "\t\tsend \"You left Spawn!\"", "on exit bound with id \"spawn\":", "\tcancel event"}).since("1.0.0, 1.12.2 (Bound IDs)");
        EventValues.registerEventValue(BoundEvent.class, Bound.class, BoundEvent::getBound, (int)0);
        EventValues.registerEventValue(BoundEvent.class, String.class, event -> event.getBound().getId(), (int)0);
        EventValues.registerEventValue(BoundEnterEvent.class, Player.class, BoundEnterEvent::getPlayer, (int)0);
        EventValues.registerEventValue(BoundExitEvent.class, Player.class, BoundExitEvent::getPlayer, (int)0);
    }
}

