/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bound.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.bound.Bound;
import com.shanebeestudios.skbee.api.bound.BoundConfig;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
@Name(value="Bound - Coords")
@Description(value={"DEPRECATED - Use bound locations/world expressions instead", "The coords and world of a bounding box. You can get the world/coords for a specific bound, you can also set the coords of a bounding box. You can NOT set the world of a bounding box. ", "Greater will always equal the higher south-east corner. ", "Lesser will always equal the lower north-west corner."})
@Examples(value={"set lesser y coord of {bound} to 10", "set {_x} to greater x coord of bound with id \"my.bound\""})
@Since(value={"1.0.0"})
public class ExprBoundCoords
extends PropertyExpression<Bound, Object> {
    private static final BoundConfig BOUND_CONFIG = SkBee.getPlugin().getBoundConfig();
    private boolean WORLD;
    private boolean LESSER;
    private int parse;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.WORLD = matchedPattern == 2;
        this.LESSER = matchedPattern == 0;
        this.parse = parseResult.mark;
        if (matchedPattern == 2) {
            Skript.warning((String)"Depreacted - use the 'bound world of %bounds%' expression instead.");
        } else {
            Skript.warning((String)"Deprecated - use the 'Bound - Locations' expression instead.");
        }
        return true;
    }

    protected Object[] get(Event event, Bound[] bounds) {
        return this.get(bounds, bound -> {
            if (this.WORLD) {
                return bound.getWorld();
            }
            return switch (this.parse) {
                case 0 -> this.LESSER ? bound.getLesserCorner().getX() : bound.getGreaterCorner().getX();
                case 1 -> this.LESSER ? bound.getLesserCorner().getY() : bound.getGreaterCorner().getY();
                default -> this.LESSER ? bound.getLesserCorner().getZ() : bound.getGreaterCorner().getZ();
            };
        });
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (!(this.WORLD || mode != Changer.ChangeMode.SET && mode != Changer.ChangeMode.ADD && mode != Changer.ChangeMode.REMOVE)) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        for (Bound bound : (Bound[])this.getExpr().getArray(e)) {
            int coord = ((Number)delta[0]).intValue();
            if (mode == Changer.ChangeMode.REMOVE) {
                coord = -coord;
            }
            Location less = bound.getLesserCorner();
            Location great = bound.getGreaterCorner().subtract(1.0, 1.0, 1.0);
            switch (this.parse) {
                case 0: {
                    if (this.LESSER) {
                        less.setX(mode == Changer.ChangeMode.SET ? (double)coord : less.getX() + (double)coord);
                        break;
                    }
                    great.setX(mode == Changer.ChangeMode.SET ? (double)coord : great.getX() + (double)coord);
                    break;
                }
                case 1: {
                    if (this.LESSER) {
                        less.setY(mode == Changer.ChangeMode.SET ? (double)coord : less.getY() + (double)coord);
                        break;
                    }
                    great.setY(mode == Changer.ChangeMode.SET ? (double)coord : great.getY() + (double)coord);
                    break;
                }
                case 2: {
                    if (this.LESSER) {
                        less.setZ(mode == Changer.ChangeMode.SET ? (double)coord : less.getZ() + (double)coord);
                        break;
                    }
                    great.setZ(mode == Changer.ChangeMode.SET ? (double)coord : great.getZ() + (double)coord);
                }
            }
            bound.resize(less, great);
            BOUND_CONFIG.saveBound(bound, true);
        }
    }

    @NotNull
    public Class<?> getReturnType() {
        if (this.WORLD) {
            return World.class;
        }
        return Integer.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String type = "";
        String lesser = "";
        if (this.WORLD) {
            type = "world";
        } else {
            if (this.LESSER) {
                lesser = "lesser ";
            }
            if (this.parse == 0) {
                type = "x coord";
            } else if (this.parse == 1) {
                type = "y coord";
            } else if (this.parse == 2) {
                type = "z coord";
            }
        }
        return lesser + type + " of bound " + this.getExpr().toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBoundCoords.class, Object.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"lesser (x|1:y|2:z) coord[inate] of [bound] %bound%", "greater (x|1:y|2:z) coord[inate] of [bound] %bound%", "world of bound %bound%"});
    }
}

