/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bound.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.EffectSection;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.bound.Bound;
import com.shanebeestudios.skbee.api.bound.BoundConfig;
import com.shanebeestudios.skbee.api.event.bound.BoundCreateEvent;
import com.shanebeestudios.skbee.elements.bound.expressions.ExprLastCreatedBound;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bound - Copy Bound")
@Description(value={"Create an exact replica of an existing bound with a new id."})
@Examples(value={"create a copy of bound with id \"some_bound\" with id \"some_bound_copy\"", "create a copy of bound with id \"some_bound\" with id \"some_bound_copy\":", "\tresize the bound between {_pos1} and {_pos2}", "\tadd {_player} to bound owners of bound"})
@Since(value={"2.15.0"})
public class EffSecBoundCopy
extends EffectSection {
    private static final BoundConfig BOUND_CONFIG = SkBee.getPlugin().getBoundConfig();
    private Expression<Bound> bound;
    private Expression<String> id;
    private Trigger trigger;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, @Nullable SectionNode sectionNode, @Nullable List<TriggerItem> list) {
        this.bound = exprs[0];
        this.id = exprs[1];
        if (sectionNode != null) {
            AtomicBoolean delayed = new AtomicBoolean(false);
            Runnable afterLoading = () -> delayed.set(!this.getParser().getHasDelayBefore().isFalse());
            this.trigger = this.loadCode(sectionNode, "bound copy", afterLoading, new Class[]{BoundCreateEvent.class});
            if (delayed.get()) {
                Skript.error((String)"Delays can't be within a Copy Bound section.");
                return false;
            }
        }
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        Bound newBound;
        Object localVars = Variables.copyLocalVariables((Event)event);
        Bound boundToCopy = (Bound)this.bound.getSingle(event);
        String id = (String)this.id.getSingle(event);
        if (id == null || boundToCopy == null) {
            return super.walk(event, false);
        }
        ExprLastCreatedBound.lastCreated = newBound = boundToCopy.copy(id);
        if (this.trigger != null) {
            BoundCreateEvent boundCreateEvent = new BoundCreateEvent(newBound);
            Variables.setLocalVariables((Event)boundCreateEvent, (Object)localVars);
            TriggerItem.walk((TriggerItem)this.trigger, (Event)boundCreateEvent);
            Variables.setLocalVariables((Event)event, (Object)Variables.copyLocalVariables((Event)boundCreateEvent));
            Variables.removeLocals((Event)boundCreateEvent);
        }
        BOUND_CONFIG.saveBound(newBound, true);
        return super.walk(event, false);
    }

    @NotNull
    public String toString(Event event, boolean debug) {
        return "create a copy of bound " + this.bound.toString(event, debug) + " with id " + this.id.toString(event, debug);
    }

    static {
        Skript.registerSection(EffSecBoundCopy.class, (String[])new String[]{"create [a] copy of [bound] %bound% (with|using) [the] id %string%"});
    }
}

