/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="DisplayEntity - Block Display Blockdata")
@Description(value={"Represents the block data of a Block Display Entity.", "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details."})
@Examples(value={"set display block data of {_display} to oak_stairs[facing=south]"})
@Since(value={"2.8.0"})
public class ExprBlockDisplayBlock
extends SimplePropertyExpression<Entity, BlockData> {
    @Nullable
    public BlockData convert(Entity entity) {
        if (entity instanceof BlockDisplay) {
            BlockDisplay blockDisplay = (BlockDisplay)entity;
            return blockDisplay.getBlock();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{BlockData.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Entity[] entityArray;
        if (delta != null && (entityArray = delta[0]) instanceof BlockData) {
            BlockData blockData = (BlockData)entityArray;
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                if (!(entity instanceof BlockDisplay)) continue;
                BlockDisplay blockDisplay = (BlockDisplay)entity;
                blockDisplay.setBlock(blockData);
            }
        }
    }

    @NotNull
    public Class<? extends BlockData> getReturnType() {
        return BlockData.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "display block data";
    }

    static {
        ExprBlockDisplayBlock.register(ExprBlockDisplayBlock.class, BlockData.class, (String)"display block[ ]data", (String)"entities");
    }
}

