/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="DisplayEntity - Display Brightness")
@Description(value={"Represents the brightness attributes of a Display Entity.", "NOTE: Delete/reset will reset the Display Entity's brightness to match it's surroundings.", "NOTE: If this is not set in the first place, it will return nothing!", "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details."})
@Examples(value={"set display brightness of {_display} to displayBrightness(10,10)"})
@Since(value={"2.8.0"})
public class ExprDisplayBrightness
extends SimplePropertyExpression<Entity, Display.Brightness> {
    @Nullable
    public Display.Brightness convert(Entity entity) {
        if (entity instanceof Display) {
            Display display = (Display)entity;
            return display.getBrightness();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Display.Brightness.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Display.Brightness b;
        Object object;
        Display.Brightness brightness = delta != null && (object = delta[0]) instanceof Display.Brightness ? (b = (Display.Brightness)object) : null;
        for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
            if (!(entity instanceof Display)) continue;
            Display display = (Display)entity;
            display.setBrightness(brightness);
        }
    }

    @NotNull
    public Class<? extends Display.Brightness> getReturnType() {
        return Display.Brightness.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "display brightness";
    }

    static {
        ExprDisplayBrightness.register(ExprDisplayBrightness.class, Display.Brightness.class, (String)"display brightness", (String)"entities");
    }
}

